/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl3;

import com.badlogic.gdx.Files;
import com.badlogic.gdx.Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Application;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3Graphics;
import com.badlogic.gdx.backends.lwjgl3.Lwjgl3WindowListener;
import com.badlogic.gdx.graphics.Color;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

public class Lwjgl3ApplicationConfiguration {
    boolean disableAudio = false;
    int audioDeviceSimultaneousSources = 16;
    int audioDeviceBufferSize = 512;
    int audioDeviceBufferCount = 9;
    boolean useGL30 = false;
    int gles30ContextMajorVersion = 3;
    int gles30ContextMinorVersion = 2;
    int r = 8;
    int g = 8;
    int b = 8;
    int a = 8;
    int depth = 16;
    int stencil = 0;
    int samples = 0;
    int windowX = -1;
    int windowY = -1;
    int windowWidth = 640;
    int windowHeight = 480;
    int windowMinWidth = -1;
    int windowMinHeight = -1;
    int windowMaxWidth = -1;
    int windowMaxHeight = -1;
    boolean windowResizable = true;
    boolean windowDecorated = true;
    Lwjgl3WindowListener windowListener;
    Lwjgl3Graphics.Lwjgl3DisplayMode fullscreenMode;
    boolean vSyncEnabled = true;
    String title = "";
    Color initialBackgroundColor = Color.BLACK;
    boolean initialVisible = true;
    String preferencesDirectory = ".prefs/";
    Files.FileType preferencesFileType = Files.FileType.External;
    HdpiMode hdpiMode = HdpiMode.Logical;

    static Lwjgl3ApplicationConfiguration copy(Lwjgl3ApplicationConfiguration config) {
        Lwjgl3ApplicationConfiguration copy = new Lwjgl3ApplicationConfiguration();
        copy.disableAudio = config.disableAudio;
        copy.audioDeviceSimultaneousSources = config.audioDeviceSimultaneousSources;
        copy.audioDeviceBufferSize = config.audioDeviceBufferSize;
        copy.audioDeviceBufferCount = config.audioDeviceBufferCount;
        copy.useGL30 = config.useGL30;
        copy.gles30ContextMajorVersion = config.gles30ContextMajorVersion;
        copy.gles30ContextMinorVersion = config.gles30ContextMinorVersion;
        copy.r = config.r;
        copy.g = config.g;
        copy.b = config.b;
        copy.a = config.a;
        copy.depth = config.depth;
        copy.stencil = config.stencil;
        copy.samples = config.samples;
        copy.windowX = config.windowX;
        copy.windowY = config.windowY;
        copy.windowWidth = config.windowWidth;
        copy.windowHeight = config.windowHeight;
        copy.windowMinWidth = config.windowMinWidth;
        copy.windowMinHeight = config.windowMinHeight;
        copy.windowMaxWidth = config.windowMaxWidth;
        copy.windowMaxHeight = config.windowMaxHeight;
        copy.windowResizable = config.windowResizable;
        copy.windowDecorated = config.windowDecorated;
        copy.windowListener = config.windowListener;
        copy.fullscreenMode = config.fullscreenMode;
        copy.vSyncEnabled = config.vSyncEnabled;
        copy.title = config.title;
        copy.initialBackgroundColor = config.initialBackgroundColor;
        copy.initialVisible = config.initialVisible;
        copy.preferencesDirectory = config.preferencesDirectory;
        copy.preferencesFileType = config.preferencesFileType;
        copy.hdpiMode = config.hdpiMode;
        return copy;
    }

    public void setInitialVisible(boolean visibility) {
        this.initialVisible = visibility;
    }

    public void disableAudio(boolean disableAudio) {
        this.disableAudio = disableAudio;
    }

    public void setAudioConfig(int simultaniousSources, int bufferSize, int bufferCount) {
        this.audioDeviceSimultaneousSources = simultaniousSources;
        this.audioDeviceBufferSize = bufferSize;
        this.audioDeviceBufferCount = bufferCount;
    }

    public void useOpenGL3(boolean useGL30, int gles3MajorVersion, int gles3MinorVersion) {
        this.useGL30 = useGL30;
        this.gles30ContextMajorVersion = gles3MajorVersion;
        this.gles30ContextMinorVersion = gles3MinorVersion;
    }

    public void setBackBufferConfig(int r, int g, int b, int a, int depth, int stencil, int samples) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.depth = depth;
        this.stencil = stencil;
        this.samples = samples;
    }

    public void setWindowedMode(int width, int height) {
        this.windowWidth = width;
        this.windowHeight = height;
    }

    public void setResizable(boolean resizable) {
        this.windowResizable = resizable;
    }

    public void setDecorated(boolean decorated) {
        this.windowDecorated = decorated;
    }

    public void setWindowPosition(int x, int y) {
        this.windowX = x;
        this.windowY = y;
    }

    public void setWindowSizeLimits(int minWidth, int minHeight, int maxWidth, int maxHeight) {
        this.windowMinWidth = minWidth;
        this.windowMinHeight = minHeight;
        this.windowMaxWidth = maxWidth;
        this.windowMaxHeight = maxHeight;
    }

    public void setWindowListener(Lwjgl3WindowListener windowListener) {
        this.windowListener = windowListener;
    }

    public void setFullscreenMode(Graphics.DisplayMode mode) {
        this.fullscreenMode = (Lwjgl3Graphics.Lwjgl3DisplayMode)mode;
    }

    public void useVsync(boolean vsync) {
        this.vSyncEnabled = vsync;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setInitialBackgroundColor(Color color) {
        this.initialBackgroundColor = color;
    }

    public void setPreferencesConfig(String preferencesDirectory, Files.FileType preferencesFileType) {
        this.preferencesDirectory = preferencesDirectory;
        this.preferencesFileType = preferencesFileType;
    }

    public void setHdpiMode(HdpiMode mode) {
        this.hdpiMode = mode;
    }

    public static Graphics.DisplayMode getDisplayMode() {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode videoMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        return new Lwjgl3Graphics.Lwjgl3DisplayMode(GLFW.glfwGetPrimaryMonitor(), videoMode.width(), videoMode.height(), videoMode.refreshRate(), videoMode.redBits() + videoMode.greenBits() + videoMode.blueBits());
    }

    public static Graphics.DisplayMode getDisplayMode(Graphics.Monitor monitor) {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode videoMode = GLFW.glfwGetVideoMode(((Lwjgl3Graphics.Lwjgl3Monitor)monitor).monitorHandle);
        return new Lwjgl3Graphics.Lwjgl3DisplayMode(((Lwjgl3Graphics.Lwjgl3Monitor)monitor).monitorHandle, videoMode.width(), videoMode.height(), videoMode.refreshRate(), videoMode.redBits() + videoMode.greenBits() + videoMode.blueBits());
    }

    public static Graphics.DisplayMode[] getDisplayModes() {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode.Buffer videoModes = GLFW.glfwGetVideoModes(GLFW.glfwGetPrimaryMonitor());
        Graphics.DisplayMode[] result = new Graphics.DisplayMode[videoModes.limit()];
        for (int i = 0; i < result.length; ++i) {
            GLFWVidMode videoMode = (GLFWVidMode)videoModes.get(i);
            result[i] = new Lwjgl3Graphics.Lwjgl3DisplayMode(GLFW.glfwGetPrimaryMonitor(), videoMode.width(), videoMode.height(), videoMode.refreshRate(), videoMode.redBits() + videoMode.greenBits() + videoMode.blueBits());
        }
        return result;
    }

    public static Graphics.DisplayMode[] getDisplayModes(Graphics.Monitor monitor) {
        Lwjgl3Application.initializeGlfw();
        GLFWVidMode.Buffer videoModes = GLFW.glfwGetVideoModes(((Lwjgl3Graphics.Lwjgl3Monitor)monitor).monitorHandle);
        Graphics.DisplayMode[] result = new Graphics.DisplayMode[videoModes.limit()];
        for (int i = 0; i < result.length; ++i) {
            GLFWVidMode videoMode = (GLFWVidMode)videoModes.get(i);
            result[i] = new Lwjgl3Graphics.Lwjgl3DisplayMode(((Lwjgl3Graphics.Lwjgl3Monitor)monitor).monitorHandle, videoMode.width(), videoMode.height(), videoMode.refreshRate(), videoMode.redBits() + videoMode.greenBits() + videoMode.blueBits());
        }
        return result;
    }

    public static Graphics.Monitor getPrimaryMonitor() {
        Lwjgl3Application.initializeGlfw();
        return Lwjgl3ApplicationConfiguration.toLwjgl3Monitor(GLFW.glfwGetPrimaryMonitor());
    }

    public static Graphics.Monitor[] getMonitors() {
        Lwjgl3Application.initializeGlfw();
        PointerBuffer glfwMonitors = GLFW.glfwGetMonitors();
        Graphics.Monitor[] monitors = new Graphics.Monitor[glfwMonitors.limit()];
        for (int i = 0; i < glfwMonitors.limit(); ++i) {
            monitors[i] = Lwjgl3ApplicationConfiguration.toLwjgl3Monitor(glfwMonitors.get(i));
        }
        return monitors;
    }

    static Lwjgl3Graphics.Lwjgl3Monitor toLwjgl3Monitor(long glfwMonitor) {
        IntBuffer tmp = BufferUtils.createIntBuffer(1);
        IntBuffer tmp2 = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetMonitorPos(glfwMonitor, tmp, tmp2);
        int virtualX = tmp.get(0);
        int virtualY = tmp2.get(0);
        String name = GLFW.glfwGetMonitorName(glfwMonitor);
        return new Lwjgl3Graphics.Lwjgl3Monitor(glfwMonitor, virtualX, virtualY, name);
    }

    public static enum HdpiMode {
        Logical,
        Pixels;

    }
}

