/*
 * Decompiled with CFR 0.152.
 */
package com.invrs.tov;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.invrs.tov.Assets;
import com.invrs.tov.HomeScreen;
import com.invrs.tov.MainMenuScreen;
import com.invrs.tov.SevenSages;

public class Credits
implements Screen {
    final SevenSages game;
    OrthographicCamera camera;
    private Viewport viewport;
    private Animation candleanim;
    private Sprite black;
    private Sprite flame;
    private Sprite candle;
    private float darkness;
    private float stateTime;
    private float textHeight;
    private float waitTimer;
    private float musicFade;
    private boolean musicStarted;
    private boolean end;
    private String words;
    private Music music1;
    private Music music2;

    public Credits(SevenSages gam) {
        this.game = gam;
        this.stateTime = 0.0f;
        this.waitTimer = 0.0f;
        this.musicFade = 0.0f;
        InputHandler key = new InputHandler();
        Gdx.input.setInputProcessor(key);
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, this.game.settings.screenWidth, this.game.settings.screenHeight);
        this.viewport = new FitViewport(this.game.settings.screenWidth, (float)this.game.settings.screenHeight, this.camera);
        this.music1 = Assets.manager.get("audio/The Seven Sages.mp3", Music.class);
        this.music1.setVolume(1.0f);
        this.music2 = Assets.manager.get("audio/Truth.ogg", Music.class);
        this.music2.setLooping(true);
        this.music2.setVolume(1.0f);
        this.game.font1.getData().setScale(this.game.settings.x(0.5f), this.game.settings.y(0.5f));
        Texture candlesheet = Assets.manager.get("images/candlesheet.png", Texture.class);
        this.candle = new Sprite(new TextureRegion(candlesheet, 172, 144, 86, 144));
        this.candle.setSize(this.game.settings.x(344.0f), this.game.settings.y(576.0f));
        this.candle.setPosition((float)this.game.settings.screenWidth * 0.15f, 0.0f);
        this.flame = new Sprite();
        this.flame.setSize(this.game.settings.x(344.0f), this.game.settings.y(576.0f));
        this.flame.setPosition((float)this.game.settings.screenWidth * 0.15f, 0.0f);
        this.candleanim = new Animation(0.1f, new TextureRegion(candlesheet, 0, 0, 86, 144), new TextureRegion(candlesheet, 86, 0, 86, 144), new TextureRegion(candlesheet, 172, 0, 86, 144), new TextureRegion(candlesheet, 258, 0, 86, 144), new TextureRegion(candlesheet, 344, 0, 86, 144), new TextureRegion(candlesheet, 430, 0, 86, 144), new TextureRegion(candlesheet, 516, 0, 86, 144), new TextureRegion(candlesheet, 602, 0, 86, 144), new TextureRegion(candlesheet, 688, 0, 86, 144), new TextureRegion(candlesheet, 774, 0, 86, 144), new TextureRegion(candlesheet, 860, 0, 86, 144), new TextureRegion(candlesheet, 0, 144, 86, 144), new TextureRegion(candlesheet, 86, 144, 86, 144), new TextureRegion(candlesheet, 0, 0, 86, 144), new TextureRegion(candlesheet, 86, 0, 86, 144), new TextureRegion(candlesheet, 172, 0, 86, 144), new TextureRegion(candlesheet, 258, 0, 86, 144), new TextureRegion(candlesheet, 344, 0, 86, 144), new TextureRegion(candlesheet, 430, 0, 86, 144), new TextureRegion(candlesheet, 516, 0, 86, 144), new TextureRegion(candlesheet, 602, 0, 86, 144));
        this.musicStarted = false;
        this.end = false;
        this.darkness = 1.0f;
        this.black = new Sprite(new Texture(Gdx.files.internal("images/black.png")));
        this.black.setPosition(0.0f, 0.0f);
        this.black.setSize(this.game.settings.screenWidth, this.game.settings.screenHeight);
        this.black.setAlpha(this.darkness);
        this.textHeight = -100.0f;
        this.words = "Created by\nGhost From The Void\n\n\n\n\nMarty Magaan\n~~~~Game Designer\n~~~~Programmer\n~~~~Artist\n~~~~Lead Writer\n~~~~Music & Sound\n\n\n\n\nScript Editor\n\n~~~Alex De-Gruchy\n\n\n\nGuest Composer\n\n~~~Pixel Noise\n~~~`Catherine's Dream\"\n\n\n\nGuest Writers\n\n~~~Paolo Rubin\n\n~~~~~~The Fallacy of Pelmont Moore\n~~~~~~by Quintello Avan\n\n~~~~~~The Ghost of Pelmont\n~~~~~~by Quintello Avan\n\n\n\n\n~~~Justin Hellstrom\n\n~~~~~~Animal Ink\n~~~~~~by Robert Charleston\n\n\n\n\n~~~Alex De-Gruchy\n\n~~~~~~The Day I Met The Noose\n~~~~~~by Randolph Cassan\n\n~~~~~~The Stained Sage\n~~~~~~by Brother Theodore Maul\n\n\n\n\n~~~Lee Williams\n\n~~~~~~The Snow Leopard\n~~~~~~by Balar Tsim\n\n~~~~~~The Tailor's Suit\n~~~~~~by Pietr Freiman\n\n\n\n\n~~~Dylan Wedlake\n\n~~~~~~Plague Comes To Scaltro\n~~~~~~by Drake Crowther\n\n\n\n\n~~~Tiana Yarbrough\n\n~~~~~~The Maiden of the Wood\n~~~~~~by Laila Harte\n\n\n\n\n\n\n\nInspired by `The Secret of Psalm 46\"\nby Brian Moriarty\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nThank you for playing!";
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.stateTime += Gdx.graphics.getDeltaTime();
        if (!this.musicStarted && this.stateTime > 2.0f) {
            if (this.game.settings.savedState) {
                this.music1.play();
            } else {
                this.music2.play();
            }
            this.musicStarted = true;
        }
        if (this.stateTime > 3.0f && this.stateTime < 12.0f && !this.end) {
            this.darkness -= 0.2f * Gdx.graphics.getDeltaTime();
            if (this.darkness <= 0.0f) {
                this.darkness = 0.0f;
            }
            this.black.setAlpha(this.darkness);
        }
        if (!this.game.settings.savedState && this.stateTime > 2.0f) {
            this.musicFade += 0.2f * Gdx.graphics.getDeltaTime();
            if (this.musicFade >= 1.0f) {
                this.musicFade = 1.0f;
            }
            this.music2.setVolume(this.musicFade);
        }
        if (this.stateTime >= 115.0f || this.end) {
            this.darkness = this.end ? (this.darkness += 1.0f * Gdx.graphics.getDeltaTime()) : (this.darkness <= 0.9f ? (this.darkness += 0.1f * Gdx.graphics.getDeltaTime()) : (this.darkness += 0.05f * Gdx.graphics.getDeltaTime()));
            if (this.darkness >= 1.0f) {
                this.darkness = 1.0f;
            }
            this.black.setAlpha(this.darkness);
            if (this.game.settings.savedState) {
                this.music1.setVolume(1.0f - this.darkness);
            } else {
                this.music2.setVolume(1.0f - this.darkness);
            }
            if (this.darkness == 1.0f) {
                this.waitTimer += Gdx.graphics.getDeltaTime();
                if (this.game.settings.savedState) {
                    this.music1.stop();
                } else {
                    this.music2.stop();
                }
                if (this.waitTimer >= 2.0f) {
                    if (this.game.settings.savedState) {
                        this.game.settings.loadedState = true;
                        this.game.settings.savedState = false;
                        this.game.setScreen(new HomeScreen(this.game));
                    } else {
                        this.game.setScreen(new MainMenuScreen(this.game));
                    }
                }
            }
        }
        if (this.stateTime > 4.0f) {
            this.textHeight += 40.0f * Gdx.graphics.getDeltaTime();
        }
        Gdx.gl.glClear(16384);
        this.game.batch.begin();
        this.flame.setRegion(this.candleanim.getKeyFrame(this.stateTime, true));
        this.candle.draw(this.game.batch);
        this.flame.draw(this.game.batch);
        this.game.font1.draw((Batch)this.game.batch, this.words, (float)this.game.settings.screenHeight * 0.15f + this.candle.getWidth() + 100.0f, this.textHeight);
        this.black.setAlpha(this.darkness);
        this.black.draw(this.game.batch);
        this.game.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    private class InputHandler
    implements InputProcessor {
        private InputHandler() {
        }

        @Override
        public boolean keyDown(int keycode) {
            if ((keycode == 62 || keycode == 131 || keycode == 66 || keycode == 32) && Credits.this.stateTime > 2.0f) {
                Credits.this.end = true;
            }
            return false;
        }

        @Override
        public boolean keyUp(int keycode) {
            return false;
        }

        @Override
        public boolean keyTyped(char character) {
            return false;
        }

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchDragged(int screenX, int screenY, int pointer) {
            return false;
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            return false;
        }

        @Override
        public boolean scrolled(int amount) {
            Credits.this.camera.position.y += (float)(-(amount * 100));
            return false;
        }
    }
}

