/*
 * Decompiled with CFR 0.152.
 */
package com.invrs.tov;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Screen;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Animation;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.viewport.FitViewport;
import com.badlogic.gdx.utils.viewport.Viewport;
import com.invrs.tov.Assets;
import com.invrs.tov.HomeScreen;
import com.invrs.tov.SevenSages;

public class Introduction
implements Screen {
    final SevenSages game;
    private OrthographicCamera camera;
    private Viewport viewport;
    private Animation candleanim;
    private Sprite black;
    private Sprite flame;
    private Sprite candle;
    private Sprite civ;
    private Sprite pyramid;
    private Sprite flood;
    private Sprite book;
    private float darkness;
    private float startDelay;
    private float imageAlpha;
    private float imageScale;
    private float imageX;
    private float imageY;
    private float candleX;
    private float stateTime;
    private float textalpha;
    private float textspeed;
    private float scriptTimer;
    private float waitTimer;
    private float textHeight;
    private float prevHeight;
    private boolean waiting;
    private boolean transitioning;
    private boolean start;
    private boolean musicStarted;
    private boolean skip;
    private StringBuffer text;
    private char[] script;
    private String words;
    private Music music;
    private int scrollUp;
    private int charNum;
    private int imageQueue;
    private int imageFade;

    public Introduction(SevenSages gam) {
        this.game = gam;
        this.stateTime = 0.0f;
        this.waitTimer = 0.0f;
        this.scriptTimer = 0.0f;
        this.imageQueue = 0;
        this.imageAlpha = 0.0f;
        this.imageScale = 0.8f;
        this.candleX = this.game.settings.centerX - 68;
        this.startDelay = 0.0f;
        InputHandler key = new InputHandler();
        Gdx.input.setInputProcessor(key);
        this.camera = new OrthographicCamera();
        this.camera.setToOrtho(false, this.game.settings.screenWidth, this.game.settings.screenHeight);
        this.viewport = new FitViewport(this.game.settings.screenWidth, (float)this.game.settings.screenHeight, this.camera);
        this.music = Assets.manager.get("audio/The Seven Sages.mp3", Music.class);
        this.music.setVolume(1.0f);
        this.game.writingbig.getData().setScale((float)this.game.settings.screenWidth / 1920.0f);
        Texture introimages = Assets.manager.get("images/introimages.png", Texture.class);
        Texture candlesheet = Assets.manager.get("images/candlesheet.png", Texture.class);
        this.candle = new Sprite(new TextureRegion(candlesheet, 172, 144, 86, 144));
        this.candle.setSize(this.game.settings.x(344.0f), this.game.settings.y(576.0f));
        this.candle.setPosition(this.candleX, 0.0f);
        this.flame = new Sprite();
        this.flame.setSize(this.game.settings.x(344.0f), this.game.settings.y(576.0f));
        this.flame.setPosition(this.candleX, 0.0f);
        this.candleanim = new Animation(0.1f, new TextureRegion(candlesheet, 0, 0, 86, 144), new TextureRegion(candlesheet, 86, 0, 86, 144), new TextureRegion(candlesheet, 172, 0, 86, 144), new TextureRegion(candlesheet, 258, 0, 86, 144), new TextureRegion(candlesheet, 344, 0, 86, 144), new TextureRegion(candlesheet, 430, 0, 86, 144), new TextureRegion(candlesheet, 516, 0, 86, 144), new TextureRegion(candlesheet, 602, 0, 86, 144), new TextureRegion(candlesheet, 688, 0, 86, 144), new TextureRegion(candlesheet, 774, 0, 86, 144), new TextureRegion(candlesheet, 860, 0, 86, 144), new TextureRegion(candlesheet, 0, 144, 86, 144), new TextureRegion(candlesheet, 86, 144, 86, 144), new TextureRegion(candlesheet, 0, 0, 86, 144), new TextureRegion(candlesheet, 86, 0, 86, 144), new TextureRegion(candlesheet, 172, 0, 86, 144), new TextureRegion(candlesheet, 258, 0, 86, 144), new TextureRegion(candlesheet, 344, 0, 86, 144), new TextureRegion(candlesheet, 430, 0, 86, 144), new TextureRegion(candlesheet, 516, 0, 86, 144), new TextureRegion(candlesheet, 602, 0, 86, 144));
        this.imageX = (float)this.game.settings.screenWidth * 0.1f + this.candle.getWidth();
        this.imageY = (float)this.game.settings.centerY - this.game.settings.y(200.0f);
        this.civ = new Sprite(new TextureRegion(introimages, 0, 0, 222, 127));
        this.civ.setSize(this.game.settings.x(666.0f), this.game.settings.y(381.0f));
        this.civ.setPosition(this.imageX, this.imageY);
        this.civ.setAlpha(0.0f);
        this.pyramid = new Sprite(new TextureRegion(introimages, 222, 0, 179, 127));
        this.pyramid.setSize(this.game.settings.x(537.0f), this.game.settings.x(381.0f));
        this.pyramid.setPosition(this.imageX, this.imageY);
        this.pyramid.setAlpha(0.0f);
        this.flood = new Sprite(new TextureRegion(introimages, 0, 127, 222, 127));
        this.flood.setSize(this.game.settings.x(666.0f), this.game.settings.y(381.0f));
        this.flood.setPosition(this.imageX, this.imageY);
        this.flood.setAlpha(0.0f);
        this.book = new Sprite(new TextureRegion(introimages, 222, 127, 179, 127));
        this.book.setSize(this.game.settings.x(537.0f), this.game.settings.y(381.0f));
        this.book.setPosition(this.imageX, this.imageY);
        this.book.setAlpha(0.0f);
        this.waiting = false;
        this.transitioning = false;
        this.start = false;
        this.imageFade = 0;
        this.musicStarted = false;
        this.skip = false;
        this.darkness = 1.0f;
        this.black = new Sprite(new Texture(Gdx.files.internal("images/black.png")));
        this.black.setPosition(0.0f, 0.0f);
        this.black.setSize(this.game.settings.screenWidth, this.game.settings.screenHeight);
        this.black.setAlpha(this.darkness);
        this.textspeed = 0.07f;
        this.textalpha = 1.0f;
        this.textHeight = this.game.settings.centerY - 100;
        this.prevHeight = 0.0f;
        this.scrollUp = 0;
        this.charNum = 0;
        this.words = "~~~~~Long ago, before our current era@\n~~~the great civilization of Adom ruled\n~~~~~~over most of the known world.@@@@@@@@@@@@@@@@$@@@~~During this time, humankind experienced \n~a Golden Age,@@ a time that saw unprecedented \n~~~~advances in the sciences and arts%. @@@@@@@@@@@$@@@@@~~~~These achievements were attributed \n~~~~~~~~to seven historical figures.@@@@@\n~~~~They were known as the Seven Sages,@@@\n~~~~the greatest minds of the Golden Ag%e.@@@@@@@@@@@@@@@@$@@@@@@~~~~When a Great Flood ravaged the world,@\n~~~~~~~the civilization of Adom fell@@\n~~~~~~and the Golden Age of humankind \n~~~~~~~~~~~~came to an end.@@@@@\n~~~The knowledge of the Seven Sages was lost \n~~and forgotten,@ and an era of darkness began,@\n~~~~lasting for over one %thousand years@ .@ .@ .@@@@@@$@@@@@~until one fateful day,@ when ancient texts from\n~~~the lost civilization were found,@ and the \n~knowledge of the Golden Age was rediscovered.@@@@\n~~~~~Stories of the seven greatest minds \n~~~~~~~of a lost era began to spread.@@@@\n  \n~~~~~~The Seven Sages became legends.@@@@@%@@@@@@@@@@@@@@@$#";
        this.script = this.words.toCharArray();
        this.text = new StringBuffer("");
    }

    @Override
    public void render(float delta) {
        Gdx.gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.camera.update();
        this.game.batch.setProjectionMatrix(this.camera.combined);
        this.stateTime += Gdx.graphics.getDeltaTime();
        if (!this.musicStarted && this.stateTime > 2.0f) {
            this.music.play();
            this.musicStarted = true;
        }
        if (this.stateTime > 4.0f && this.stateTime < 12.0f) {
            this.darkness -= 0.2f * Gdx.graphics.getDeltaTime();
            if (this.darkness <= 0.0f) {
                this.darkness = 0.0f;
            }
            this.black.setAlpha(this.darkness);
        }
        if (this.stateTime > 10.0f && this.stateTime < 13.0f) {
            this.candleX -= 250.0f * Gdx.graphics.getDeltaTime();
            if (this.candleX <= (float)this.game.settings.screenWidth * 0.2f) {
                this.candleX = (float)this.game.settings.screenWidth * 0.2f;
            }
            this.candle.setPosition(this.candleX, 0.0f);
            this.flame.setPosition(this.candleX, 0.0f);
        }
        if (this.stateTime > 13.0f && this.stateTime < 13.5f) {
            this.start = true;
            this.imageFade = 1;
            this.imageQueue = 1;
        }
        if (this.imageQueue == 5 || this.skip) {
            this.darkness = this.darkness <= 0.3f ? (this.skip ? (this.darkness += 0.5f * Gdx.graphics.getDeltaTime()) : (this.darkness += 0.3f * Gdx.graphics.getDeltaTime())) : (this.darkness <= 0.5f ? (this.skip ? (this.darkness += 0.5f * Gdx.graphics.getDeltaTime()) : (this.darkness += 0.2f * Gdx.graphics.getDeltaTime())) : (this.darkness <= 0.9f ? (this.skip ? (this.darkness += 0.5f * Gdx.graphics.getDeltaTime()) : (this.darkness += 0.1f * Gdx.graphics.getDeltaTime())) : (this.skip ? (this.darkness += 0.5f * Gdx.graphics.getDeltaTime()) : (this.darkness += 0.05f * Gdx.graphics.getDeltaTime()))));
            if (this.darkness >= 1.0f) {
                this.darkness = 1.0f;
            }
            this.black.setAlpha(this.darkness);
            this.music.setVolume(1.0f - this.darkness);
            if (this.darkness == 1.0f) {
                this.startDelay += Gdx.graphics.getDeltaTime();
                if (this.startDelay > 3.0f) {
                    this.game.setScreen(new HomeScreen(this.game));
                }
            }
        }
        if (this.start) {
            if (this.stateTime > 0.0f && !this.waiting && !this.transitioning) {
                this.scriptTimer += Gdx.graphics.getDeltaTime();
                if (this.scriptTimer >= this.textspeed) {
                    if (this.script[this.charNum] == '@') {
                        this.waiting = true;
                    } else if (this.script[this.charNum] == '$') {
                        this.transitioning = true;
                    } else if (this.script[this.charNum] == '%') {
                        this.imageFade = 2;
                    } else {
                        if (this.script[this.charNum] != '#') {
                            this.text.append(this.script[this.charNum]);
                        }
                        if (this.script[this.charNum] == '\n') {
                            this.scrollUp = 1;
                        }
                        if (this.script[this.charNum] != '~') {
                            this.scriptTimer = 0.0f;
                        }
                    }
                    if (this.script[this.charNum] != '#') {
                        ++this.charNum;
                    }
                }
            }
            if (this.scrollUp == 1 && !this.waiting && !this.transitioning) {
                this.prevHeight = this.textHeight;
                ++this.scrollUp;
            } else if (this.scrollUp == 2 && !this.waiting) {
                this.textHeight += 200.0f * Gdx.graphics.getDeltaTime();
                if (this.textHeight - this.prevHeight >= 40.0f) {
                    this.textHeight = this.prevHeight + 40.0f;
                    this.scrollUp = 0;
                }
            }
            if (this.transitioning) {
                this.textalpha -= 0.6f * Gdx.graphics.getDeltaTime();
                if (this.textalpha <= 0.0f) {
                    this.textalpha = 1.0f;
                    this.textHeight = this.game.settings.centerY - 100;
                    this.text = new StringBuffer("");
                    this.transitioning = false;
                }
            }
            if (this.waiting) {
                this.waitTimer += Gdx.graphics.getDeltaTime();
                if (this.waitTimer > 0.3f) {
                    this.waiting = false;
                    this.waitTimer = 0.0f;
                }
            }
        }
        if (this.imageFade == 1) {
            this.imageAlpha += 0.07f * Gdx.graphics.getDeltaTime();
            if (this.imageAlpha >= 0.5f) {
                this.imageAlpha = 0.5f;
            }
        } else if (this.imageFade == 2) {
            this.imageAlpha -= 0.07f * Gdx.graphics.getDeltaTime();
            if (this.imageAlpha <= 0.0f) {
                this.imageAlpha = 0.0f;
                this.imageScale = 0.8f;
                this.imageX = (float)this.game.settings.screenWidth * 0.1f + this.candle.getWidth();
                this.imageY = (float)this.game.settings.centerY - this.game.settings.y(300.0f);
                this.imageFade = 1;
                ++this.imageQueue;
            }
        }
        if (this.imageQueue > 0) {
            this.imageScale += 0.02f * Gdx.graphics.getDeltaTime();
            this.imageX -= this.game.settings.x(5.0f) * Gdx.graphics.getDeltaTime();
            this.imageY -= this.game.settings.y(5.0f) * Gdx.graphics.getDeltaTime();
        }
        if (this.imageQueue == 1) {
            this.civ.setAlpha(this.imageAlpha);
            this.civ.setSize(this.game.settings.x(666.0f) * this.imageScale, this.game.settings.y(381.0f) * this.imageScale);
            this.civ.setPosition(this.imageX, this.imageY);
        } else if (this.imageQueue == 2) {
            this.pyramid.setAlpha(this.imageAlpha);
            this.pyramid.setSize(this.game.settings.x(537.0f) * this.imageScale, this.game.settings.y(381.0f) * this.imageScale);
            this.pyramid.setPosition(this.imageX, this.imageY);
        } else if (this.imageQueue == 3) {
            this.flood.setAlpha(this.imageAlpha);
            this.flood.setSize(this.game.settings.x(666.0f) * this.imageScale, this.game.settings.y(381.0f) * this.imageScale);
            this.flood.setPosition(this.imageX, this.imageY);
        } else if (this.imageQueue == 4) {
            this.book.setAlpha(this.imageAlpha);
            this.book.setSize(this.game.settings.x(537.0f) * this.imageScale, this.game.settings.y(381.0f) * this.imageScale);
            this.book.setPosition(this.imageX, this.imageY);
        }
        Gdx.gl.glClear(16384);
        this.game.batch.begin();
        this.flame.setRegion(this.candleanim.getKeyFrame(this.stateTime, true));
        this.candle.draw(this.game.batch);
        this.flame.draw(this.game.batch);
        if (this.imageQueue == 1) {
            this.civ.draw(this.game.batch);
        } else if (this.imageQueue == 2) {
            this.pyramid.draw(this.game.batch);
        } else if (this.imageQueue == 3) {
            this.flood.draw(this.game.batch);
        } else if (this.imageQueue == 4) {
            this.book.draw(this.game.batch);
        }
        if (this.imageQueue != 5 && !this.skip) {
            this.game.writingbig.setColor(1.0f, 1.0f, 1.0f, this.textalpha);
        }
        this.game.writingbig.draw((Batch)this.game.batch, this.text, (float)this.game.settings.screenWidth * 0.1f + this.candle.getWidth(), this.textHeight);
        this.black.setAlpha(this.darkness);
        this.black.draw(this.game.batch);
        this.game.batch.end();
        this.textspeed = 0.05f;
    }

    @Override
    public void resize(int width, int height) {
        this.viewport.update(width, height);
    }

    @Override
    public void show() {
    }

    @Override
    public void hide() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void dispose() {
    }

    private class InputHandler
    implements InputProcessor {
        private InputHandler() {
        }

        @Override
        public boolean keyDown(int keycode) {
            if ((keycode == 62 || keycode == 131 || keycode == 66 || keycode == 32) && Introduction.this.stateTime > 4.5f) {
                Introduction.this.skip = true;
            }
            return false;
        }

        @Override
        public boolean keyUp(int keycode) {
            return false;
        }

        @Override
        public boolean keyTyped(char character) {
            return false;
        }

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchUp(int screenX, int screenY, int pointer, int button) {
            return false;
        }

        @Override
        public boolean touchDragged(int screenX, int screenY, int pointer) {
            return false;
        }

        @Override
        public boolean mouseMoved(int screenX, int screenY) {
            return false;
        }

        @Override
        public boolean scrolled(int amount) {
            ((Introduction)Introduction.this).camera.position.y += (float)(-(amount * 100));
            return false;
        }
    }
}

