/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EGL12 {
    public static final int EGL_ALPHA_FORMAT = 12424;
    public static final int EGL_ALPHA_FORMAT_NONPRE = 12427;
    public static final int EGL_ALPHA_FORMAT_PRE = 12428;
    public static final int EGL_ALPHA_MASK_SIZE = 12350;
    public static final int EGL_BUFFER_PRESERVED = 12436;
    public static final int EGL_BUFFER_DESTROYED = 12437;
    public static final int EGL_CLIENT_APIS = 12429;
    public static final int EGL_COLORSPACE = 12423;
    public static final int EGL_COLORSPACE_sRGB = 12425;
    public static final int EGL_COLORSPACE_LINEAR = 12426;
    public static final int EGL_COLOR_BUFFER_TYPE = 12351;
    public static final int EGL_CONTEXT_CLIENT_TYPE = 12439;
    public static final int EGL_DISPLAY_SCALING = 10000;
    public static final int EGL_HORIZONTAL_RESOLUTION = 12432;
    public static final int EGL_LUMINANCE_BUFFER = 12431;
    public static final int EGL_LUMINANCE_SIZE = 12349;
    public static final int EGL_OPENGL_ES_BIT = 1;
    public static final int EGL_OPENVG_BIT = 2;
    public static final int EGL_OPENGL_ES_API = 12448;
    public static final int EGL_OPENVG_API = 12449;
    public static final int EGL_OPENVG_IMAGE = 12438;
    public static final int EGL_PIXEL_ASPECT_RATIO = 12434;
    public static final int EGL_RENDERABLE_TYPE = 12352;
    public static final int EGL_RENDER_BUFFER = 12422;
    public static final int EGL_RGB_BUFFER = 12430;
    public static final int EGL_SINGLE_BUFFER = 12421;
    public static final int EGL_SWAP_BEHAVIOR = 12435;
    public static final int EGL_UNKNOWN = -1;
    public static final int EGL_VERTICAL_RESOLUTION = 12433;
    public final long BindAPI;
    public final long QueryAPI;
    public final long CreatePbufferFromClientBuffer;
    public final long ReleaseThread;
    public final long WaitClient;

    protected EGL12() {
        throw new UnsupportedOperationException();
    }

    public EGL12(FunctionProvider provider) {
        this.BindAPI = provider.getFunctionAddress("eglBindAPI");
        this.QueryAPI = provider.getFunctionAddress("eglQueryAPI");
        this.CreatePbufferFromClientBuffer = provider.getFunctionAddress("eglCreatePbufferFromClientBuffer");
        this.ReleaseThread = provider.getFunctionAddress("eglReleaseThread");
        this.WaitClient = provider.getFunctionAddress("eglWaitClient");
    }

    public static EGL12 getInstance() {
        return EGL12.getInstance(EGL.getCapabilities());
    }

    public static EGL12 getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EGL12);
    }

    public static boolean eglBindAPI(int api) {
        long __functionAddress = EGL12.getInstance().BindAPI;
        return JNI.callIZ(__functionAddress, api);
    }

    public static int eglQueryAPI() {
        long __functionAddress = EGL12.getInstance().QueryAPI;
        return JNI.callI(__functionAddress);
    }

    public static long neglCreatePbufferFromClientBuffer(long dpy, int buftype, long buffer, long config, long attrib_list) {
        long __functionAddress = EGL12.getInstance().CreatePbufferFromClientBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(buffer);
            Checks.checkPointer(config);
        }
        return JNI.callPIPPPP(__functionAddress, dpy, buftype, buffer, config, attrib_list);
    }

    public static long eglCreatePbufferFromClientBuffer(long dpy, int buftype, long buffer, long config, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return EGL12.neglCreatePbufferFromClientBuffer(dpy, buftype, buffer, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreatePbufferFromClientBuffer(long dpy, int buftype, long buffer, long config, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return EGL12.neglCreatePbufferFromClientBuffer(dpy, buftype, buffer, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglReleaseThread() {
        long __functionAddress = EGL12.getInstance().ReleaseThread;
        return JNI.callZ(__functionAddress);
    }

    public static boolean eglWaitClient() {
        long __functionAddress = EGL12.getInstance().WaitClient;
        return JNI.callZ(__functionAddress);
    }
}

