/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.egl.EGLDebugMessageKHRCallback;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class KHRDebug {
    public static final int EGL_OBJECT_THREAD_KHR = 13232;
    public static final int EGL_OBJECT_DISPLAY_KHR = 13233;
    public static final int EGL_OBJECT_CONTEXT_KHR = 13234;
    public static final int EGL_OBJECT_SURFACE_KHR = 13235;
    public static final int EGL_OBJECT_IMAGE_KHR = 13236;
    public static final int EGL_OBJECT_SYNC_KHR = 13237;
    public static final int EGL_OBJECT_STREAM_KHR = 13238;
    public static final int EGL_DEBUG_MSG_CRITICAL_KHR = 13241;
    public static final int EGL_DEBUG_MSG_ERROR_KHR = 13242;
    public static final int EGL_DEBUG_MSG_WARN_KHR = 13243;
    public static final int EGL_DEBUG_MSG_INFO_KHR = 13244;
    public static final int EGL_DEBUG_CALLBACK_KHR = 13240;
    public final long DebugMessageControlKHR;
    public final long QueryDebugKHR;
    public final long LabelObjectKHR;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    public KHRDebug(FunctionProvider provider) {
        this.DebugMessageControlKHR = provider.getFunctionAddress("eglDebugMessageControlKHR");
        this.QueryDebugKHR = provider.getFunctionAddress("eglQueryDebugKHR");
        this.LabelObjectKHR = provider.getFunctionAddress("eglLabelObjectKHR");
    }

    public static KHRDebug getInstance() {
        return KHRDebug.getInstance(EGL.getCapabilities());
    }

    public static KHRDebug getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRDebug);
    }

    public static int neglDebugMessageControlKHR(long callback, long attrib_list) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageControlKHR;
        return JNI.callPPI(__functionAddress, callback, attrib_list);
    }

    public static int eglDebugMessageControlKHR(EGLDebugMessageKHRCallback callback, ByteBuffer attrib_list) {
        return KHRDebug.neglDebugMessageControlKHR(callback.address(), MemoryUtil.memAddressSafe(attrib_list));
    }

    public static int eglDebugMessageControlKHR(EGLDebugMessageKHRCallback callback, PointerBuffer attrib_list) {
        return KHRDebug.neglDebugMessageControlKHR(callback.address(), MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean neglQueryDebugKHR(int attribute, long value) {
        long __functionAddress = KHRDebug.getInstance().QueryDebugKHR;
        return JNI.callIPZ(__functionAddress, attribute, value);
    }

    public static boolean eglQueryDebugKHR(int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return KHRDebug.neglQueryDebugKHR(attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryDebugKHR(int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return KHRDebug.neglQueryDebugKHR(attribute, MemoryUtil.memAddress(value));
    }

    public static int eglLabelObjectKHR(long display, int objectType, long object, long label) {
        long __functionAddress = KHRDebug.getInstance().LabelObjectKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(object);
            Checks.checkPointer(label);
        }
        return JNI.callPIPPI(__functionAddress, display, objectType, object, label);
    }
}

