/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRImageBase {
    public static final int EGL_IMAGE_PRESERVED_KHR = 12498;
    public static final long EGL_NO_IMAGE_KHR = 0L;
    public final long CreateImageKHR;
    public final long DestroyImageKHR;

    protected KHRImageBase() {
        throw new UnsupportedOperationException();
    }

    public KHRImageBase(FunctionProvider provider) {
        this.CreateImageKHR = provider.getFunctionAddress("eglCreateImageKHR");
        this.DestroyImageKHR = provider.getFunctionAddress("eglDestroyImageKHR");
    }

    public static KHRImageBase getInstance() {
        return KHRImageBase.getInstance(EGL.getCapabilities());
    }

    public static KHRImageBase getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRImageBase);
    }

    public static long neglCreateImageKHR(long dpy, long ctx, int target, long buffer, long attrib_list) {
        long __functionAddress = KHRImageBase.getInstance().CreateImageKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(ctx);
            Checks.checkPointer(buffer);
        }
        return JNI.callPPIPPP(__functionAddress, dpy, ctx, target, buffer, attrib_list);
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRImageBase.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateImageKHR(long dpy, long ctx, int target, long buffer, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRImageBase.neglCreateImageKHR(dpy, ctx, target, buffer, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroyImageKHR(long dpy, long image) {
        long __functionAddress = KHRImageBase.getInstance().DestroyImageKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(image);
        }
        return JNI.callPPZ(__functionAddress, dpy, image);
    }
}

