/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRReusableSync {
    public static final int EGL_SYNC_STATUS_KHR = 12529;
    public static final int EGL_SIGNALED_KHR = 12530;
    public static final int EGL_UNSIGNALED_KHR = 12531;
    public static final int EGL_TIMEOUT_EXPIRED_KHR = 12533;
    public static final int EGL_CONDITION_SATISFIED_KHR = 12534;
    public static final int EGL_SYNC_TYPE_KHR = 12535;
    public static final int EGL_SYNC_REUSABLE_KHR = 12538;
    public static final int EGL_SYNC_FLUSH_COMMANDS_BIT_KHR = 1;
    public static final long EGL_FOREVER_KHR = -1L;
    public static final long EGL_NO_SYNC_KHR = 0L;
    public final long CreateSyncKHR;
    public final long DestroySyncKHR;
    public final long ClientWaitSyncKHR;
    public final long SignalSyncKHR;
    public final long GetSyncAttribKHR;

    protected KHRReusableSync() {
        throw new UnsupportedOperationException();
    }

    public KHRReusableSync(FunctionProvider provider) {
        this.CreateSyncKHR = provider.getFunctionAddress("eglCreateSyncKHR");
        this.DestroySyncKHR = provider.getFunctionAddress("eglDestroySyncKHR");
        this.ClientWaitSyncKHR = provider.getFunctionAddress("eglClientWaitSyncKHR");
        this.SignalSyncKHR = provider.getFunctionAddress("eglSignalSyncKHR");
        this.GetSyncAttribKHR = provider.getFunctionAddress("eglGetSyncAttribKHR");
    }

    public static KHRReusableSync getInstance() {
        return KHRReusableSync.getInstance(EGL.getCapabilities());
    }

    public static KHRReusableSync getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRReusableSync);
    }

    public static long neglCreateSyncKHR(long dpy, int type, long attrib_list) {
        long __functionAddress = KHRReusableSync.getInstance().CreateSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPIPP(__functionAddress, dpy, type, attrib_list);
    }

    public static long eglCreateSyncKHR(long dpy, int type, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRReusableSync.neglCreateSyncKHR(dpy, type, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateSyncKHR(long dpy, int type, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRReusableSync.neglCreateSyncKHR(dpy, type, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroySyncKHR(long dpy, long sync) {
        long __functionAddress = KHRReusableSync.getInstance().DestroySyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPZ(__functionAddress, dpy, sync);
    }

    public static int eglClientWaitSyncKHR(long dpy, long sync, int flags, long timeout) {
        long __functionAddress = KHRReusableSync.getInstance().ClientWaitSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPIJI(__functionAddress, dpy, sync, flags, timeout);
    }

    public static boolean eglSignalSyncKHR(long dpy, long sync, int mode) {
        long __functionAddress = KHRReusableSync.getInstance().SignalSyncKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPIZ(__functionAddress, dpy, sync, mode);
    }

    public static boolean neglGetSyncAttribKHR(long dpy, long sync, int attribute, long value) {
        long __functionAddress = KHRReusableSync.getInstance().GetSyncAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(sync);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, sync, attribute, value);
    }

    public static boolean eglGetSyncAttribKHR(long dpy, long sync, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return KHRReusableSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglGetSyncAttribKHR(long dpy, long sync, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRReusableSync.neglGetSyncAttribKHR(dpy, sync, attribute, MemoryUtil.memAddress(value));
    }
}

