/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class NVNativeQuery {
    public final long QueryNativeDisplayNV;
    public final long QueryNativeWindowNV;
    public final long QueryNativePixmapNV;

    protected NVNativeQuery() {
        throw new UnsupportedOperationException();
    }

    public NVNativeQuery(FunctionProvider provider) {
        this.QueryNativeDisplayNV = provider.getFunctionAddress("eglQueryNativeDisplayNV");
        this.QueryNativeWindowNV = provider.getFunctionAddress("eglQueryNativeWindowNV");
        this.QueryNativePixmapNV = provider.getFunctionAddress("eglQueryNativePixmapNV");
    }

    public static NVNativeQuery getInstance() {
        return NVNativeQuery.getInstance(EGL.getCapabilities());
    }

    public static NVNativeQuery getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVNativeQuery);
    }

    public static boolean neglQueryNativeDisplayNV(long dpy, long display_id) {
        long __functionAddress = NVNativeQuery.getInstance().QueryNativeDisplayNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPZ(__functionAddress, dpy, display_id);
    }

    public static boolean eglQueryNativeDisplayNV(long dpy, ByteBuffer display_id) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)display_id, 1 << Pointer.POINTER_SHIFT);
        }
        return NVNativeQuery.neglQueryNativeDisplayNV(dpy, MemoryUtil.memAddress(display_id));
    }

    public static boolean eglQueryNativeDisplayNV(long dpy, PointerBuffer display_id) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(display_id, 1);
        }
        return NVNativeQuery.neglQueryNativeDisplayNV(dpy, MemoryUtil.memAddress(display_id));
    }

    public static boolean neglQueryNativeWindowNV(long dpy, long surf, long window) {
        long __functionAddress = NVNativeQuery.getInstance().QueryNativeWindowNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surf);
        }
        return JNI.callPPPZ(__functionAddress, dpy, surf, window);
    }

    public static boolean eglQueryNativeWindowNV(long dpy, long surf, ByteBuffer window) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)window, 1 << Pointer.POINTER_SHIFT);
        }
        return NVNativeQuery.neglQueryNativeWindowNV(dpy, surf, MemoryUtil.memAddress(window));
    }

    public static boolean eglQueryNativeWindowNV(long dpy, long surf, PointerBuffer window) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(window, 1);
        }
        return NVNativeQuery.neglQueryNativeWindowNV(dpy, surf, MemoryUtil.memAddress(window));
    }

    public static boolean neglQueryNativePixmapNV(long dpy, long surf, long pixmap) {
        long __functionAddress = NVNativeQuery.getInstance().QueryNativePixmapNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surf);
        }
        return JNI.callPPPZ(__functionAddress, dpy, surf, pixmap);
    }

    public static boolean eglQueryNativePixmapNV(long dpy, long surf, ByteBuffer pixmap) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixmap, 1 << Pointer.POINTER_SHIFT);
        }
        return NVNativeQuery.neglQueryNativePixmapNV(dpy, surf, MemoryUtil.memAddress(pixmap));
    }

    public static boolean eglQueryNativePixmapNV(long dpy, long surf, PointerBuffer pixmap) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(pixmap, 1);
        }
        return NVNativeQuery.neglQueryNativePixmapNV(dpy, surf, MemoryUtil.memAddress(pixmap));
    }
}

