/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVStreamSync {
    public static final int EGL_SYNC_TYPE_KHR = 12535;
    public static final int EGL_SYNC_NEW_FRAME_NV = 12831;
    public final long CreateStreamSyncNV;

    protected NVStreamSync() {
        throw new UnsupportedOperationException();
    }

    public NVStreamSync(FunctionProvider provider) {
        this.CreateStreamSyncNV = provider.getFunctionAddress("eglCreateStreamSyncNV");
    }

    public static NVStreamSync getInstance() {
        return NVStreamSync.getInstance(EGL.getCapabilities());
    }

    public static NVStreamSync getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVStreamSync);
    }

    public static long neglCreateStreamSyncNV(long dpy, long stream, int type, long attrib_list) {
        long __functionAddress = NVStreamSync.getInstance().CreateStreamSyncNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPIPP(__functionAddress, dpy, stream, type, attrib_list);
    }

    public static long eglCreateStreamSyncNV(long dpy, long stream, int type, ByteBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return NVStreamSync.neglCreateStreamSyncNV(dpy, stream, type, MemoryUtil.memAddress(attrib_list));
    }

    public static long eglCreateStreamSyncNV(long dpy, long stream, int type, IntBuffer attrib_list) {
        if (Checks.CHECKS) {
            Checks.checkNT(attrib_list, 12344);
        }
        return NVStreamSync.neglCreateStreamSyncNV(dpy, stream, type, MemoryUtil.memAddress(attrib_list));
    }
}

