/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class GLFWGammaRamp
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int SIZE;

    GLFWGammaRamp(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public GLFWGammaRamp(long struct) {
        this(struct, null);
    }

    public GLFWGammaRamp(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public ShortBuffer red(int capacity) {
        return GLFWGammaRamp.nred(this.address(), capacity);
    }

    public ShortBuffer green(int capacity) {
        return GLFWGammaRamp.ngreen(this.address(), capacity);
    }

    public ShortBuffer blue(int capacity) {
        return GLFWGammaRamp.nblue(this.address(), capacity);
    }

    public int size() {
        return GLFWGammaRamp.nsize(this.address());
    }

    public GLFWGammaRamp red(ShortBuffer value) {
        GLFWGammaRamp.nred(this.address(), value);
        return this;
    }

    public GLFWGammaRamp green(ShortBuffer value) {
        GLFWGammaRamp.ngreen(this.address(), value);
        return this;
    }

    public GLFWGammaRamp blue(ShortBuffer value) {
        GLFWGammaRamp.nblue(this.address(), value);
        return this;
    }

    public GLFWGammaRamp size(int value) {
        GLFWGammaRamp.nsize(this.address(), value);
        return this;
    }

    public GLFWGammaRamp set(ShortBuffer red, ShortBuffer green, ShortBuffer blue, int size) {
        this.red(red);
        this.green(green);
        this.blue(blue);
        this.size(size);
        return this;
    }

    public GLFWGammaRamp nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public GLFWGammaRamp set(GLFWGammaRamp src) {
        return this.nset(src.address());
    }

    public GLFWGammaRamp set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static GLFWGammaRamp malloc() {
        return new GLFWGammaRamp(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static GLFWGammaRamp calloc() {
        return new GLFWGammaRamp(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static GLFWGammaRamp create() {
        return new GLFWGammaRamp(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static ShortBuffer nred(long struct, int capacity) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)RED), capacity);
    }

    public static ShortBuffer ngreen(long struct, int capacity) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)GREEN), capacity);
    }

    public static ShortBuffer nblue(long struct, int capacity) {
        return MemoryUtil.memShortBuffer(MemoryUtil.memGetAddress(struct + (long)BLUE), capacity);
    }

    public static int nsize(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SIZE);
    }

    public static void nred(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)RED, MemoryUtil.memAddressSafe(value));
    }

    public static void ngreen(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)GREEN, MemoryUtil.memAddressSafe(value));
    }

    public static void nblue(long struct, ShortBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)BLUE, MemoryUtil.memAddressSafe(value));
    }

    public static void nsize(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = GLFWGammaRamp.__struct(GLFWGammaRamp.__member(Pointer.POINTER_SIZE), GLFWGammaRamp.__member(Pointer.POINTER_SIZE), GLFWGammaRamp.__member(Pointer.POINTER_SIZE), GLFWGammaRamp.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        RED = layout.offsetof(0);
        GREEN = layout.offsetof(1);
        BLUE = layout.offsetof(2);
        SIZE = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<GLFWGammaRamp, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected GLFWGammaRamp newInstance(long address) {
            return new GLFWGammaRamp(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public ShortBuffer red(int capacity) {
            return GLFWGammaRamp.nred(this.address(), capacity);
        }

        public ShortBuffer green(int capacity) {
            return GLFWGammaRamp.ngreen(this.address(), capacity);
        }

        public ShortBuffer blue(int capacity) {
            return GLFWGammaRamp.nblue(this.address(), capacity);
        }

        public int size() {
            return GLFWGammaRamp.nsize(this.address());
        }

        public Buffer red(ShortBuffer value) {
            GLFWGammaRamp.nred(this.address(), value);
            return this;
        }

        public Buffer green(ShortBuffer value) {
            GLFWGammaRamp.ngreen(this.address(), value);
            return this;
        }

        public Buffer blue(ShortBuffer value) {
            GLFWGammaRamp.nblue(this.address(), value);
            return this;
        }

        public Buffer size(int value) {
            GLFWGammaRamp.nsize(this.address(), value);
            return this;
        }
    }
}

