/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeCocoa {
    public final long GetCocoaMonitor;
    public final long GetCocoaWindow;
    private static final GLFWNativeCocoa instance = new GLFWNativeCocoa(GLFWNativeCocoa.getLibrary());

    protected GLFWNativeCocoa() {
        throw new UnsupportedOperationException();
    }

    public GLFWNativeCocoa(FunctionProvider provider) {
        this.GetCocoaMonitor = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetCocoaMonitor"));
        this.GetCocoaWindow = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetCocoaWindow"));
    }

    public static SharedLibrary getLibrary() {
        return GLFW.getLibrary();
    }

    public static GLFWNativeCocoa getInstance() {
        return instance;
    }

    public static long glfwGetCocoaMonitor(long monitor) {
        long __functionAddress = GLFWNativeCocoa.getInstance().GetCocoaMonitor;
        if (Checks.CHECKS) {
            Checks.checkPointer(monitor);
        }
        return JNI.invokePP(__functionAddress, monitor);
    }

    public static long glfwGetCocoaWindow(long window) {
        long __functionAddress = GLFWNativeCocoa.getInstance().GetCocoaWindow;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }
}

