/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.SharedLibrary;

public class GLFWNativeEGL {
    public final long GetEGLDisplay;
    public final long GetEGLContext;
    public final long GetEGLSurface;
    private static final GLFWNativeEGL instance = new GLFWNativeEGL(GLFWNativeEGL.getLibrary());

    protected GLFWNativeEGL() {
        throw new UnsupportedOperationException();
    }

    public GLFWNativeEGL(FunctionProvider provider) {
        this.GetEGLDisplay = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetEGLDisplay"));
        this.GetEGLContext = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetEGLContext"));
        this.GetEGLSurface = Checks.checkFunctionAddress(provider.getFunctionAddress("glfwGetEGLSurface"));
    }

    public static SharedLibrary getLibrary() {
        return GLFW.getLibrary();
    }

    public static GLFWNativeEGL getInstance() {
        return instance;
    }

    public static long glfwGetEGLDisplay() {
        long __functionAddress = GLFWNativeEGL.getInstance().GetEGLDisplay;
        return JNI.invokeP(__functionAddress);
    }

    public static long glfwGetEGLContext(long window) {
        long __functionAddress = GLFWNativeEGL.getInstance().GetEGLContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }

    public static long glfwGetEGLSurface(long window) {
        long __functionAddress = GLFWNativeEGL.getInstance().GetEGLSurface;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        return JNI.invokePP(__functionAddress, window);
    }
}

