/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.openal.AL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTEfx {
    public static final int ALC_EFX_MAJOR_VERSION = 131073;
    public static final int ALC_EFX_MINOR_VERSION = 131074;
    public static final int ALC_MAX_AUXILIARY_SENDS = 131075;
    public static final int AL_METERS_PER_UNIT = 131076;
    public static final int AL_DIRECT_FILTER = 131077;
    public static final int AL_AUXILIARY_SEND_FILTER = 131078;
    public static final int AL_AIR_ABSORPTION_FACTOR = 131079;
    public static final int AL_ROOM_ROLLOFF_FACTOR = 131080;
    public static final int AL_CONE_OUTER_GAINHF = 131081;
    public static final int AL_DIRECT_FILTER_GAINHF_AUTO = 131082;
    public static final int AL_AUXILIARY_SEND_FILTER_GAIN_AUTO = 131083;
    public static final int AL_AUXILIARY_SEND_FILTER_GAINHF_AUTO = 131084;
    public static final int AL_EFFECTSLOT_NULL = 0;
    public static final int AL_EFFECTSLOT_EFFECT = 1;
    public static final int AL_EFFECTSLOT_GAIN = 2;
    public static final int AL_EFFECTSLOT_AUXILIARY_SEND_AUTO = 3;
    public static final int AL_REVERB_DENSITY = 1;
    public static final int AL_REVERB_DIFFUSION = 2;
    public static final int AL_REVERB_GAIN = 3;
    public static final int AL_REVERB_GAINHF = 4;
    public static final int AL_REVERB_DECAY_TIME = 5;
    public static final int AL_REVERB_DECAY_HFRATIO = 6;
    public static final int AL_REVERB_REFLECTIONS_GAIN = 7;
    public static final int AL_REVERB_REFLECTIONS_DELAY = 8;
    public static final int AL_REVERB_LATE_REVERB_GAIN = 9;
    public static final int AL_REVERB_LATE_REVERB_DELAY = 10;
    public static final int AL_REVERB_AIR_ABSORPTION_GAINHF = 11;
    public static final int AL_REVERB_ROOM_ROLLOFF_FACTOR = 12;
    public static final int AL_REVERB_DECAY_HFLIMIT = 13;
    public static final int AL_EAXREVERB_DENSITY = 1;
    public static final int AL_EAXREVERB_DIFFUSION = 2;
    public static final int AL_EAXREVERB_GAIN = 3;
    public static final int AL_EAXREVERB_GAINHF = 4;
    public static final int AL_EAXREVERB_GAINLF = 5;
    public static final int AL_EAXREVERB_DECAY_TIME = 6;
    public static final int AL_EAXREVERB_DECAY_HFRATIO = 7;
    public static final int AL_EAXREVERB_DECAY_LFRATIO = 8;
    public static final int AL_EAXREVERB_REFLECTIONS_GAIN = 9;
    public static final int AL_EAXREVERB_REFLECTIONS_DELAY = 10;
    public static final int AL_EAXREVERB_REFLECTIONS_PAN = 11;
    public static final int AL_EAXREVERB_LATE_REVERB_GAIN = 12;
    public static final int AL_EAXREVERB_LATE_REVERB_DELAY = 13;
    public static final int AL_EAXREVERB_LATE_REVERB_PAN = 14;
    public static final int AL_EAXREVERB_ECHO_TIME = 15;
    public static final int AL_EAXREVERB_ECHO_DEPTH = 16;
    public static final int AL_EAXREVERB_MODULATION_TIME = 17;
    public static final int AL_EAXREVERB_MODULATION_DEPTH = 18;
    public static final int AL_EAXREVERB_AIR_ABSORPTION_GAINHF = 19;
    public static final int AL_EAXREVERB_HFREFERENCE = 20;
    public static final int AL_EAXREVERB_LFREFERENCE = 21;
    public static final int AL_EAXREVERB_ROOM_ROLLOFF_FACTOR = 22;
    public static final int AL_EAXREVERB_DECAY_HFLIMIT = 23;
    public static final int AL_CHORUS_WAVEFORM = 1;
    public static final int AL_CHORUS_PHASE = 2;
    public static final int AL_CHORUS_RATE = 3;
    public static final int AL_CHORUS_DEPTH = 4;
    public static final int AL_CHORUS_FEEDBACK = 5;
    public static final int AL_CHORUS_DELAY = 6;
    public static final int AL_DISTORTION_EDGE = 1;
    public static final int AL_DISTORTION_GAIN = 2;
    public static final int AL_DISTORTION_LOWPASS_CUTOFF = 3;
    public static final int AL_DISTORTION_EQCENTER = 4;
    public static final int AL_DISTORTION_EQBANDWIDTH = 5;
    public static final int AL_ECHO_DELAY = 1;
    public static final int AL_ECHO_LRDELAY = 2;
    public static final int AL_ECHO_DAMPING = 3;
    public static final int AL_ECHO_FEEDBACK = 4;
    public static final int AL_ECHO_SPREAD = 5;
    public static final int AL_FLANGER_WAVEFORM = 1;
    public static final int AL_FLANGER_PHASE = 2;
    public static final int AL_FLANGER_RATE = 3;
    public static final int AL_FLANGER_DEPTH = 4;
    public static final int AL_FLANGER_FEEDBACK = 5;
    public static final int AL_FLANGER_DELAY = 6;
    public static final int AL_FREQUENCY_SHIFTER_FREQUENCY = 1;
    public static final int AL_FREQUENCY_SHIFTER_LEFT_DIRECTION = 2;
    public static final int AL_FREQUENCY_SHIFTER_RIGHT_DIRECTION = 3;
    public static final int AL_VOCMORPHER_PHONEMEA = 1;
    public static final int AL_VOCMORPHER_PHONEMEA_COARSE_TUNING = 2;
    public static final int AL_VOCMORPHER_PHONEMEB = 3;
    public static final int AL_VOCMORPHER_PHONEMEB_COARSE_TUNING = 4;
    public static final int AL_VOCMORPHER_WAVEFORM = 5;
    public static final int AL_VOCMORPHER_RATE = 6;
    public static final int AL_PITCH_SHIFTER_COARSE_TUNE = 1;
    public static final int AL_PITCH_SHIFTER_FINE_TUNE = 2;
    public static final int AL_RING_MODULATOR_FREQUENCY = 1;
    public static final int AL_RING_MODULATOR_HIGHPASS_CUTOFF = 2;
    public static final int AL_RING_MODULATOR_WAVEFORM = 3;
    public static final int AL_AUTOWAH_ATTACK_TIME = 1;
    public static final int AL_AUTOWAH_RELEASE_TIME = 2;
    public static final int AL_AUTOWAH_RESONANCE = 3;
    public static final int AL_AUTOWAH_PEAK_GAIN = 4;
    public static final int AL_COMPRESSOR_ONOFF = 1;
    public static final int AL_EQUALIZER_LOW_GAIN = 1;
    public static final int AL_EQUALIZER_LOW_CUTOFF = 2;
    public static final int AL_EQUALIZER_MID1_GAIN = 3;
    public static final int AL_EQUALIZER_MID1_CENTER = 4;
    public static final int AL_EQUALIZER_MID1_WIDTH = 5;
    public static final int AL_EQUALIZER_MID2_GAIN = 6;
    public static final int AL_EQUALIZER_MID2_CENTER = 7;
    public static final int AL_EQUALIZER_MID2_WIDTH = 8;
    public static final int AL_EQUALIZER_HIGH_GAIN = 9;
    public static final int AL_EQUALIZER_HIGH_CUTOFF = 10;
    public static final int AL_EFFECT_FIRST_PARAMETER = 0;
    public static final int AL_EFFECT_LAST_PARAMETER = 32768;
    public static final int AL_EFFECT_TYPE = 32769;
    public static final int AL_EFFECT_NULL = 0;
    public static final int AL_EFFECT_REVERB = 1;
    public static final int AL_EFFECT_CHORUS = 2;
    public static final int AL_EFFECT_DISTORTION = 3;
    public static final int AL_EFFECT_ECHO = 4;
    public static final int AL_EFFECT_FLANGER = 5;
    public static final int AL_EFFECT_FREQUENCY_SHIFTER = 6;
    public static final int AL_EFFECT_VOCAL_MORPHER = 7;
    public static final int AL_EFFECT_PITCH_SHIFTER = 8;
    public static final int AL_EFFECT_RING_MODULATOR = 9;
    public static final int AL_EFFECT_AUTOWAH = 10;
    public static final int AL_EFFECT_COMPRESSOR = 11;
    public static final int AL_EFFECT_EQUALIZER = 12;
    public static final int AL_EFFECT_EAXREVERB = 32768;
    public static final int AL_LOWPASS_GAIN = 1;
    public static final int AL_LOWPASS_GAINHF = 2;
    public static final int AL_HIGHPASS_GAIN = 1;
    public static final int AL_HIGHPASS_GAINLF = 2;
    public static final int AL_BANDPASS_GAIN = 1;
    public static final int AL_BANDPASS_GAINLF = 2;
    public static final int AL_BANDPASS_GAINHF = 3;
    public static final int AL_FILTER_FIRST_PARAMETER = 0;
    public static final int AL_FILTER_LAST_PARAMETER = 32768;
    public static final int AL_FILTER_TYPE = 32769;
    public static final int AL_FILTER_NULL = 0;
    public static final int AL_FILTER_LOWPASS = 1;
    public static final int AL_FILTER_HIGHPASS = 2;
    public static final int AL_FILTER_BANDPASS = 3;
    public static final float AL_MIN_AIR_ABSORPTION_FACTOR = 0.0f;
    public static final float AL_MAX_AIR_ABSORPTION_FACTOR = 10.0f;
    public static final float AL_DEFAULT_AIR_ABSORPTION_FACTOR = 0.0f;
    public static final float AL_MIN_ROOM_ROLLOFF_FACTOR = 0.0f;
    public static final float AL_MAX_ROOM_ROLLOFF_FACTOR = 10.0f;
    public static final float AL_DEFAULT_ROOM_ROLLOFF_FACTOR = 0.0f;
    public static final float AL_MIN_CONE_OUTER_GAINHF = 0.0f;
    public static final float AL_MAX_CONE_OUTER_GAINHF = 1.0f;
    public static final float AL_DEFAULT_CONE_OUTER_GAINHF = 1.0f;
    public static final int AL_MIN_DIRECT_FILTER_GAINHF_AUTO = 0;
    public static final int AL_MAX_DIRECT_FILTER_GAINHF_AUTO = 1;
    public static final int AL_DEFAULT_DIRECT_FILTER_GAINHF_AUTO = 1;
    public static final int AL_MIN_AUXILIARY_SEND_FILTER_GAIN_AUTO = 0;
    public static final int AL_MAX_AUXILIARY_SEND_FILTER_GAIN_AUTO = 1;
    public static final int AL_DEFAULT_AUXILIARY_SEND_FILTER_GAIN_AUTO = 1;
    public static final int AL_MIN_AUXILIARY_SEND_FILTER_GAINHF_AUTO = 0;
    public static final int AL_MAX_AUXILIARY_SEND_FILTER_GAINHF_AUTO = 1;
    public static final int AL_DEFAULT_AUXILIARY_SEND_FILTER_GAINHF_AUTO = 1;
    public static final float AL_MIN_METERS_PER_UNIT = Float.MIN_VALUE;
    public static final float AL_MAX_METERS_PER_UNIT = Float.MAX_VALUE;
    public static final float AL_DEFAULT_METERS_PER_UNIT = 1.0f;
    public static final float AL_REVERB_MIN_DENSITY = 0.0f;
    public static final float AL_REVERB_MAX_DENSITY = 1.0f;
    public static final float AL_REVERB_DEFAULT_DENSITY = 1.0f;
    public static final float AL_REVERB_MIN_DIFFUSION = 0.0f;
    public static final float AL_REVERB_MAX_DIFFUSION = 1.0f;
    public static final float AL_REVERB_DEFAULT_DIFFUSION = 1.0f;
    public static final float AL_REVERB_MIN_GAIN = 0.0f;
    public static final float AL_REVERB_MAX_GAIN = 1.0f;
    public static final float AL_REVERB_DEFAULT_GAIN = 0.32f;
    public static final float AL_REVERB_MIN_GAINHF = 0.0f;
    public static final float AL_REVERB_MAX_GAINHF = 1.0f;
    public static final float AL_REVERB_DEFAULT_GAINHF = 0.89f;
    public static final float AL_REVERB_MIN_DECAY_TIME = 0.1f;
    public static final float AL_REVERB_MAX_DECAY_TIME = 20.0f;
    public static final float AL_REVERB_DEFAULT_DECAY_TIME = 1.49f;
    public static final float AL_REVERB_MIN_DECAY_HFRATIO = 0.1f;
    public static final float AL_REVERB_MAX_DECAY_HFRATIO = 2.0f;
    public static final float AL_REVERB_DEFAULT_DECAY_HFRATIO = 0.83f;
    public static final float AL_REVERB_MIN_REFLECTIONS_GAIN = 0.0f;
    public static final float AL_REVERB_MAX_REFLECTIONS_GAIN = 3.16f;
    public static final float AL_REVERB_DEFAULT_REFLECTIONS_GAIN = 0.05f;
    public static final float AL_REVERB_MIN_REFLECTIONS_DELAY = 0.0f;
    public static final float AL_REVERB_MAX_REFLECTIONS_DELAY = 0.3f;
    public static final float AL_REVERB_DEFAULT_REFLECTIONS_DELAY = 0.007f;
    public static final float AL_REVERB_MIN_LATE_REVERB_GAIN = 0.0f;
    public static final float AL_REVERB_MAX_LATE_REVERB_GAIN = 10.0f;
    public static final float AL_REVERB_DEFAULT_LATE_REVERB_GAIN = 1.26f;
    public static final float AL_REVERB_MIN_LATE_REVERB_DELAY = 0.0f;
    public static final float AL_REVERB_MAX_LATE_REVERB_DELAY = 0.1f;
    public static final float AL_REVERB_DEFAULT_LATE_REVERB_DELAY = 0.011f;
    public static final float AL_REVERB_MIN_AIR_ABSORPTION_GAINHF = 0.892f;
    public static final float AL_REVERB_MAX_AIR_ABSORPTION_GAINHF = 1.0f;
    public static final float AL_REVERB_DEFAULT_AIR_ABSORPTION_GAINHF = 0.994f;
    public static final float AL_REVERB_MIN_ROOM_ROLLOFF_FACTOR = 0.0f;
    public static final float AL_REVERB_MAX_ROOM_ROLLOFF_FACTOR = 10.0f;
    public static final float AL_REVERB_DEFAULT_ROOM_ROLLOFF_FACTOR = 0.0f;
    public static final int AL_REVERB_MIN_DECAY_HFLIMIT = 0;
    public static final int AL_REVERB_MAX_DECAY_HFLIMIT = 1;
    public static final int AL_REVERB_DEFAULT_DECAY_HFLIMIT = 1;
    public static final float AL_EAXREVERB_MIN_DENSITY = 0.0f;
    public static final float AL_EAXREVERB_MAX_DENSITY = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_DENSITY = 1.0f;
    public static final float AL_EAXREVERB_MIN_DIFFUSION = 0.0f;
    public static final float AL_EAXREVERB_MAX_DIFFUSION = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_DIFFUSION = 1.0f;
    public static final float AL_EAXREVERB_MIN_GAIN = 0.0f;
    public static final float AL_EAXREVERB_MAX_GAIN = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_GAIN = 0.32f;
    public static final float AL_EAXREVERB_MIN_GAINHF = 0.0f;
    public static final float AL_EAXREVERB_MAX_GAINHF = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_GAINHF = 0.89f;
    public static final float AL_EAXREVERB_MIN_GAINLF = 0.0f;
    public static final float AL_EAXREVERB_MAX_GAINLF = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_GAINLF = 1.0f;
    public static final float AL_EAXREVERB_MIN_DECAY_TIME = 0.1f;
    public static final float AL_EAXREVERB_MAX_DECAY_TIME = 20.0f;
    public static final float AL_EAXREVERB_DEFAULT_DECAY_TIME = 1.49f;
    public static final float AL_EAXREVERB_MIN_DECAY_HFRATIO = 0.1f;
    public static final float AL_EAXREVERB_MAX_DECAY_HFRATIO = 2.0f;
    public static final float AL_EAXREVERB_DEFAULT_DECAY_HFRATIO = 0.83f;
    public static final float AL_EAXREVERB_MIN_DECAY_LFRATIO = 0.1f;
    public static final float AL_EAXREVERB_MAX_DECAY_LFRATIO = 2.0f;
    public static final float AL_EAXREVERB_DEFAULT_DECAY_LFRATIO = 1.0f;
    public static final float AL_EAXREVERB_MIN_REFLECTIONS_GAIN = 0.0f;
    public static final float AL_EAXREVERB_MAX_REFLECTIONS_GAIN = 3.16f;
    public static final float AL_EAXREVERB_DEFAULT_REFLECTIONS_GAIN = 0.05f;
    public static final float AL_EAXREVERB_MIN_REFLECTIONS_DELAY = 0.0f;
    public static final float AL_EAXREVERB_MAX_REFLECTIONS_DELAY = 0.3f;
    public static final float AL_EAXREVERB_DEFAULT_REFLECTIONS_DELAY = 0.007f;
    public static final float AL_EAXREVERB_DEFAULT_REFLECTIONS_PAN_XYZ = 0.0f;
    public static final float AL_EAXREVERB_MIN_LATE_REVERB_GAIN = 0.0f;
    public static final float AL_EAXREVERB_MAX_LATE_REVERB_GAIN = 10.0f;
    public static final float AL_EAXREVERB_DEFAULT_LATE_REVERB_GAIN = 1.26f;
    public static final float AL_EAXREVERB_MIN_LATE_REVERB_DELAY = 0.0f;
    public static final float AL_EAXREVERB_MAX_LATE_REVERB_DELAY = 0.1f;
    public static final float AL_EAXREVERB_DEFAULT_LATE_REVERB_DELAY = 0.011f;
    public static final float AL_EAXREVERB_DEFAULT_LATE_REVERB_PAN_XYZ = 0.0f;
    public static final float AL_EAXREVERB_MIN_ECHO_TIME = 0.075f;
    public static final float AL_EAXREVERB_MAX_ECHO_TIME = 0.25f;
    public static final float AL_EAXREVERB_DEFAULT_ECHO_TIME = 0.25f;
    public static final float AL_EAXREVERB_MIN_ECHO_DEPTH = 0.0f;
    public static final float AL_EAXREVERB_MAX_ECHO_DEPTH = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_ECHO_DEPTH = 0.0f;
    public static final float AL_EAXREVERB_MIN_MODULATION_TIME = 0.04f;
    public static final float AL_EAXREVERB_MAX_MODULATION_TIME = 4.0f;
    public static final float AL_EAXREVERB_DEFAULT_MODULATION_TIME = 0.25f;
    public static final float AL_EAXREVERB_MIN_MODULATION_DEPTH = 0.0f;
    public static final float AL_EAXREVERB_MAX_MODULATION_DEPTH = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_MODULATION_DEPTH = 0.0f;
    public static final float AL_EAXREVERB_MIN_AIR_ABSORPTION_GAINHF = 0.892f;
    public static final float AL_EAXREVERB_MAX_AIR_ABSORPTION_GAINHF = 1.0f;
    public static final float AL_EAXREVERB_DEFAULT_AIR_ABSORPTION_GAINHF = 0.994f;
    public static final float AL_EAXREVERB_MIN_HFREFERENCE = 1000.0f;
    public static final float AL_EAXREVERB_MAX_HFREFERENCE = 20000.0f;
    public static final float AL_EAXREVERB_DEFAULT_HFREFERENCE = 5000.0f;
    public static final float AL_EAXREVERB_MIN_LFREFERENCE = 20.0f;
    public static final float AL_EAXREVERB_MAX_LFREFERENCE = 1000.0f;
    public static final float AL_EAXREVERB_DEFAULT_LFREFERENCE = 250.0f;
    public static final float AL_EAXREVERB_MIN_ROOM_ROLLOFF_FACTOR = 0.0f;
    public static final float AL_EAXREVERB_MAX_ROOM_ROLLOFF_FACTOR = 10.0f;
    public static final float AL_EAXREVERB_DEFAULT_ROOM_ROLLOFF_FACTOR = 0.0f;
    public static final int AL_EAXREVERB_MIN_DECAY_HFLIMIT = 0;
    public static final int AL_EAXREVERB_MAX_DECAY_HFLIMIT = 1;
    public static final int AL_EAXREVERB_DEFAULT_DECAY_HFLIMIT = 1;
    public static final int AL_CHORUS_WAVEFORM_SINUSOID = 0;
    public static final int AL_CHORUS_WAVEFORM_TRIANGLE = 1;
    public static final int AL_CHORUS_MIN_WAVEFORM = 0;
    public static final int AL_CHORUS_MAX_WAVEFORM = 1;
    public static final int AL_CHORUS_DEFAULT_WAVEFORM = 1;
    public static final int AL_CHORUS_MIN_PHASE = -180;
    public static final int AL_CHORUS_MAX_PHASE = 180;
    public static final int AL_CHORUS_DEFAULT_PHASE = 90;
    public static final float AL_CHORUS_MIN_RATE = 0.0f;
    public static final float AL_CHORUS_MAX_RATE = 10.0f;
    public static final float AL_CHORUS_DEFAULT_RATE = 1.1f;
    public static final float AL_CHORUS_MIN_DEPTH = 0.0f;
    public static final float AL_CHORUS_MAX_DEPTH = 1.0f;
    public static final float AL_CHORUS_DEFAULT_DEPTH = 0.1f;
    public static final float AL_CHORUS_MIN_FEEDBACK = -1.0f;
    public static final float AL_CHORUS_MAX_FEEDBACK = 1.0f;
    public static final float AL_CHORUS_DEFAULT_FEEDBACK = 0.25f;
    public static final float AL_CHORUS_MIN_DELAY = 0.0f;
    public static final float AL_CHORUS_MAX_DELAY = 0.016f;
    public static final float AL_CHORUS_DEFAULT_DELAY = 0.016f;
    public static final float AL_DISTORTION_MIN_EDGE = 0.0f;
    public static final float AL_DISTORTION_MAX_EDGE = 1.0f;
    public static final float AL_DISTORTION_DEFAULT_EDGE = 0.2f;
    public static final float AL_DISTORTION_MIN_GAIN = 0.01f;
    public static final float AL_DISTORTION_MAX_GAIN = 1.0f;
    public static final float AL_DISTORTION_DEFAULT_GAIN = 0.05f;
    public static final float AL_DISTORTION_MIN_LOWPASS_CUTOFF = 80.0f;
    public static final float AL_DISTORTION_MAX_LOWPASS_CUTOFF = 24000.0f;
    public static final float AL_DISTORTION_DEFAULT_LOWPASS_CUTOFF = 8000.0f;
    public static final float AL_DISTORTION_MIN_EQCENTER = 80.0f;
    public static final float AL_DISTORTION_MAX_EQCENTER = 24000.0f;
    public static final float AL_DISTORTION_DEFAULT_EQCENTER = 3600.0f;
    public static final float AL_DISTORTION_MIN_EQBANDWIDTH = 80.0f;
    public static final float AL_DISTORTION_MAX_EQBANDWIDTH = 24000.0f;
    public static final float AL_DISTORTION_DEFAULT_EQBANDWIDTH = 3600.0f;
    public static final float AL_ECHO_MIN_DELAY = 0.0f;
    public static final float AL_ECHO_MAX_DELAY = 0.207f;
    public static final float AL_ECHO_DEFAULT_DELAY = 0.1f;
    public static final float AL_ECHO_MIN_LRDELAY = 0.0f;
    public static final float AL_ECHO_MAX_LRDELAY = 0.404f;
    public static final float AL_ECHO_DEFAULT_LRDELAY = 0.1f;
    public static final float AL_ECHO_MIN_DAMPING = 0.0f;
    public static final float AL_ECHO_MAX_DAMPING = 0.99f;
    public static final float AL_ECHO_DEFAULT_DAMPING = 0.5f;
    public static final float AL_ECHO_MIN_FEEDBACK = 0.0f;
    public static final float AL_ECHO_MAX_FEEDBACK = 1.0f;
    public static final float AL_ECHO_DEFAULT_FEEDBACK = 0.5f;
    public static final float AL_ECHO_MIN_SPREAD = -1.0f;
    public static final float AL_ECHO_MAX_SPREAD = 1.0f;
    public static final float AL_ECHO_DEFAULT_SPREAD = -1.0f;
    public static final int AL_FLANGER_WAVEFORM_SINUSOID = 0;
    public static final int AL_FLANGER_WAVEFORM_TRIANGLE = 1;
    public static final int AL_FLANGER_MIN_WAVEFORM = 0;
    public static final int AL_FLANGER_MAX_WAVEFORM = 1;
    public static final int AL_FLANGER_DEFAULT_WAVEFORM = 1;
    public static final int AL_FLANGER_MIN_PHASE = -180;
    public static final int AL_FLANGER_MAX_PHASE = 180;
    public static final int AL_FLANGER_DEFAULT_PHASE = 0;
    public static final float AL_FLANGER_MIN_RATE = 0.0f;
    public static final float AL_FLANGER_MAX_RATE = 10.0f;
    public static final float AL_FLANGER_DEFAULT_RATE = 0.27f;
    public static final float AL_FLANGER_MIN_DEPTH = 0.0f;
    public static final float AL_FLANGER_MAX_DEPTH = 1.0f;
    public static final float AL_FLANGER_DEFAULT_DEPTH = 1.0f;
    public static final float AL_FLANGER_MIN_FEEDBACK = -1.0f;
    public static final float AL_FLANGER_MAX_FEEDBACK = 1.0f;
    public static final float AL_FLANGER_DEFAULT_FEEDBACK = -0.5f;
    public static final float AL_FLANGER_MIN_DELAY = 0.0f;
    public static final float AL_FLANGER_MAX_DELAY = 0.004f;
    public static final float AL_FLANGER_DEFAULT_DELAY = 0.002f;
    public static final float AL_FREQUENCY_SHIFTER_MIN_FREQUENCY = 0.0f;
    public static final float AL_FREQUENCY_SHIFTER_MAX_FREQUENCY = 24000.0f;
    public static final float AL_FREQUENCY_SHIFTER_DEFAULT_FREQUENCY = 0.0f;
    public static final int AL_FREQUENCY_SHIFTER_MIN_LEFT_DIRECTION = 0;
    public static final int AL_FREQUENCY_SHIFTER_MAX_LEFT_DIRECTION = 2;
    public static final int AL_FREQUENCY_SHIFTER_DEFAULT_LEFT_DIRECTION = 0;
    public static final int AL_FREQUENCY_SHIFTER_DIRECTION_DOWN = 0;
    public static final int AL_FREQUENCY_SHIFTER_DIRECTION_UP = 1;
    public static final int AL_FREQUENCY_SHIFTER_DIRECTION_OFF = 2;
    public static final int AL_FREQUENCY_SHIFTER_MIN_RIGHT_DIRECTION = 0;
    public static final int AL_FREQUENCY_SHIFTER_MAX_RIGHT_DIRECTION = 2;
    public static final int AL_FREQUENCY_SHIFTER_DEFAULT_RIGHT_DIRECTION = 0;
    public static final int AL_VOCAL_MORPHER_MIN_PHONEMEA = 0;
    public static final int AL_VOCAL_MORPHER_MAX_PHONEMEA = 29;
    public static final int AL_VOCAL_MORPHER_DEFAULT_PHONEMEA = 0;
    public static final int AL_VOCAL_MORPHER_MIN_PHONEMEA_COARSE_TUNING = -24;
    public static final int AL_VOCAL_MORPHER_MAX_PHONEMEA_COARSE_TUNING = 24;
    public static final int AL_VOCAL_MORPHER_DEFAULT_PHONEMEA_COARSE_TUNING = 0;
    public static final int AL_VOCAL_MORPHER_MIN_PHONEMEB = 0;
    public static final int AL_VOCAL_MORPHER_MAX_PHONEMEB = 29;
    public static final int AL_VOCAL_MORPHER_DEFAULT_PHONEMEB = 10;
    public static final int AL_VOCAL_MORPHER_MIN_PHONEMEB_COARSE_TUNING = -24;
    public static final int AL_VOCAL_MORPHER_MAX_PHONEMEB_COARSE_TUNING = 24;
    public static final int AL_VOCAL_MORPHER_DEFAULT_PHONEMEB_COARSE_TUNING = 0;
    public static final int AL_VOCAL_MORPHER_PHONEME_A = 0;
    public static final int AL_VOCAL_MORPHER_PHONEME_E = 1;
    public static final int AL_VOCAL_MORPHER_PHONEME_I = 2;
    public static final int AL_VOCAL_MORPHER_PHONEME_O = 3;
    public static final int AL_VOCAL_MORPHER_PHONEME_U = 4;
    public static final int AL_VOCAL_MORPHER_PHONEME_AA = 5;
    public static final int AL_VOCAL_MORPHER_PHONEME_AE = 6;
    public static final int AL_VOCAL_MORPHER_PHONEME_AH = 7;
    public static final int AL_VOCAL_MORPHER_PHONEME_AO = 8;
    public static final int AL_VOCAL_MORPHER_PHONEME_EH = 9;
    public static final int AL_VOCAL_MORPHER_PHONEME_ER = 10;
    public static final int AL_VOCAL_MORPHER_PHONEME_IH = 11;
    public static final int AL_VOCAL_MORPHER_PHONEME_IY = 12;
    public static final int AL_VOCAL_MORPHER_PHONEME_UH = 13;
    public static final int AL_VOCAL_MORPHER_PHONEME_UW = 14;
    public static final int AL_VOCAL_MORPHER_PHONEME_B = 15;
    public static final int AL_VOCAL_MORPHER_PHONEME_D = 16;
    public static final int AL_VOCAL_MORPHER_PHONEME_F = 17;
    public static final int AL_VOCAL_MORPHER_PHONEME_G = 18;
    public static final int AL_VOCAL_MORPHER_PHONEME_J = 19;
    public static final int AL_VOCAL_MORPHER_PHONEME_K = 20;
    public static final int AL_VOCAL_MORPHER_PHONEME_L = 21;
    public static final int AL_VOCAL_MORPHER_PHONEME_M = 22;
    public static final int AL_VOCAL_MORPHER_PHONEME_N = 23;
    public static final int AL_VOCAL_MORPHER_PHONEME_P = 24;
    public static final int AL_VOCAL_MORPHER_PHONEME_R = 25;
    public static final int AL_VOCAL_MORPHER_PHONEME_S = 26;
    public static final int AL_VOCAL_MORPHER_PHONEME_T = 27;
    public static final int AL_VOCAL_MORPHER_PHONEME_V = 28;
    public static final int AL_VOCAL_MORPHER_PHONEME_Z = 29;
    public static final int AL_VOCAL_MORPHER_WAVEFORM_SINUSOID = 0;
    public static final int AL_VOCAL_MORPHER_WAVEFORM_TRIANGLE = 1;
    public static final int AL_VOCAL_MORPHER_WAVEFORM_SAWTOOTH = 2;
    public static final int AL_VOCAL_MORPHER_MIN_WAVEFORM = 0;
    public static final int AL_VOCAL_MORPHER_MAX_WAVEFORM = 2;
    public static final int AL_VOCAL_MORPHER_DEFAULT_WAVEFORM = 0;
    public static final float AL_VOCAL_MORPHER_MIN_RATE = 0.0f;
    public static final float AL_VOCAL_MORPHER_MAX_RATE = 10.0f;
    public static final float AL_VOCAL_MORPHER_DEFAULT_RATE = 1.41f;
    public static final int AL_PITCH_SHIFTER_MIN_COARSE_TUNE = -12;
    public static final int AL_PITCH_SHIFTER_MAX_COARSE_TUNE = 12;
    public static final int AL_PITCH_SHIFTER_DEFAULT_COARSE_TUNE = 12;
    public static final int AL_PITCH_SHIFTER_MIN_FINE_TUNE = -50;
    public static final int AL_PITCH_SHIFTER_MAX_FINE_TUNE = 50;
    public static final int AL_PITCH_SHIFTER_DEFAULT_FINE_TUNE = 0;
    public static final float AL_RING_MODULATOR_MIN_FREQUENCY = 0.0f;
    public static final float AL_RING_MODULATOR_MAX_FREQUENCY = 8000.0f;
    public static final float AL_RING_MODULATOR_DEFAULT_FREQUENCY = 440.0f;
    public static final float AL_RING_MODULATOR_MIN_HIGHPASS_CUTOFF = 0.0f;
    public static final float AL_RING_MODULATOR_MAX_HIGHPASS_CUTOFF = 24000.0f;
    public static final float AL_RING_MODULATOR_DEFAULT_HIGHPASS_CUTOFF = 800.0f;
    public static final int AL_RING_MODULATOR_SINUSOID = 0;
    public static final int AL_RING_MODULATOR_SAWTOOTH = 1;
    public static final int AL_RING_MODULATOR_SQUARE = 2;
    public static final int AL_RING_MODULATOR_MIN_WAVEFORM = 0;
    public static final int AL_RING_MODULATOR_MAX_WAVEFORM = 2;
    public static final int AL_RING_MODULATOR_DEFAULT_WAVEFORM = 0;
    public static final float AL_AUTOWAH_MIN_ATTACK_TIME = 1.0E-4f;
    public static final float AL_AUTOWAH_MAX_ATTACK_TIME = 1.0f;
    public static final float AL_AUTOWAH_DEFAULT_ATTACK_TIME = 0.06f;
    public static final float AL_AUTOWAH_MIN_RELEASE_TIME = 1.0E-4f;
    public static final float AL_AUTOWAH_MAX_RELEASE_TIME = 1.0f;
    public static final float AL_AUTOWAH_DEFAULT_RELEASE_TIME = 0.06f;
    public static final float AL_AUTOWAH_MIN_RESONANCE = 2.0f;
    public static final float AL_AUTOWAH_MAX_RESONANCE = 1000.0f;
    public static final float AL_AUTOWAH_DEFAULT_RESONANCE = 1000.0f;
    public static final float AL_AUTOWAH_MIN_PEAK_GAIN = 3.0E-5f;
    public static final float AL_AUTOWAH_MAX_PEAK_GAIN = 31621.0f;
    public static final float AL_AUTOWAH_DEFAULT_PEAK_GAIN = 11.22f;
    public static final int AL_COMPRESSOR_MIN_ONOFF = 0;
    public static final int AL_COMPRESSOR_MAX_ONOFF = 1;
    public static final int AL_COMPRESSOR_DEFAULT_ONOFF = 1;
    public static final float AL_EQUALIZER_MIN_LOW_GAIN = 0.126f;
    public static final float AL_EQUALIZER_MAX_LOW_GAIN = 7.943f;
    public static final float AL_EQUALIZER_DEFAULT_LOW_GAIN = 1.0f;
    public static final float AL_EQUALIZER_MIN_LOW_CUTOFF = 50.0f;
    public static final float AL_EQUALIZER_MAX_LOW_CUTOFF = 800.0f;
    public static final float AL_EQUALIZER_DEFAULT_LOW_CUTOFF = 200.0f;
    public static final float AL_EQUALIZER_MIN_MID1_GAIN = 0.126f;
    public static final float AL_EQUALIZER_MAX_MID1_GAIN = 7.943f;
    public static final float AL_EQUALIZER_DEFAULT_MID1_GAIN = 1.0f;
    public static final float AL_EQUALIZER_MIN_MID1_CENTER = 200.0f;
    public static final float AL_EQUALIZER_MAX_MID1_CENTER = 3000.0f;
    public static final float AL_EQUALIZER_DEFAULT_MID1_CENTER = 500.0f;
    public static final float AL_EQUALIZER_MIN_MID1_WIDTH = 0.01f;
    public static final float AL_EQUALIZER_MAX_MID1_WIDTH = 1.0f;
    public static final float AL_EQUALIZER_DEFAULT_MID1_WIDTH = 1.0f;
    public static final float AL_EQUALIZER_MIN_MID2_GAIN = 0.126f;
    public static final float AL_EQUALIZER_MAX_MID2_GAIN = 7.943f;
    public static final float AL_EQUALIZER_DEFAULT_MID2_GAIN = 1.0f;
    public static final float AL_EQUALIZER_MIN_MID2_CENTER = 1000.0f;
    public static final float AL_EQUALIZER_MAX_MID2_CENTER = 8000.0f;
    public static final float AL_EQUALIZER_DEFAULT_MID2_CENTER = 3000.0f;
    public static final float AL_EQUALIZER_MIN_MID2_WIDTH = 0.01f;
    public static final float AL_EQUALIZER_MAX_MID2_WIDTH = 1.0f;
    public static final float AL_EQUALIZER_DEFAULT_MID2_WIDTH = 1.0f;
    public static final float AL_EQUALIZER_MIN_HIGH_GAIN = 0.126f;
    public static final float AL_EQUALIZER_MAX_HIGH_GAIN = 7.943f;
    public static final float AL_EQUALIZER_DEFAULT_HIGH_GAIN = 1.0f;
    public static final float AL_EQUALIZER_MIN_HIGH_CUTOFF = 4000.0f;
    public static final float AL_EQUALIZER_MAX_HIGH_CUTOFF = 16000.0f;
    public static final float AL_EQUALIZER_DEFAULT_HIGH_CUTOFF = 6000.0f;
    public static final float AL_LOWPASS_MIN_GAIN = 0.0f;
    public static final float AL_LOWPASS_MAX_GAIN = 1.0f;
    public static final float AL_LOWPASS_DEFAULT_GAIN = 1.0f;
    public static final float AL_LOWPASS_MIN_GAINHF = 0.0f;
    public static final float AL_LOWPASS_MAX_GAINHF = 1.0f;
    public static final float AL_LOWPASS_DEFAULT_GAINHF = 1.0f;
    public static final float AL_HIGHPASS_MIN_GAIN = 0.0f;
    public static final float AL_HIGHPASS_MAX_GAIN = 1.0f;
    public static final float AL_HIGHPASS_DEFAULT_GAIN = 1.0f;
    public static final float AL_HIGHPASS_MIN_GAINLF = 0.0f;
    public static final float AL_HIGHPASS_MAX_GAINLF = 1.0f;
    public static final float AL_HIGHPASS_DEFAULT_GAINLF = 1.0f;
    public static final float AL_BANDPASS_MIN_GAIN = 0.0f;
    public static final float AL_BANDPASS_MAX_GAIN = 1.0f;
    public static final float AL_BANDPASS_DEFAULT_GAIN = 1.0f;
    public static final float AL_BANDPASS_MIN_GAINHF = 0.0f;
    public static final float AL_BANDPASS_MAX_GAINHF = 1.0f;
    public static final float AL_BANDPASS_DEFAULT_GAINHF = 1.0f;
    public static final float AL_BANDPASS_MIN_GAINLF = 0.0f;
    public static final float AL_BANDPASS_MAX_GAINLF = 1.0f;
    public static final float AL_BANDPASS_DEFAULT_GAINLF = 1.0f;
    public final long GenEffects;
    public final long DeleteEffects;
    public final long IsEffect;
    public final long Effecti;
    public final long Effectiv;
    public final long Effectf;
    public final long Effectfv;
    public final long GetEffecti;
    public final long GetEffectiv;
    public final long GetEffectf;
    public final long GetEffectfv;
    public final long GenFilters;
    public final long DeleteFilters;
    public final long IsFilter;
    public final long Filteri;
    public final long Filteriv;
    public final long Filterf;
    public final long Filterfv;
    public final long GetFilteri;
    public final long GetFilteriv;
    public final long GetFilterf;
    public final long GetFilterfv;
    public final long GenAuxiliaryEffectSlots;
    public final long DeleteAuxiliaryEffectSlots;
    public final long IsAuxiliaryEffectSlot;
    public final long AuxiliaryEffectSloti;
    public final long AuxiliaryEffectSlotiv;
    public final long AuxiliaryEffectSlotf;
    public final long AuxiliaryEffectSlotfv;
    public final long GetAuxiliaryEffectSloti;
    public final long GetAuxiliaryEffectSlotiv;
    public final long GetAuxiliaryEffectSlotf;
    public final long GetAuxiliaryEffectSlotfv;

    protected EXTEfx() {
        throw new UnsupportedOperationException();
    }

    public EXTEfx(FunctionProvider provider) {
        this.GenEffects = provider.getFunctionAddress("alGenEffects");
        this.DeleteEffects = provider.getFunctionAddress("alDeleteEffects");
        this.IsEffect = provider.getFunctionAddress("alIsEffect");
        this.Effecti = provider.getFunctionAddress("alEffecti");
        this.Effectiv = provider.getFunctionAddress("alEffectiv");
        this.Effectf = provider.getFunctionAddress("alEffectf");
        this.Effectfv = provider.getFunctionAddress("alEffectfv");
        this.GetEffecti = provider.getFunctionAddress("alGetEffecti");
        this.GetEffectiv = provider.getFunctionAddress("alGetEffectiv");
        this.GetEffectf = provider.getFunctionAddress("alGetEffectf");
        this.GetEffectfv = provider.getFunctionAddress("alGetEffectfv");
        this.GenFilters = provider.getFunctionAddress("alGenFilters");
        this.DeleteFilters = provider.getFunctionAddress("alDeleteFilters");
        this.IsFilter = provider.getFunctionAddress("alIsFilter");
        this.Filteri = provider.getFunctionAddress("alFilteri");
        this.Filteriv = provider.getFunctionAddress("alFilteriv");
        this.Filterf = provider.getFunctionAddress("alFilterf");
        this.Filterfv = provider.getFunctionAddress("alFilterfv");
        this.GetFilteri = provider.getFunctionAddress("alGetFilteri");
        this.GetFilteriv = provider.getFunctionAddress("alGetFilteriv");
        this.GetFilterf = provider.getFunctionAddress("alGetFilterf");
        this.GetFilterfv = provider.getFunctionAddress("alGetFilterfv");
        this.GenAuxiliaryEffectSlots = provider.getFunctionAddress("alGenAuxiliaryEffectSlots");
        this.DeleteAuxiliaryEffectSlots = provider.getFunctionAddress("alDeleteAuxiliaryEffectSlots");
        this.IsAuxiliaryEffectSlot = provider.getFunctionAddress("alIsAuxiliaryEffectSlot");
        this.AuxiliaryEffectSloti = provider.getFunctionAddress("alAuxiliaryEffectSloti");
        this.AuxiliaryEffectSlotiv = provider.getFunctionAddress("alAuxiliaryEffectSlotiv");
        this.AuxiliaryEffectSlotf = provider.getFunctionAddress("alAuxiliaryEffectSlotf");
        this.AuxiliaryEffectSlotfv = provider.getFunctionAddress("alAuxiliaryEffectSlotfv");
        this.GetAuxiliaryEffectSloti = provider.getFunctionAddress("alGetAuxiliaryEffectSloti");
        this.GetAuxiliaryEffectSlotiv = provider.getFunctionAddress("alGetAuxiliaryEffectSlotiv");
        this.GetAuxiliaryEffectSlotf = provider.getFunctionAddress("alGetAuxiliaryEffectSlotf");
        this.GetAuxiliaryEffectSlotfv = provider.getFunctionAddress("alGetAuxiliaryEffectSlotfv");
    }

    public static EXTEfx getInstance() {
        return Checks.checkFunctionality(AL.getCapabilities().__EXTEfx);
    }

    static EXTEfx create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("ALC_EXT_EFX")) {
            return null;
        }
        EXTEfx funcs = new EXTEfx(provider);
        boolean supported = Checks.checkFunctions(funcs.GenEffects, funcs.DeleteEffects, funcs.IsEffect, funcs.Effecti, funcs.Effectiv, funcs.Effectf, funcs.Effectfv, funcs.GetEffecti, funcs.GetEffectiv, funcs.GetEffectf, funcs.GetEffectfv, funcs.GenFilters, funcs.DeleteFilters, funcs.IsFilter, funcs.Filteri, funcs.Filteriv, funcs.Filterf, funcs.Filterfv, funcs.GetFilteri, funcs.GetFilteriv, funcs.GetFilterf, funcs.GetFilterfv, funcs.GenAuxiliaryEffectSlots, funcs.DeleteAuxiliaryEffectSlots, funcs.IsAuxiliaryEffectSlot, funcs.AuxiliaryEffectSloti, funcs.AuxiliaryEffectSlotiv, funcs.AuxiliaryEffectSlotf, funcs.AuxiliaryEffectSlotfv, funcs.GetAuxiliaryEffectSloti, funcs.GetAuxiliaryEffectSlotiv, funcs.GetAuxiliaryEffectSlotf, funcs.GetAuxiliaryEffectSlotfv);
        return AL.checkExtension("ALC_EXT_EFX", funcs, supported);
    }

    public static void nalGenEffects(int n, long effects) {
        long __functionAddress = EXTEfx.getInstance().GenEffects;
        JNI.invokeIPV(__functionAddress, n, effects);
    }

    public static void alGenEffects(int n, ByteBuffer effects) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)effects, n << 2);
        }
        EXTEfx.nalGenEffects(n, MemoryUtil.memAddress(effects));
    }

    public static void alGenEffects(IntBuffer effects) {
        EXTEfx.nalGenEffects(effects.remaining(), MemoryUtil.memAddress(effects));
    }

    public static int alGenEffects() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int effects = __buffer.intParam();
        EXTEfx.nalGenEffects(1, __buffer.address(effects));
        return __buffer.intValue(effects);
    }

    public static void nalDeleteEffects(int n, long effects) {
        long __functionAddress = EXTEfx.getInstance().DeleteEffects;
        JNI.invokeIPV(__functionAddress, n, effects);
    }

    public static void alDeleteEffects(int n, ByteBuffer effects) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)effects, n << 2);
        }
        EXTEfx.nalDeleteEffects(n, MemoryUtil.memAddress(effects));
    }

    public static void alDeleteEffects(IntBuffer effects) {
        EXTEfx.nalDeleteEffects(effects.remaining(), MemoryUtil.memAddress(effects));
    }

    public static void alDeleteEffects(int effect) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int effects = __buffer.intParam(effect);
        EXTEfx.nalDeleteEffects(1, __buffer.address(effects));
    }

    public static boolean alIsEffect(int effect) {
        long __functionAddress = EXTEfx.getInstance().IsEffect;
        return JNI.invokeIZ(__functionAddress, effect);
    }

    public static void alEffecti(int effect, int param, int value) {
        long __functionAddress = EXTEfx.getInstance().Effecti;
        JNI.invokeIIIV(__functionAddress, effect, param, value);
    }

    public static void nalEffectiv(int effect, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().Effectiv;
        JNI.invokeIIPV(__functionAddress, effect, param, values);
    }

    public static void alEffectiv(int effect, int param, ByteBuffer values) {
        EXTEfx.nalEffectiv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void alEffectiv(int effect, int param, IntBuffer values) {
        EXTEfx.nalEffectiv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void alEffectf(int effect, int param, float value) {
        long __functionAddress = EXTEfx.getInstance().Effectf;
        JNI.invokeIIFV(__functionAddress, effect, param, value);
    }

    public static void nalEffectfv(int effect, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().Effectfv;
        JNI.invokeIIPV(__functionAddress, effect, param, values);
    }

    public static void alEffectfv(int effect, int param, ByteBuffer values) {
        EXTEfx.nalEffectfv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void alEffectfv(int effect, int param, FloatBuffer values) {
        EXTEfx.nalEffectfv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetEffecti(int effect, int param, long value) {
        long __functionAddress = EXTEfx.getInstance().GetEffecti;
        JNI.invokeIIPV(__functionAddress, effect, param, value);
    }

    public static void alGetEffecti(int effect, int param, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        EXTEfx.nalGetEffecti(effect, param, MemoryUtil.memAddress(value));
    }

    public static void alGetEffecti(int effect, int param, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        EXTEfx.nalGetEffecti(effect, param, MemoryUtil.memAddress(value));
    }

    public static int alGetEffecti(int effect, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        EXTEfx.nalGetEffecti(effect, param, __buffer.address(value));
        return __buffer.intValue(value);
    }

    public static void nalGetEffectiv(int effect, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().GetEffectiv;
        JNI.invokeIIPV(__functionAddress, effect, param, values);
    }

    public static void alGetEffectiv(int effect, int param, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTEfx.nalGetEffectiv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void alGetEffectiv(int effect, int param, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTEfx.nalGetEffectiv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetEffectf(int effect, int param, long value) {
        long __functionAddress = EXTEfx.getInstance().GetEffectf;
        JNI.invokeIIPV(__functionAddress, effect, param, value);
    }

    public static void alGetEffectf(int effect, int param, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        EXTEfx.nalGetEffectf(effect, param, MemoryUtil.memAddress(value));
    }

    public static void alGetEffectf(int effect, int param, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        EXTEfx.nalGetEffectf(effect, param, MemoryUtil.memAddress(value));
    }

    public static float alGetEffectf(int effect, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        EXTEfx.nalGetEffectf(effect, param, __buffer.address(value));
        return __buffer.floatValue(value);
    }

    public static void nalGetEffectfv(int effect, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().GetEffectfv;
        JNI.invokeIIPV(__functionAddress, effect, param, values);
    }

    public static void alGetEffectfv(int effect, int param, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTEfx.nalGetEffectfv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void alGetEffectfv(int effect, int param, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTEfx.nalGetEffectfv(effect, param, MemoryUtil.memAddress(values));
    }

    public static void nalGenFilters(int n, long filters) {
        long __functionAddress = EXTEfx.getInstance().GenFilters;
        JNI.invokeIPV(__functionAddress, n, filters);
    }

    public static void alGenFilters(int n, ByteBuffer filters) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)filters, n << 2);
        }
        EXTEfx.nalGenFilters(n, MemoryUtil.memAddress(filters));
    }

    public static void alGenFilters(IntBuffer filters) {
        EXTEfx.nalGenFilters(filters.remaining(), MemoryUtil.memAddress(filters));
    }

    public static int alGenFilters() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filters = __buffer.intParam();
        EXTEfx.nalGenFilters(1, __buffer.address(filters));
        return __buffer.intValue(filters);
    }

    public static void nalDeleteFilters(int n, long filters) {
        long __functionAddress = EXTEfx.getInstance().DeleteFilters;
        JNI.invokeIPV(__functionAddress, n, filters);
    }

    public static void alDeleteFilters(int n, ByteBuffer filters) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)filters, n << 2);
        }
        EXTEfx.nalDeleteFilters(n, MemoryUtil.memAddress(filters));
    }

    public static void alDeleteFilters(IntBuffer filters) {
        EXTEfx.nalDeleteFilters(filters.remaining(), MemoryUtil.memAddress(filters));
    }

    public static void alDeleteFilters(int filter) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filters = __buffer.intParam(filter);
        EXTEfx.nalDeleteFilters(1, __buffer.address(filters));
    }

    public static boolean alIsFilter(int filter) {
        long __functionAddress = EXTEfx.getInstance().IsFilter;
        return JNI.invokeIZ(__functionAddress, filter);
    }

    public static void alFilteri(int filter, int param, int value) {
        long __functionAddress = EXTEfx.getInstance().Filteri;
        JNI.invokeIIIV(__functionAddress, filter, param, value);
    }

    public static void nalFilteriv(int filter, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().Filteriv;
        JNI.invokeIIPV(__functionAddress, filter, param, values);
    }

    public static void alFilteriv(int filter, int param, ByteBuffer values) {
        EXTEfx.nalFilteriv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void alFilteriv(int filter, int param, IntBuffer values) {
        EXTEfx.nalFilteriv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void alFilterf(int filter, int param, float value) {
        long __functionAddress = EXTEfx.getInstance().Filterf;
        JNI.invokeIIFV(__functionAddress, filter, param, value);
    }

    public static void nalFilterfv(int filter, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().Filterfv;
        JNI.invokeIIPV(__functionAddress, filter, param, values);
    }

    public static void alFilterfv(int filter, int param, ByteBuffer values) {
        EXTEfx.nalFilterfv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void alFilterfv(int filter, int param, FloatBuffer values) {
        EXTEfx.nalFilterfv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetFilteri(int filter, int param, long value) {
        long __functionAddress = EXTEfx.getInstance().GetFilteri;
        JNI.invokeIIPV(__functionAddress, filter, param, value);
    }

    public static void alGetFilteri(int filter, int param, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        EXTEfx.nalGetFilteri(filter, param, MemoryUtil.memAddress(value));
    }

    public static void alGetFilteri(int filter, int param, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        EXTEfx.nalGetFilteri(filter, param, MemoryUtil.memAddress(value));
    }

    public static int alGetFilteri(int filter, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        EXTEfx.nalGetFilteri(filter, param, __buffer.address(value));
        return __buffer.intValue(value);
    }

    public static void nalGetFilteriv(int filter, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().GetFilteriv;
        JNI.invokeIIPV(__functionAddress, filter, param, values);
    }

    public static void alGetFilteriv(int filter, int param, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTEfx.nalGetFilteriv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void alGetFilteriv(int filter, int param, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTEfx.nalGetFilteriv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetFilterf(int filter, int param, long value) {
        long __functionAddress = EXTEfx.getInstance().GetFilterf;
        JNI.invokeIIPV(__functionAddress, filter, param, value);
    }

    public static void alGetFilterf(int filter, int param, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        EXTEfx.nalGetFilterf(filter, param, MemoryUtil.memAddress(value));
    }

    public static void alGetFilterf(int filter, int param, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        EXTEfx.nalGetFilterf(filter, param, MemoryUtil.memAddress(value));
    }

    public static float alGetFilterf(int filter, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        EXTEfx.nalGetFilterf(filter, param, __buffer.address(value));
        return __buffer.floatValue(value);
    }

    public static void nalGetFilterfv(int filter, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().GetFilterfv;
        JNI.invokeIIPV(__functionAddress, filter, param, values);
    }

    public static void alGetFilterfv(int filter, int param, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTEfx.nalGetFilterfv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void alGetFilterfv(int filter, int param, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTEfx.nalGetFilterfv(filter, param, MemoryUtil.memAddress(values));
    }

    public static void nalGenAuxiliaryEffectSlots(int n, long effectSlots) {
        long __functionAddress = EXTEfx.getInstance().GenAuxiliaryEffectSlots;
        JNI.invokeIPV(__functionAddress, n, effectSlots);
    }

    public static void alGenAuxiliaryEffectSlots(int n, ByteBuffer effectSlots) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)effectSlots, n << 2);
        }
        EXTEfx.nalGenAuxiliaryEffectSlots(n, MemoryUtil.memAddress(effectSlots));
    }

    public static void alGenAuxiliaryEffectSlots(IntBuffer effectSlots) {
        EXTEfx.nalGenAuxiliaryEffectSlots(effectSlots.remaining(), MemoryUtil.memAddress(effectSlots));
    }

    public static int alGenAuxiliaryEffectSlots() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int effectSlots = __buffer.intParam();
        EXTEfx.nalGenAuxiliaryEffectSlots(1, __buffer.address(effectSlots));
        return __buffer.intValue(effectSlots);
    }

    public static void nalDeleteAuxiliaryEffectSlots(int n, long effectSlots) {
        long __functionAddress = EXTEfx.getInstance().DeleteAuxiliaryEffectSlots;
        JNI.invokeIPV(__functionAddress, n, effectSlots);
    }

    public static void alDeleteAuxiliaryEffectSlots(int n, ByteBuffer effectSlots) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)effectSlots, n << 2);
        }
        EXTEfx.nalDeleteAuxiliaryEffectSlots(n, MemoryUtil.memAddress(effectSlots));
    }

    public static void alDeleteAuxiliaryEffectSlots(IntBuffer effectSlots) {
        EXTEfx.nalDeleteAuxiliaryEffectSlots(effectSlots.remaining(), MemoryUtil.memAddress(effectSlots));
    }

    public static void alDeleteAuxiliaryEffectSlots(int effectSlot) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int effectSlots = __buffer.intParam(effectSlot);
        EXTEfx.nalDeleteAuxiliaryEffectSlots(1, __buffer.address(effectSlots));
    }

    public static boolean alIsAuxiliaryEffectSlot(int effectSlot) {
        long __functionAddress = EXTEfx.getInstance().IsAuxiliaryEffectSlot;
        return JNI.invokeIZ(__functionAddress, effectSlot);
    }

    public static void alAuxiliaryEffectSloti(int effectSlot, int param, int value) {
        long __functionAddress = EXTEfx.getInstance().AuxiliaryEffectSloti;
        JNI.invokeIIIV(__functionAddress, effectSlot, param, value);
    }

    public static void nalAuxiliaryEffectSlotiv(int effectSlot, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().AuxiliaryEffectSlotiv;
        JNI.invokeIIPV(__functionAddress, effectSlot, param, values);
    }

    public static void alAuxiliaryEffectSlotiv(int effectSlot, int param, ByteBuffer values) {
        EXTEfx.nalAuxiliaryEffectSlotiv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void alAuxiliaryEffectSlotiv(int effectSlot, int param, IntBuffer values) {
        EXTEfx.nalAuxiliaryEffectSlotiv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void alAuxiliaryEffectSlotf(int effectSlot, int param, float value) {
        long __functionAddress = EXTEfx.getInstance().AuxiliaryEffectSlotf;
        JNI.invokeIIFV(__functionAddress, effectSlot, param, value);
    }

    public static void nalAuxiliaryEffectSlotfv(int effectSlot, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().AuxiliaryEffectSlotfv;
        JNI.invokeIIPV(__functionAddress, effectSlot, param, values);
    }

    public static void alAuxiliaryEffectSlotfv(int effectSlot, int param, ByteBuffer values) {
        EXTEfx.nalAuxiliaryEffectSlotfv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void alAuxiliaryEffectSlotfv(int effectSlot, int param, FloatBuffer values) {
        EXTEfx.nalAuxiliaryEffectSlotfv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetAuxiliaryEffectSloti(int effectSlot, int param, long value) {
        long __functionAddress = EXTEfx.getInstance().GetAuxiliaryEffectSloti;
        JNI.invokeIIPV(__functionAddress, effectSlot, param, value);
    }

    public static void alGetAuxiliaryEffectSloti(int effectSlot, int param, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        EXTEfx.nalGetAuxiliaryEffectSloti(effectSlot, param, MemoryUtil.memAddress(value));
    }

    public static void alGetAuxiliaryEffectSloti(int effectSlot, int param, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        EXTEfx.nalGetAuxiliaryEffectSloti(effectSlot, param, MemoryUtil.memAddress(value));
    }

    public static int alGetAuxiliaryEffectSloti(int effectSlot, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.intParam();
        EXTEfx.nalGetAuxiliaryEffectSloti(effectSlot, param, __buffer.address(value));
        return __buffer.intValue(value);
    }

    public static void nalGetAuxiliaryEffectSlotiv(int effectSlot, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().GetAuxiliaryEffectSlotiv;
        JNI.invokeIIPV(__functionAddress, effectSlot, param, values);
    }

    public static void alGetAuxiliaryEffectSlotiv(int effectSlot, int param, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTEfx.nalGetAuxiliaryEffectSlotiv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void alGetAuxiliaryEffectSlotiv(int effectSlot, int param, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTEfx.nalGetAuxiliaryEffectSlotiv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetAuxiliaryEffectSlotf(int effectSlot, int param, long value) {
        long __functionAddress = EXTEfx.getInstance().GetAuxiliaryEffectSlotf;
        JNI.invokeIIPV(__functionAddress, effectSlot, param, value);
    }

    public static void alGetAuxiliaryEffectSlotf(int effectSlot, int param, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        EXTEfx.nalGetAuxiliaryEffectSlotf(effectSlot, param, MemoryUtil.memAddress(value));
    }

    public static void alGetAuxiliaryEffectSlotf(int effectSlot, int param, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        EXTEfx.nalGetAuxiliaryEffectSlotf(effectSlot, param, MemoryUtil.memAddress(value));
    }

    public static float alGetAuxiliaryEffectSlotf(int effectSlot, int param) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int value = __buffer.floatParam();
        EXTEfx.nalGetAuxiliaryEffectSlotf(effectSlot, param, __buffer.address(value));
        return __buffer.floatValue(value);
    }

    public static void nalGetAuxiliaryEffectSlotfv(int effectSlot, int param, long values) {
        long __functionAddress = EXTEfx.getInstance().GetAuxiliaryEffectSlotfv;
        JNI.invokeIIPV(__functionAddress, effectSlot, param, values);
    }

    public static void alGetAuxiliaryEffectSlotfv(int effectSlot, int param, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTEfx.nalGetAuxiliaryEffectSlotfv(effectSlot, param, MemoryUtil.memAddress(values));
    }

    public static void alGetAuxiliaryEffectSlotfv(int effectSlot, int param, FloatBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTEfx.nalGetAuxiliaryEffectSlotfv(effectSlot, param, MemoryUtil.memAddress(values));
    }
}

