/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import org.lwjgl.openal.AL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class SOFTDeferredUpdates {
    public static final int AL_DEFERRED_UPDATES_SOFT = 49154;
    public final long DeferUpdatesSOFT;
    public final long ProcessUpdatesSOFT;

    protected SOFTDeferredUpdates() {
        throw new UnsupportedOperationException();
    }

    public SOFTDeferredUpdates(FunctionProvider provider) {
        this.DeferUpdatesSOFT = provider.getFunctionAddress("alDeferUpdatesSOFT");
        this.ProcessUpdatesSOFT = provider.getFunctionAddress("alProcessUpdatesSOFT");
    }

    public static SOFTDeferredUpdates getInstance() {
        return Checks.checkFunctionality(AL.getCapabilities().__SOFTDeferredUpdates);
    }

    static SOFTDeferredUpdates create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("AL_SOFT_deferred_updates")) {
            return null;
        }
        SOFTDeferredUpdates funcs = new SOFTDeferredUpdates(provider);
        boolean supported = Checks.checkFunctions(funcs.DeferUpdatesSOFT, funcs.ProcessUpdatesSOFT);
        return AL.checkExtension("AL_SOFT_deferred_updates", funcs, supported);
    }

    public static void alDeferUpdatesSOFT() {
        long __functionAddress = SOFTDeferredUpdates.getInstance().DeferUpdatesSOFT;
        JNI.invokeV(__functionAddress);
    }

    public static void alProcessUpdatesSOFT() {
        long __functionAddress = SOFTDeferredUpdates.getInstance().ProcessUpdatesSOFT;
        JNI.invokeV(__functionAddress);
    }
}

