/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class SOFTLoopback {
    public static final int ALC_BYTE_SOFT = 5120;
    public static final int ALC_UNSIGNED_BYTE_SOFT = 5121;
    public static final int ALC_SHORT_SOFT = 5122;
    public static final int ALC_UNSIGNED_SHORT_SOFT = 5123;
    public static final int ALC_INT_SOFT = 5124;
    public static final int ALC_UNSIGNED_INT_SOFT = 5125;
    public static final int ALC_FLOAT_SOFT = 5126;
    public static final int ALC_MONO_SOFT = 5376;
    public static final int ALC_STEREO_SOFT = 5377;
    public static final int ALC_QUAD_SOFT = 5379;
    public static final int ALC_5POINT1_SOFT = 5380;
    public static final int ALC_6POINT1_SOFT = 5381;
    public static final int ALC_7POINT1_SOFT = 5382;
    public static final int ALC_FORMAT_CHANNELS_SOFT = 6544;
    public static final int ALC_FORMAT_TYPE_SOFT = 6545;
    public final long LoopbackOpenDeviceSOFT;
    public final long IsRenderFormatSupportedSOFT;
    public final long RenderSamplesSOFT;

    protected SOFTLoopback() {
        throw new UnsupportedOperationException();
    }

    public SOFTLoopback(FunctionProviderLocal provider, long device) {
        this.LoopbackOpenDeviceSOFT = provider.getFunctionAddress(device, "alcLoopbackOpenDeviceSOFT");
        this.IsRenderFormatSupportedSOFT = provider.getFunctionAddress(device, "alcIsRenderFormatSupportedSOFT");
        this.RenderSamplesSOFT = provider.getFunctionAddress(device, "alcRenderSamplesSOFT");
    }

    public static SOFTLoopback getInstance() {
        return SOFTLoopback.getInstance(ALC.getCapabilities());
    }

    public static SOFTLoopback getInstance(ALCCapabilities caps) {
        return Checks.checkFunctionality(caps.__SOFTLoopback);
    }

    static SOFTLoopback create(Set<String> ext, FunctionProviderLocal provider, long device) {
        if (!ext.contains("ALC_SOFT_loopback")) {
            return null;
        }
        SOFTLoopback funcs = new SOFTLoopback(provider, device);
        boolean supported = Checks.checkFunctions(funcs.LoopbackOpenDeviceSOFT, funcs.IsRenderFormatSupportedSOFT, funcs.RenderSamplesSOFT);
        return ALC.checkExtension("ALC_SOFT_loopback", funcs, supported);
    }

    public static long nalcLoopbackOpenDeviceSOFT(long deviceName) {
        long __functionAddress = SOFTLoopback.getInstance().LoopbackOpenDeviceSOFT;
        return JNI.invokePP(__functionAddress, deviceName);
    }

    public static long alcLoopbackOpenDeviceSOFT(ByteBuffer deviceName) {
        if (Checks.CHECKS && deviceName != null) {
            Checks.checkNT1(deviceName);
        }
        return SOFTLoopback.nalcLoopbackOpenDeviceSOFT(MemoryUtil.memAddressSafe(deviceName));
    }

    public static long alcLoopbackOpenDeviceSOFT(CharSequence deviceName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int deviceNameEncoded = __buffer.stringParamUTF8(deviceName, true);
        return SOFTLoopback.nalcLoopbackOpenDeviceSOFT(__buffer.addressSafe(deviceName, deviceNameEncoded));
    }

    public static boolean alcIsRenderFormatSupportedSOFT(long device, int frequency, int channels, int type) {
        long __functionAddress = SOFTLoopback.getInstance().IsRenderFormatSupportedSOFT;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.invokePIIIZ(__functionAddress, device, frequency, channels, type);
    }

    public static void nalcRenderSamplesSOFT(long device, long buffer, int samples) {
        long __functionAddress = SOFTLoopback.getInstance().RenderSamplesSOFT;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        JNI.invokePPIV(__functionAddress, device, buffer, samples);
    }

    public static void alcRenderSamplesSOFT(long device, ByteBuffer buffer, int samples) {
        SOFTLoopback.nalcRenderSamplesSOFT(device, MemoryUtil.memAddress(buffer), samples);
    }
}

