/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;

public class SOFTPauseDevice {
    public final long DevicePauseSOFT;
    public final long DeviceResumeSOFT;

    protected SOFTPauseDevice() {
        throw new UnsupportedOperationException();
    }

    public SOFTPauseDevice(FunctionProviderLocal provider, long device) {
        this.DevicePauseSOFT = provider.getFunctionAddress(device, "alcDevicePauseSOFT");
        this.DeviceResumeSOFT = provider.getFunctionAddress(device, "alcDeviceResumeSOFT");
    }

    public static SOFTPauseDevice getInstance() {
        return SOFTPauseDevice.getInstance(ALC.getCapabilities());
    }

    public static SOFTPauseDevice getInstance(ALCCapabilities caps) {
        return Checks.checkFunctionality(caps.__SOFTPauseDevice);
    }

    static SOFTPauseDevice create(Set<String> ext, FunctionProviderLocal provider, long device) {
        if (!ext.contains("ALC_SOFT_pause_device")) {
            return null;
        }
        SOFTPauseDevice funcs = new SOFTPauseDevice(provider, device);
        boolean supported = Checks.checkFunctions(funcs.DevicePauseSOFT, funcs.DeviceResumeSOFT);
        return ALC.checkExtension("ALC_SOFT_pause_device", funcs, supported);
    }

    public static void alcDevicePauseSOFT(long device) {
        long __functionAddress = SOFTPauseDevice.getInstance().DevicePauseSOFT;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        JNI.invokePV(__functionAddress, device);
    }

    public static void alcDeviceResumeSOFT(long device) {
        long __functionAddress = SOFTPauseDevice.getInstance().DeviceResumeSOFT;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        JNI.invokePV(__functionAddress, device);
    }
}

