/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.openal.AL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class SOFTSourceLatency {
    public static final int AL_SAMPLE_OFFSET_LATENCY_SOFT = 4608;
    public static final int AL_SEC_OFFSET_LATENCY_SOFT = 4609;
    public final long SourcedSOFT;
    public final long Source3dSOFT;
    public final long SourcedvSOFT;
    public final long GetSourcedSOFT;
    public final long GetSource3dSOFT;
    public final long GetSourcedvSOFT;
    public final long Sourcei64SOFT;
    public final long Source3i64SOFT;
    public final long Sourcei64vSOFT;
    public final long GetSourcei64SOFT;
    public final long GetSource3i64SOFT;
    public final long GetSourcei64vSOFT;

    protected SOFTSourceLatency() {
        throw new UnsupportedOperationException();
    }

    public SOFTSourceLatency(FunctionProvider provider) {
        this.SourcedSOFT = provider.getFunctionAddress("alSourcedSOFT");
        this.Source3dSOFT = provider.getFunctionAddress("alSource3dSOFT");
        this.SourcedvSOFT = provider.getFunctionAddress("alSourcedvSOFT");
        this.GetSourcedSOFT = provider.getFunctionAddress("alGetSourcedSOFT");
        this.GetSource3dSOFT = provider.getFunctionAddress("alGetSource3dSOFT");
        this.GetSourcedvSOFT = provider.getFunctionAddress("alGetSourcedvSOFT");
        this.Sourcei64SOFT = provider.getFunctionAddress("alSourcei64SOFT");
        this.Source3i64SOFT = provider.getFunctionAddress("alSource3i64SOFT");
        this.Sourcei64vSOFT = provider.getFunctionAddress("alSourcei64vSOFT");
        this.GetSourcei64SOFT = provider.getFunctionAddress("alGetSourcei64SOFT");
        this.GetSource3i64SOFT = provider.getFunctionAddress("alGetSource3i64SOFT");
        this.GetSourcei64vSOFT = provider.getFunctionAddress("alGetSourcei64vSOFT");
    }

    public static SOFTSourceLatency getInstance() {
        return Checks.checkFunctionality(AL.getCapabilities().__SOFTSourceLatency);
    }

    static SOFTSourceLatency create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("AL_SOFT_source_latency")) {
            return null;
        }
        SOFTSourceLatency funcs = new SOFTSourceLatency(provider);
        boolean supported = Checks.checkFunctions(funcs.SourcedSOFT, funcs.Source3dSOFT, funcs.SourcedvSOFT, funcs.GetSourcedSOFT, funcs.GetSource3dSOFT, funcs.GetSourcedvSOFT, funcs.Sourcei64SOFT, funcs.Source3i64SOFT, funcs.Sourcei64vSOFT, funcs.GetSourcei64SOFT, funcs.GetSource3i64SOFT, funcs.GetSourcei64vSOFT);
        return AL.checkExtension("AL_SOFT_source_latency", funcs, supported);
    }

    public static void alSourcedSOFT(int source, int param, double value) {
        long __functionAddress = SOFTSourceLatency.getInstance().SourcedSOFT;
        JNI.invokeIIDV(__functionAddress, source, param, value);
    }

    public static void alSource3dSOFT(int source, int param, double value1, double value2, double value3) {
        long __functionAddress = SOFTSourceLatency.getInstance().Source3dSOFT;
        JNI.invokeIIDDDV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void nalSourcedvSOFT(int source, int param, long value) {
        long __functionAddress = SOFTSourceLatency.getInstance().SourcedvSOFT;
        JNI.invokeIIPV(__functionAddress, source, param, value);
    }

    public static void alSourcedvSOFT(int source, int param, ByteBuffer value) {
        SOFTSourceLatency.nalSourcedvSOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void alSourcedvSOFT(int source, int param, DoubleBuffer value) {
        SOFTSourceLatency.nalSourcedvSOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void nalGetSourcedSOFT(int source, int param, long value) {
        long __functionAddress = SOFTSourceLatency.getInstance().GetSourcedSOFT;
        JNI.invokeIIPV(__functionAddress, source, param, value);
    }

    public static void alGetSourcedSOFT(int source, int param, ByteBuffer value) {
        SOFTSourceLatency.nalGetSourcedSOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void alGetSourcedSOFT(int source, int param, DoubleBuffer value) {
        SOFTSourceLatency.nalGetSourcedSOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void nalGetSource3dSOFT(int source, int param, long value1, long value2, long value3) {
        long __functionAddress = SOFTSourceLatency.getInstance().GetSource3dSOFT;
        JNI.invokeIIPPPV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void alGetSource3dSOFT(int source, int param, ByteBuffer value1, ByteBuffer value2, ByteBuffer value3) {
        SOFTSourceLatency.nalGetSource3dSOFT(source, param, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void alGetSource3dSOFT(int source, int param, DoubleBuffer value1, DoubleBuffer value2, DoubleBuffer value3) {
        SOFTSourceLatency.nalGetSource3dSOFT(source, param, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void nalGetSourcedvSOFT(int source, int param, long values) {
        long __functionAddress = SOFTSourceLatency.getInstance().GetSourcedvSOFT;
        JNI.invokeIIPV(__functionAddress, source, param, values);
    }

    public static void alGetSourcedvSOFT(int source, int param, ByteBuffer values) {
        SOFTSourceLatency.nalGetSourcedvSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void alGetSourcedvSOFT(int source, int param, DoubleBuffer values) {
        SOFTSourceLatency.nalGetSourcedvSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void alSourcei64SOFT(int source, int param, long value) {
        long __functionAddress = SOFTSourceLatency.getInstance().Sourcei64SOFT;
        JNI.invokeIIJV(__functionAddress, source, param, value);
    }

    public static void alSource3i64SOFT(int source, int param, long value1, long value2, long value3) {
        long __functionAddress = SOFTSourceLatency.getInstance().Source3i64SOFT;
        JNI.invokeIIJJJV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void nalSourcei64vSOFT(int source, int param, long values) {
        long __functionAddress = SOFTSourceLatency.getInstance().Sourcei64vSOFT;
        JNI.invokeIIPV(__functionAddress, source, param, values);
    }

    public static void alSourcei64vSOFT(int source, int param, ByteBuffer values) {
        SOFTSourceLatency.nalSourcei64vSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void alSourcei64vSOFT(int source, int param, LongBuffer values) {
        SOFTSourceLatency.nalSourcei64vSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void nalGetSourcei64SOFT(int source, int param, long value) {
        long __functionAddress = SOFTSourceLatency.getInstance().GetSourcei64SOFT;
        JNI.invokeIIPV(__functionAddress, source, param, value);
    }

    public static void alGetSourcei64SOFT(int source, int param, ByteBuffer value) {
        SOFTSourceLatency.nalGetSourcei64SOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void alGetSourcei64SOFT(int source, int param, LongBuffer value) {
        SOFTSourceLatency.nalGetSourcei64SOFT(source, param, MemoryUtil.memAddress(value));
    }

    public static void nalGetSource3i64SOFT(int source, int param, long value1, long value2, long value3) {
        long __functionAddress = SOFTSourceLatency.getInstance().GetSource3i64SOFT;
        JNI.invokeIIPPPV(__functionAddress, source, param, value1, value2, value3);
    }

    public static void alGetSource3i64SOFT(int source, int param, ByteBuffer value1, ByteBuffer value2, ByteBuffer value3) {
        SOFTSourceLatency.nalGetSource3i64SOFT(source, param, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void alGetSource3i64SOFT(int source, int param, LongBuffer value1, LongBuffer value2, LongBuffer value3) {
        SOFTSourceLatency.nalGetSource3i64SOFT(source, param, MemoryUtil.memAddress(value1), MemoryUtil.memAddress(value2), MemoryUtil.memAddress(value3));
    }

    public static void nalGetSourcei64vSOFT(int source, int param, long values) {
        long __functionAddress = SOFTSourceLatency.getInstance().GetSourcei64vSOFT;
        JNI.invokeIIPV(__functionAddress, source, param, values);
    }

    public static void alGetSourcei64vSOFT(int source, int param, ByteBuffer values) {
        SOFTSourceLatency.nalGetSourcei64vSOFT(source, param, MemoryUtil.memAddress(values));
    }

    public static void alGetSourcei64vSOFT(int source, int param, LongBuffer values) {
        SOFTSourceLatency.nalGetSourcei64vSOFT(source, param, MemoryUtil.memAddress(values));
    }
}

