/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLBusAddressAMD;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class AMDBusAddressableMemory {
    public static final int CL_MEM_BUS_ADDRESSABLE_AMD = 0x40000000;
    public static final int CL_MEM_EXTERNAL_PHYSICAL_AMD = Integer.MIN_VALUE;
    public static final int CL_COMMAND_WAIT_SIGNAL_AMD = 16512;
    public static final int CL_COMMAND_WRITE_SIGNAL_AMD = 16513;
    public static final int CL_COMMAND_MAKE_BUFFERS_RESIDENT_AMD = 16514;
    public final long EnqueueWaitSignalAMD;
    public final long EnqueueWriteSignalAMD;
    public final long EnqueueMakeBuffersResidentAMD;

    protected AMDBusAddressableMemory() {
        throw new UnsupportedOperationException();
    }

    public AMDBusAddressableMemory(FunctionProvider provider) {
        this.EnqueueWaitSignalAMD = provider.getFunctionAddress("clEnqueueWaitSignalAMD");
        this.EnqueueWriteSignalAMD = provider.getFunctionAddress("clEnqueueWriteSignalAMD");
        this.EnqueueMakeBuffersResidentAMD = provider.getFunctionAddress("clEnqueueMakeBuffersResidentAMD");
    }

    public static AMDBusAddressableMemory getInstance() {
        return AMDBusAddressableMemory.getInstance(CL.getICD());
    }

    public static AMDBusAddressableMemory getInstance(CLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDBusAddressableMemory);
    }

    static AMDBusAddressableMemory create(FunctionProvider provider) {
        AMDBusAddressableMemory funcs = new AMDBusAddressableMemory(provider);
        boolean supported = Checks.checkFunctions(funcs.EnqueueWaitSignalAMD, funcs.EnqueueWriteSignalAMD, funcs.EnqueueMakeBuffersResidentAMD);
        return supported ? funcs : null;
    }

    public static int nclEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = AMDBusAddressableMemory.getInstance().EnqueueWaitSignalAMD;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
            Checks.checkPointer(mem_object);
        }
        return JNI.callPPIIPPI(__functionAddress, command_queue, mem_object, value, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWaitSignalAMD(long command_queue, long mem_object, int value, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueWaitSignalAMD(command_queue, mem_object, value, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = AMDBusAddressableMemory.getInstance().EnqueueWriteSignalAMD;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
            Checks.checkPointer(mem_object);
        }
        return JNI.callPPIJIPPI(__functionAddress, command_queue, mem_object, value, offset, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueWriteSignalAMD(long command_queue, long mem_object, int value, long offset, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return AMDBusAddressableMemory.nclEnqueueWriteSignalAMD(command_queue, mem_object, value, offset, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueMakeBuffersResidentAMD(long command_queue, int num_mem_objs, long mem_objects, int blocking_make_resident, long bus_addresses, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = AMDBusAddressableMemory.getInstance().EnqueueMakeBuffersResidentAMD;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPIPIPPI(__functionAddress, command_queue, num_mem_objs, mem_objects, blocking_make_resident, bus_addresses, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueMakeBuffersResidentAMD(long command_queue, int num_mem_objs, ByteBuffer mem_objects, int blocking_make_resident, CLBusAddressAMD.Buffer bus_addresses, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_mem_objs << Pointer.POINTER_SHIFT);
            Checks.checkBuffer(bus_addresses, num_mem_objs);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, num_mem_objs, MemoryUtil.memAddress(mem_objects), blocking_make_resident, bus_addresses.address(), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueMakeBuffersResidentAMD(long command_queue, PointerBuffer mem_objects, int blocking_make_resident, CLBusAddressAMD.Buffer bus_addresses, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(bus_addresses, mem_objects.remaining());
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return AMDBusAddressableMemory.nclEnqueueMakeBuffersResidentAMD(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), blocking_make_resident, bus_addresses.address(), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

