/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class APPLEContextLoggingFunctions {
    public final long LogMessagesToSystemLogAPPLE;
    public final long LogMessagesToStdoutAPPLE;
    public final long LogMessagesToStderrAPPLE;

    protected APPLEContextLoggingFunctions() {
        throw new UnsupportedOperationException();
    }

    public APPLEContextLoggingFunctions(FunctionProvider provider) {
        this.LogMessagesToSystemLogAPPLE = provider.getFunctionAddress("clLogMessagesToSystemLogAPPLE");
        this.LogMessagesToStdoutAPPLE = provider.getFunctionAddress("clLogMessagesToStdoutAPPLE");
        this.LogMessagesToStderrAPPLE = provider.getFunctionAddress("clLogMessagesToStderrAPPLE");
    }

    public static APPLEContextLoggingFunctions getInstance() {
        return APPLEContextLoggingFunctions.getInstance(CL.getICD());
    }

    public static APPLEContextLoggingFunctions getInstance(CLCapabilities caps) {
        return Checks.checkFunctionality(caps.__APPLEContextLoggingFunctions);
    }

    static APPLEContextLoggingFunctions create(FunctionProvider provider) {
        APPLEContextLoggingFunctions funcs = new APPLEContextLoggingFunctions(provider);
        boolean supported = Checks.checkFunctions(funcs.LogMessagesToSystemLogAPPLE, funcs.LogMessagesToStdoutAPPLE, funcs.LogMessagesToStderrAPPLE);
        return supported ? funcs : null;
    }

    public static void nclLogMessagesToSystemLogAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = APPLEContextLoggingFunctions.getInstance().LogMessagesToSystemLogAPPLE;
        JNI.callPPPPV(__functionAddress, errstr, private_info, cb, user_data);
    }

    public static void clLogMessagesToSystemLogAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToSystemLogAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }

    public static void nclLogMessagesToStdoutAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = APPLEContextLoggingFunctions.getInstance().LogMessagesToStdoutAPPLE;
        JNI.callPPPPV(__functionAddress, errstr, private_info, cb, user_data);
    }

    public static void clLogMessagesToStdoutAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToStdoutAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }

    public static void nclLogMessagesToStderrAPPLE(long errstr, long private_info, long cb, long user_data) {
        long __functionAddress = APPLEContextLoggingFunctions.getInstance().LogMessagesToStderrAPPLE;
        JNI.callPPPPV(__functionAddress, errstr, private_info, cb, user_data);
    }

    public static void clLogMessagesToStderrAPPLE(ByteBuffer errstr, ByteBuffer private_info, long cb, ByteBuffer user_data) {
        APPLEContextLoggingFunctions.nclLogMessagesToStderrAPPLE(MemoryUtil.memAddress(errstr), MemoryUtil.memAddress(private_info), cb, MemoryUtil.memAddress(user_data));
    }
}

