/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLBusAddressAMD
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int SURFBUSADDRESS;
    public static final int SIGNALBUSADDRESS;

    CLBusAddressAMD(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public CLBusAddressAMD(long struct) {
        this(struct, null);
    }

    public CLBusAddressAMD(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long surfbusaddress() {
        return CLBusAddressAMD.nsurfbusaddress(this.address());
    }

    public long signalbusaddress() {
        return CLBusAddressAMD.nsignalbusaddress(this.address());
    }

    public CLBusAddressAMD surfbusaddress(long value) {
        CLBusAddressAMD.nsurfbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD signalbusaddress(long value) {
        CLBusAddressAMD.nsignalbusaddress(this.address(), value);
        return this;
    }

    public CLBusAddressAMD set(long surfbusaddress, long signalbusaddress) {
        this.surfbusaddress(surfbusaddress);
        this.signalbusaddress(signalbusaddress);
        return this;
    }

    public CLBusAddressAMD nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public CLBusAddressAMD set(CLBusAddressAMD src) {
        return this.nset(src.address());
    }

    public CLBusAddressAMD set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static CLBusAddressAMD malloc() {
        return new CLBusAddressAMD(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CLBusAddressAMD calloc() {
        return new CLBusAddressAMD(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CLBusAddressAMD create() {
        return new CLBusAddressAMD(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static long nsurfbusaddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SURFBUSADDRESS);
    }

    public static long nsignalbusaddress(long struct) {
        return MemoryUtil.memGetLong(struct + (long)SIGNALBUSADDRESS);
    }

    public static void nsurfbusaddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SURFBUSADDRESS, value);
    }

    public static void nsignalbusaddress(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)SIGNALBUSADDRESS, value);
    }

    static {
        Struct.Layout layout = CLBusAddressAMD.__struct(CLBusAddressAMD.__member(8), CLBusAddressAMD.__member(8));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        SURFBUSADDRESS = layout.offsetof(0);
        SIGNALBUSADDRESS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<CLBusAddressAMD, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected CLBusAddressAMD newInstance(long address) {
            return new CLBusAddressAMD(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long surfbusaddress() {
            return CLBusAddressAMD.nsurfbusaddress(this.address());
        }

        public long signalbusaddress() {
            return CLBusAddressAMD.nsignalbusaddress(this.address());
        }

        public Buffer surfbusaddress(long value) {
            CLBusAddressAMD.nsurfbusaddress(this.address(), value);
            return this;
        }

        public Buffer signalbusaddress(long value) {
            CLBusAddressAMD.nsignalbusaddress(this.address(), value);
            return this;
        }
    }
}

