/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class AMDSparseTexture {
    public static final int GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = 1;
    public static final int GL_VIRTUAL_PAGE_SIZE_X_AMD = 37269;
    public static final int GL_VIRTUAL_PAGE_SIZE_Y_AMD = 37270;
    public static final int GL_VIRTUAL_PAGE_SIZE_Z_AMD = 37271;
    public static final int GL_MAX_SPARSE_TEXTURE_SIZE_AMD = 37272;
    public static final int GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = 37273;
    public static final int GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = 37274;
    public static final int GL_MIN_SPARSE_LEVEL_AMD = 37275;
    public static final int GL_MIN_LOD_WARNING_AMD = 37276;
    public final long TexStorageSparseAMD;
    public final long TextureStorageSparseAMD;

    protected AMDSparseTexture() {
        throw new UnsupportedOperationException();
    }

    public AMDSparseTexture(FunctionProvider provider) {
        this.TexStorageSparseAMD = provider.getFunctionAddress("glTexStorageSparseAMD");
        this.TextureStorageSparseAMD = provider.getFunctionAddress("glTextureStorageSparseAMD");
    }

    public static AMDSparseTexture getInstance() {
        return AMDSparseTexture.getInstance(GL.getCapabilities());
    }

    public static AMDSparseTexture getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDSparseTexture);
    }

    static AMDSparseTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_sparse_texture")) {
            return null;
        }
        AMDSparseTexture funcs = new AMDSparseTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.TexStorageSparseAMD, funcs.TextureStorageSparseAMD);
        return GL.checkExtension("GL_AMD_sparse_texture", funcs, supported);
    }

    public static void glTexStorageSparseAMD(int target, int internalFormat, int width, int height, int depth, int layers, int flags) {
        long __functionAddress = AMDSparseTexture.getInstance().TexStorageSparseAMD;
        JNI.callIIIIIIIV(__functionAddress, target, internalFormat, width, height, depth, layers, flags);
    }

    public static void glTextureStorageSparseAMD(int texture, int target, int internalFormat, int width, int height, int depth, int layers, int flags) {
        long __functionAddress = AMDSparseTexture.getInstance().TextureStorageSparseAMD;
        JNI.callIIIIIIIIV(__functionAddress, texture, target, internalFormat, width, height, depth, layers, flags);
    }
}

