/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBFramebufferNoAttachments {
    public static final int GL_FRAMEBUFFER_DEFAULT_WIDTH = 37648;
    public static final int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 37649;
    public static final int GL_FRAMEBUFFER_DEFAULT_LAYERS = 37650;
    public static final int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 37651;
    public static final int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 37652;
    public static final int GL_MAX_FRAMEBUFFER_WIDTH = 37653;
    public static final int GL_MAX_FRAMEBUFFER_HEIGHT = 37654;
    public static final int GL_MAX_FRAMEBUFFER_LAYERS = 37655;
    public static final int GL_MAX_FRAMEBUFFER_SAMPLES = 37656;
    public final long FramebufferParameteri;
    public final long GetFramebufferParameteriv;
    public final long NamedFramebufferParameteriEXT;
    public final long GetNamedFramebufferParameterivEXT;

    protected ARBFramebufferNoAttachments() {
        throw new UnsupportedOperationException();
    }

    public ARBFramebufferNoAttachments(FunctionProvider provider) {
        this.FramebufferParameteri = provider.getFunctionAddress("glFramebufferParameteri");
        this.GetFramebufferParameteriv = provider.getFunctionAddress("glGetFramebufferParameteriv");
        this.NamedFramebufferParameteriEXT = provider.getFunctionAddress("glNamedFramebufferParameteriEXT");
        this.GetNamedFramebufferParameterivEXT = provider.getFunctionAddress("glGetNamedFramebufferParameterivEXT");
    }

    public static ARBFramebufferNoAttachments getInstance() {
        return ARBFramebufferNoAttachments.getInstance(GL.getCapabilities());
    }

    public static ARBFramebufferNoAttachments getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBFramebufferNoAttachments);
    }

    static ARBFramebufferNoAttachments create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_framebuffer_no_attachments")) {
            return null;
        }
        ARBFramebufferNoAttachments funcs = new ARBFramebufferNoAttachments(provider);
        boolean supported = Checks.checkFunctions(funcs.FramebufferParameteri, funcs.GetFramebufferParameteriv, ext.contains("GL_EXT_direct_state_access") ? funcs.NamedFramebufferParameteriEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.GetNamedFramebufferParameterivEXT : -1L);
        return GL.checkExtension("GL_ARB_framebuffer_no_attachments", funcs, supported);
    }

    public static void glFramebufferParameteri(int target, int pname, int param) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().FramebufferParameteri;
        JNI.callIIIV(__functionAddress, target, pname, param);
    }

    public static void nglGetFramebufferParameteriv(int target, int pname, long params) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().GetFramebufferParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetFramebufferParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBFramebufferNoAttachments.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBFramebufferNoAttachments.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBFramebufferNoAttachments.nglGetFramebufferParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glNamedFramebufferParameteriEXT(int framebuffer, int pname, int param) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().NamedFramebufferParameteriEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIV(__functionAddress, framebuffer, pname, param);
    }

    public static void nglGetNamedFramebufferParameterivEXT(int framebuffer, int pname, long params) {
        long __functionAddress = ARBFramebufferNoAttachments.getInstance().GetNamedFramebufferParameterivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIPV(__functionAddress, framebuffer, pname, params);
    }

    public static void glGetNamedFramebufferParameterivEXT(int framebuffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedFramebufferParameterivEXT(int framebuffer, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetNamedFramebufferParameteriEXT(int framebuffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBFramebufferNoAttachments.nglGetNamedFramebufferParameterivEXT(framebuffer, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

