/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;
    public final long DeleteObjectARB;
    public final long GetHandleARB;
    public final long DetachObjectARB;
    public final long CreateShaderObjectARB;
    public final long ShaderSourceARB;
    public final long CompileShaderARB;
    public final long CreateProgramObjectARB;
    public final long AttachObjectARB;
    public final long LinkProgramARB;
    public final long UseProgramObjectARB;
    public final long ValidateProgramARB;
    public final long Uniform1fARB;
    public final long Uniform2fARB;
    public final long Uniform3fARB;
    public final long Uniform4fARB;
    public final long Uniform1iARB;
    public final long Uniform2iARB;
    public final long Uniform3iARB;
    public final long Uniform4iARB;
    public final long Uniform1fvARB;
    public final long Uniform2fvARB;
    public final long Uniform3fvARB;
    public final long Uniform4fvARB;
    public final long Uniform1ivARB;
    public final long Uniform2ivARB;
    public final long Uniform3ivARB;
    public final long Uniform4ivARB;
    public final long UniformMatrix2fvARB;
    public final long UniformMatrix3fvARB;
    public final long UniformMatrix4fvARB;
    public final long GetObjectParameterfvARB;
    public final long GetObjectParameterivARB;
    public final long GetInfoLogARB;
    public final long GetAttachedObjectsARB;
    public final long GetUniformLocationARB;
    public final long GetActiveUniformARB;
    public final long GetUniformfvARB;
    public final long GetUniformivARB;
    public final long GetShaderSourceARB;

    protected ARBShaderObjects() {
        throw new UnsupportedOperationException();
    }

    public ARBShaderObjects(FunctionProvider provider) {
        this.DeleteObjectARB = provider.getFunctionAddress("glDeleteObjectARB");
        this.GetHandleARB = provider.getFunctionAddress("glGetHandleARB");
        this.DetachObjectARB = provider.getFunctionAddress("glDetachObjectARB");
        this.CreateShaderObjectARB = provider.getFunctionAddress("glCreateShaderObjectARB");
        this.ShaderSourceARB = provider.getFunctionAddress("glShaderSourceARB");
        this.CompileShaderARB = provider.getFunctionAddress("glCompileShaderARB");
        this.CreateProgramObjectARB = provider.getFunctionAddress("glCreateProgramObjectARB");
        this.AttachObjectARB = provider.getFunctionAddress("glAttachObjectARB");
        this.LinkProgramARB = provider.getFunctionAddress("glLinkProgramARB");
        this.UseProgramObjectARB = provider.getFunctionAddress("glUseProgramObjectARB");
        this.ValidateProgramARB = provider.getFunctionAddress("glValidateProgramARB");
        this.Uniform1fARB = provider.getFunctionAddress("glUniform1fARB");
        this.Uniform2fARB = provider.getFunctionAddress("glUniform2fARB");
        this.Uniform3fARB = provider.getFunctionAddress("glUniform3fARB");
        this.Uniform4fARB = provider.getFunctionAddress("glUniform4fARB");
        this.Uniform1iARB = provider.getFunctionAddress("glUniform1iARB");
        this.Uniform2iARB = provider.getFunctionAddress("glUniform2iARB");
        this.Uniform3iARB = provider.getFunctionAddress("glUniform3iARB");
        this.Uniform4iARB = provider.getFunctionAddress("glUniform4iARB");
        this.Uniform1fvARB = provider.getFunctionAddress("glUniform1fvARB");
        this.Uniform2fvARB = provider.getFunctionAddress("glUniform2fvARB");
        this.Uniform3fvARB = provider.getFunctionAddress("glUniform3fvARB");
        this.Uniform4fvARB = provider.getFunctionAddress("glUniform4fvARB");
        this.Uniform1ivARB = provider.getFunctionAddress("glUniform1ivARB");
        this.Uniform2ivARB = provider.getFunctionAddress("glUniform2ivARB");
        this.Uniform3ivARB = provider.getFunctionAddress("glUniform3ivARB");
        this.Uniform4ivARB = provider.getFunctionAddress("glUniform4ivARB");
        this.UniformMatrix2fvARB = provider.getFunctionAddress("glUniformMatrix2fvARB");
        this.UniformMatrix3fvARB = provider.getFunctionAddress("glUniformMatrix3fvARB");
        this.UniformMatrix4fvARB = provider.getFunctionAddress("glUniformMatrix4fvARB");
        this.GetObjectParameterfvARB = provider.getFunctionAddress("glGetObjectParameterfvARB");
        this.GetObjectParameterivARB = provider.getFunctionAddress("glGetObjectParameterivARB");
        this.GetInfoLogARB = provider.getFunctionAddress("glGetInfoLogARB");
        this.GetAttachedObjectsARB = provider.getFunctionAddress("glGetAttachedObjectsARB");
        this.GetUniformLocationARB = provider.getFunctionAddress("glGetUniformLocationARB");
        this.GetActiveUniformARB = provider.getFunctionAddress("glGetActiveUniformARB");
        this.GetUniformfvARB = provider.getFunctionAddress("glGetUniformfvARB");
        this.GetUniformivARB = provider.getFunctionAddress("glGetUniformivARB");
        this.GetShaderSourceARB = provider.getFunctionAddress("glGetShaderSourceARB");
    }

    public static ARBShaderObjects getInstance() {
        return ARBShaderObjects.getInstance(GL.getCapabilities());
    }

    public static ARBShaderObjects getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBShaderObjects);
    }

    static ARBShaderObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_shader_objects")) {
            return null;
        }
        ARBShaderObjects funcs = new ARBShaderObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.DeleteObjectARB, funcs.GetHandleARB, funcs.DetachObjectARB, funcs.CreateShaderObjectARB, funcs.ShaderSourceARB, funcs.CompileShaderARB, funcs.CreateProgramObjectARB, funcs.AttachObjectARB, funcs.LinkProgramARB, funcs.UseProgramObjectARB, funcs.ValidateProgramARB, funcs.Uniform1fARB, funcs.Uniform2fARB, funcs.Uniform3fARB, funcs.Uniform4fARB, funcs.Uniform1iARB, funcs.Uniform2iARB, funcs.Uniform3iARB, funcs.Uniform4iARB, funcs.Uniform1fvARB, funcs.Uniform2fvARB, funcs.Uniform3fvARB, funcs.Uniform4fvARB, funcs.Uniform1ivARB, funcs.Uniform2ivARB, funcs.Uniform3ivARB, funcs.Uniform4ivARB, funcs.UniformMatrix2fvARB, funcs.UniformMatrix3fvARB, funcs.UniformMatrix4fvARB, funcs.GetObjectParameterfvARB, funcs.GetObjectParameterivARB, funcs.GetInfoLogARB, funcs.GetAttachedObjectsARB, funcs.GetUniformLocationARB, funcs.GetActiveUniformARB, funcs.GetUniformfvARB, funcs.GetUniformivARB, funcs.GetShaderSourceARB);
        return GL.checkExtension("GL_ARB_shader_objects", funcs, supported);
    }

    public static void glDeleteObjectARB(int obj) {
        long __functionAddress = ARBShaderObjects.getInstance().DeleteObjectARB;
        JNI.callIV(__functionAddress, obj);
    }

    public static int glGetHandleARB(int pname) {
        long __functionAddress = ARBShaderObjects.getInstance().GetHandleARB;
        return JNI.callII(__functionAddress, pname);
    }

    public static void glDetachObjectARB(int containerObj, int attachedObj) {
        long __functionAddress = ARBShaderObjects.getInstance().DetachObjectARB;
        JNI.callIIV(__functionAddress, containerObj, attachedObj);
    }

    public static int glCreateShaderObjectARB(int shaderType) {
        long __functionAddress = ARBShaderObjects.getInstance().CreateShaderObjectARB;
        return JNI.callII(__functionAddress, shaderType);
    }

    public static void nglShaderSourceARB(int shaderObj, int count, long string, long length) {
        long __functionAddress = ARBShaderObjects.getInstance().ShaderSourceARB;
        JNI.callIIPPV(__functionAddress, shaderObj, count, string, length);
    }

    public static void glShaderSourceARB(int shaderObj, int count, ByteBuffer string, ByteBuffer length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)string, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, count, MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSourceARB(int shaderObj, PointerBuffer string, IntBuffer length) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, string.remaining());
        }
        ARBShaderObjects.nglShaderSourceARB(shaderObj, string.remaining(), MemoryUtil.memAddress(string), MemoryUtil.memAddressSafe(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSourceARB(int shaderObj, CharSequence ... string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringAddress = __buffer.pointerArrayParamUTF8i(string);
        try {
            ARBShaderObjects.nglShaderSourceARB(shaderObj, string.length, __buffer.address(stringAddress), __buffer.address(stringAddress + (string.length << Pointer.POINTER_SHIFT)));
        }
        finally {
            __buffer.pointerArrayFree(stringAddress, string.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSourceARB(int shaderObj, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringAddress = __buffer.pointerArrayParamUTF8i(string);
        try {
            ARBShaderObjects.nglShaderSourceARB(shaderObj, 1, __buffer.address(stringAddress), __buffer.address(stringAddress + Pointer.POINTER_SIZE));
        }
        finally {
            __buffer.pointerArrayFree(stringAddress, 1);
        }
    }

    public static void glCompileShaderARB(int shaderObj) {
        long __functionAddress = ARBShaderObjects.getInstance().CompileShaderARB;
        JNI.callIV(__functionAddress, shaderObj);
    }

    public static int glCreateProgramObjectARB() {
        long __functionAddress = ARBShaderObjects.getInstance().CreateProgramObjectARB;
        return JNI.callI(__functionAddress);
    }

    public static void glAttachObjectARB(int containerObj, int obj) {
        long __functionAddress = ARBShaderObjects.getInstance().AttachObjectARB;
        JNI.callIIV(__functionAddress, containerObj, obj);
    }

    public static void glLinkProgramARB(int programObj) {
        long __functionAddress = ARBShaderObjects.getInstance().LinkProgramARB;
        JNI.callIV(__functionAddress, programObj);
    }

    public static void glUseProgramObjectARB(int programObj) {
        long __functionAddress = ARBShaderObjects.getInstance().UseProgramObjectARB;
        JNI.callIV(__functionAddress, programObj);
    }

    public static void glValidateProgramARB(int programObj) {
        long __functionAddress = ARBShaderObjects.getInstance().ValidateProgramARB;
        JNI.callIV(__functionAddress, programObj);
    }

    public static void glUniform1fARB(int location, float v0) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1fARB;
        JNI.callIFV(__functionAddress, location, v0);
    }

    public static void glUniform2fARB(int location, float v0, float v1) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2fARB;
        JNI.callIFFV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3fARB(int location, float v0, float v1, float v2) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3fARB;
        JNI.callIFFFV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4fARB(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4fARB;
        JNI.callIFFFFV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void glUniform1iARB(int location, int v0) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1iARB;
        JNI.callIIV(__functionAddress, location, v0);
    }

    public static void glUniform2iARB(int location, int v0, int v1) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2iARB;
        JNI.callIIIV(__functionAddress, location, v0, v1);
    }

    public static void glUniform3iARB(int location, int v0, int v1, int v2) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3iARB;
        JNI.callIIIIV(__functionAddress, location, v0, v1, v2);
    }

    public static void glUniform4iARB(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4iARB;
        JNI.callIIIIIV(__functionAddress, location, v0, v1, v2, v3);
    }

    public static void nglUniform1fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1fvARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1fvARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        ARBShaderObjects.nglUniform1fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform1fvARB(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2fvARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2fvARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        ARBShaderObjects.nglUniform2fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform2fvARB(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3fvARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3fvARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        ARBShaderObjects.nglUniform3fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform3fvARB(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4fvARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4fvARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4fvARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBShaderObjects.nglUniform4fvARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4fvARB(int location, FloatBuffer value) {
        ARBShaderObjects.nglUniform4fvARB(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniform1ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform1ivARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1ivARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        ARBShaderObjects.nglUniform1ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform1ivARB(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform2ivARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2ivARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        ARBShaderObjects.nglUniform2ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform2ivARB(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform3ivARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3ivARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        ARBShaderObjects.nglUniform3ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform3ivARB(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4ivARB(int location, int count, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().Uniform4ivARB;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4ivARB(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBShaderObjects.nglUniform4ivARB(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4ivARB(int location, IntBuffer value) {
        ARBShaderObjects.nglUniform4ivARB(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().UniformMatrix2fvARB;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2fvARB(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBShaderObjects.nglUniformMatrix2fvARB(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix2fvARB(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().UniformMatrix3fvARB;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3fvARB(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        ARBShaderObjects.nglUniformMatrix3fvARB(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix3fvARB(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4fvARB(int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBShaderObjects.getInstance().UniformMatrix4fvARB;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4fvARB(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        ARBShaderObjects.nglUniformMatrix4fvARB(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4fvARB(int location, boolean transpose, FloatBuffer value) {
        ARBShaderObjects.nglUniformMatrix4fvARB(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglGetObjectParameterfvARB(int obj, int pname, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetObjectParameterfvARB;
        JNI.callIIPV(__functionAddress, obj, pname, params);
    }

    public static void glGetObjectParameterfvARB(int obj, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetObjectParameterfvARB(int obj, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetObjectParameterfvARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetObjectParameterivARB(int obj, int pname, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetObjectParameterivARB;
        JNI.callIIPV(__functionAddress, obj, pname, params);
    }

    public static void glGetObjectParameterivARB(int obj, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetObjectParameterivARB(int obj, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetObjectParameteriARB(int obj, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBShaderObjects.nglGetObjectParameterivARB(obj, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetInfoLogARB(int obj, int maxLength, long length, long infoLog) {
        long __functionAddress = ARBShaderObjects.getInstance().GetInfoLogARB;
        JNI.callIIPPV(__functionAddress, obj, maxLength, length, infoLog);
    }

    public static void glGetInfoLogARB(int obj, int maxLength, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetInfoLogARB(int obj, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderObjects.nglGetInfoLogARB(obj, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetInfoLogARB(int obj, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetInfoLogARB(int obj) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(obj, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetInfoLogARB(obj, maxLength, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void nglGetAttachedObjectsARB(int containerObj, int maxCount, long count, long obj) {
        long __functionAddress = ARBShaderObjects.getInstance().GetAttachedObjectsARB;
        JNI.callIIPPV(__functionAddress, containerObj, maxCount, count, obj);
    }

    public static void glGetAttachedObjectsARB(int containerObj, int maxCount, ByteBuffer count, ByteBuffer obj) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)obj, maxCount << 2);
            if (count != null) {
                Checks.checkBuffer((Buffer)count, 4);
            }
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(obj));
    }

    public static void glGetAttachedObjectsARB(int containerObj, IntBuffer count, IntBuffer obj) {
        if (Checks.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, obj.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(obj));
    }

    public static IntBuffer glGetAttachedObjectsARB(int containerObj, int maxCount) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        IntBuffer obj = BufferUtils.createIntBuffer(maxCount);
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, __buffer.address(count), MemoryUtil.memAddress(obj));
        obj.limit(__buffer.intValue(count));
        return obj.slice();
    }

    public static IntBuffer glGetAttachedObjectsARB(int containerObj) {
        int maxCount = ARBShaderObjects.glGetObjectParameteriARB(containerObj, 35717);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        IntBuffer obj = BufferUtils.createIntBuffer(maxCount);
        ARBShaderObjects.nglGetAttachedObjectsARB(containerObj, maxCount, __buffer.address(count), MemoryUtil.memAddress(obj));
        obj.limit(__buffer.intValue(count));
        return obj.slice();
    }

    public static int nglGetUniformLocationARB(int programObj, long name) {
        long __functionAddress = ARBShaderObjects.getInstance().GetUniformLocationARB;
        return JNI.callIPI(__functionAddress, programObj, name);
    }

    public static int glGetUniformLocationARB(int programObj, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, MemoryUtil.memAddress(name));
    }

    public static int glGetUniformLocationARB(int programObj, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ARBShaderObjects.nglGetUniformLocationARB(programObj, __buffer.address(nameEncoded));
    }

    public static void nglGetActiveUniformARB(int programObj, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = ARBShaderObjects.getInstance().GetActiveUniformARB;
        JNI.callIIIPPPPV(__functionAddress, programObj, index, maxLength, length, size, type, name);
    }

    public static void glGetActiveUniformARB(int programObj, int index, int maxLength, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveUniformARB(int programObj, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveUniformARB(int programObj, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveUniformARB(int programObj, int index, IntBuffer size, IntBuffer type) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(programObj, 35719);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetActiveUniformARB(programObj, index, maxLength, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetUniformfvARB(int programObj, int location, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetUniformfvARB;
        JNI.callIIPV(__functionAddress, programObj, location, params);
    }

    public static void glGetUniformfvARB(int programObj, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformfvARB(int programObj, int location, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static float glGetUniformfARB(int programObj, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        ARBShaderObjects.nglGetUniformfvARB(programObj, location, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetUniformivARB(int programObj, int location, long params) {
        long __functionAddress = ARBShaderObjects.getInstance().GetUniformivARB;
        JNI.callIIPV(__functionAddress, programObj, location, params);
    }

    public static void glGetUniformivARB(int programObj, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformivARB(int programObj, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBShaderObjects.nglGetUniformivARB(programObj, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformiARB(int programObj, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBShaderObjects.nglGetUniformivARB(programObj, location, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetShaderSourceARB(int obj, int maxLength, long length, long source) {
        long __functionAddress = ARBShaderObjects.getInstance().GetShaderSourceARB;
        JNI.callIIPPV(__functionAddress, obj, maxLength, length, source);
    }

    public static void glGetShaderSourceARB(int obj, int maxLength, ByteBuffer length, ByteBuffer source) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)source, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static void glGetShaderSourceARB(int obj, IntBuffer length, ByteBuffer source) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBShaderObjects.nglGetShaderSourceARB(obj, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static String glGetShaderSourceARB(int obj, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }

    public static String glGetShaderSourceARB(int obj) {
        int maxLength = ARBShaderObjects.glGetObjectParameteriARB(obj, 35720);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        ARBShaderObjects.nglGetShaderSourceARB(obj, maxLength, __buffer.address(length), __buffer.address(source));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), source);
    }
}

