/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class ARBTextureStorageMultisample {
    public final long TexStorage2DMultisample;
    public final long TexStorage3DMultisample;
    public final long TextureStorage2DMultisampleEXT;
    public final long TextureStorage3DMultisampleEXT;

    protected ARBTextureStorageMultisample() {
        throw new UnsupportedOperationException();
    }

    public ARBTextureStorageMultisample(FunctionProvider provider) {
        this.TexStorage2DMultisample = provider.getFunctionAddress("glTexStorage2DMultisample");
        this.TexStorage3DMultisample = provider.getFunctionAddress("glTexStorage3DMultisample");
        this.TextureStorage2DMultisampleEXT = provider.getFunctionAddress("glTextureStorage2DMultisampleEXT");
        this.TextureStorage3DMultisampleEXT = provider.getFunctionAddress("glTextureStorage3DMultisampleEXT");
    }

    public static ARBTextureStorageMultisample getInstance() {
        return ARBTextureStorageMultisample.getInstance(GL.getCapabilities());
    }

    public static ARBTextureStorageMultisample getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBTextureStorageMultisample);
    }

    static ARBTextureStorageMultisample create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_texture_storage_multisample")) {
            return null;
        }
        ARBTextureStorageMultisample funcs = new ARBTextureStorageMultisample(provider);
        boolean supported = Checks.checkFunctions(funcs.TexStorage2DMultisample, funcs.TexStorage3DMultisample, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage2DMultisampleEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage3DMultisampleEXT : -1L);
        return GL.checkExtension("GL_ARB_texture_storage_multisample", funcs, supported);
    }

    public static void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = ARBTextureStorageMultisample.getInstance().TexStorage2DMultisample;
        JNI.callIIIIIZV(__functionAddress, target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = ARBTextureStorageMultisample.getInstance().TexStorage3DMultisample;
        JNI.callIIIIIIZV(__functionAddress, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }

    public static void glTextureStorage2DMultisampleEXT(int texture, int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = ARBTextureStorageMultisample.getInstance().TextureStorage2DMultisampleEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIIZV(__functionAddress, texture, target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void glTextureStorage3DMultisampleEXT(int texture, int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = ARBTextureStorageMultisample.getInstance().TextureStorage3DMultisampleEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIIIZV(__functionAddress, texture, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }
}

