/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBTransposeMatrix {
    public static final int GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = 34019;
    public static final int GL_TRANSPOSE_PROJECTION_MATRIX_ARB = 34020;
    public static final int GL_TRANSPOSE_TEXTURE_MATRIX_ARB = 34021;
    public static final int GL_TRANSPOSE_COLOR_MATRIX_ARB = 34022;
    public final long LoadTransposeMatrixfARB;
    public final long LoadTransposeMatrixdARB;
    public final long MultTransposeMatrixfARB;
    public final long MultTransposeMatrixdARB;

    protected ARBTransposeMatrix() {
        throw new UnsupportedOperationException();
    }

    public ARBTransposeMatrix(FunctionProvider provider) {
        this.LoadTransposeMatrixfARB = provider.getFunctionAddress("glLoadTransposeMatrixfARB");
        this.LoadTransposeMatrixdARB = provider.getFunctionAddress("glLoadTransposeMatrixdARB");
        this.MultTransposeMatrixfARB = provider.getFunctionAddress("glMultTransposeMatrixfARB");
        this.MultTransposeMatrixdARB = provider.getFunctionAddress("glMultTransposeMatrixdARB");
    }

    public static ARBTransposeMatrix getInstance() {
        return ARBTransposeMatrix.getInstance(GL.getCapabilities());
    }

    public static ARBTransposeMatrix getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBTransposeMatrix);
    }

    static ARBTransposeMatrix create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_transpose_matrix")) {
            return null;
        }
        ARBTransposeMatrix funcs = new ARBTransposeMatrix(provider);
        boolean supported = Checks.checkFunctions(funcs.LoadTransposeMatrixfARB, funcs.LoadTransposeMatrixdARB, funcs.MultTransposeMatrixfARB, funcs.MultTransposeMatrixdARB);
        return GL.checkExtension("GL_ARB_transpose_matrix", funcs, supported);
    }

    public static void nglLoadTransposeMatrixfARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().LoadTransposeMatrixfARB;
        JNI.callPV(__functionAddress, m);
    }

    public static void glLoadTransposeMatrixfARB(ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 64);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static void glLoadTransposeMatrixfARB(FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static void nglLoadTransposeMatrixdARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().LoadTransposeMatrixdARB;
        JNI.callPV(__functionAddress, m);
    }

    public static void glLoadTransposeMatrixdARB(ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 128);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }

    public static void glLoadTransposeMatrixdARB(DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglLoadTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }

    public static void nglMultTransposeMatrixfARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().MultTransposeMatrixfARB;
        JNI.callPV(__functionAddress, m);
    }

    public static void glMultTransposeMatrixfARB(ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 64);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static void glMultTransposeMatrixfARB(FloatBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixfARB(MemoryUtil.memAddress(m));
    }

    public static void nglMultTransposeMatrixdARB(long m) {
        long __functionAddress = ARBTransposeMatrix.getInstance().MultTransposeMatrixdARB;
        JNI.callPV(__functionAddress, m);
    }

    public static void glMultTransposeMatrixdARB(ByteBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 128);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }

    public static void glMultTransposeMatrixdARB(DoubleBuffer m) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)m, 16);
        }
        ARBTransposeMatrix.nglMultTransposeMatrixdARB(MemoryUtil.memAddress(m));
    }
}

