/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ARBVertexBufferObject {
    public static final int GL_ARRAY_BUFFER_ARB = 34962;
    public static final int GL_ELEMENT_ARRAY_BUFFER_ARB = 34963;
    public static final int GL_ARRAY_BUFFER_BINDING_ARB = 34964;
    public static final int GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = 34965;
    public static final int GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = 34966;
    public static final int GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = 34967;
    public static final int GL_COLOR_ARRAY_BUFFER_BINDING_ARB = 34968;
    public static final int GL_INDEX_ARRAY_BUFFER_BINDING_ARB = 34969;
    public static final int GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = 34970;
    public static final int GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = 34971;
    public static final int GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = 34972;
    public static final int GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = 34973;
    public static final int GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = 34974;
    public static final int GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = 34975;
    public static final int GL_STREAM_DRAW_ARB = 35040;
    public static final int GL_STREAM_READ_ARB = 35041;
    public static final int GL_STREAM_COPY_ARB = 35042;
    public static final int GL_STATIC_DRAW_ARB = 35044;
    public static final int GL_STATIC_READ_ARB = 35045;
    public static final int GL_STATIC_COPY_ARB = 35046;
    public static final int GL_DYNAMIC_DRAW_ARB = 35048;
    public static final int GL_DYNAMIC_READ_ARB = 35049;
    public static final int GL_DYNAMIC_COPY_ARB = 35050;
    public static final int GL_READ_ONLY_ARB = 35000;
    public static final int GL_WRITE_ONLY_ARB = 35001;
    public static final int GL_READ_WRITE_ARB = 35002;
    public static final int GL_BUFFER_SIZE_ARB = 34660;
    public static final int GL_BUFFER_USAGE_ARB = 34661;
    public static final int GL_BUFFER_ACCESS_ARB = 35003;
    public static final int GL_BUFFER_MAPPED_ARB = 35004;
    public static final int GL_BUFFER_MAP_POINTER_ARB = 35005;
    public final long BindBufferARB;
    public final long DeleteBuffersARB;
    public final long GenBuffersARB;
    public final long IsBufferARB;
    public final long BufferDataARB;
    public final long BufferSubDataARB;
    public final long GetBufferSubDataARB;
    public final long MapBufferARB;
    public final long UnmapBufferARB;
    public final long GetBufferParameterivARB;
    public final long GetBufferPointervARB;

    protected ARBVertexBufferObject() {
        throw new UnsupportedOperationException();
    }

    public ARBVertexBufferObject(FunctionProvider provider) {
        this.BindBufferARB = provider.getFunctionAddress("glBindBufferARB");
        this.DeleteBuffersARB = provider.getFunctionAddress("glDeleteBuffersARB");
        this.GenBuffersARB = provider.getFunctionAddress("glGenBuffersARB");
        this.IsBufferARB = provider.getFunctionAddress("glIsBufferARB");
        this.BufferDataARB = provider.getFunctionAddress("glBufferDataARB");
        this.BufferSubDataARB = provider.getFunctionAddress("glBufferSubDataARB");
        this.GetBufferSubDataARB = provider.getFunctionAddress("glGetBufferSubDataARB");
        this.MapBufferARB = provider.getFunctionAddress("glMapBufferARB");
        this.UnmapBufferARB = provider.getFunctionAddress("glUnmapBufferARB");
        this.GetBufferParameterivARB = provider.getFunctionAddress("glGetBufferParameterivARB");
        this.GetBufferPointervARB = provider.getFunctionAddress("glGetBufferPointervARB");
    }

    public static ARBVertexBufferObject getInstance() {
        return ARBVertexBufferObject.getInstance(GL.getCapabilities());
    }

    public static ARBVertexBufferObject getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBVertexBufferObject);
    }

    static ARBVertexBufferObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_vertex_buffer_object")) {
            return null;
        }
        ARBVertexBufferObject funcs = new ARBVertexBufferObject(provider);
        boolean supported = Checks.checkFunctions(funcs.BindBufferARB, funcs.DeleteBuffersARB, funcs.GenBuffersARB, funcs.IsBufferARB, funcs.BufferDataARB, funcs.BufferSubDataARB, funcs.GetBufferSubDataARB, funcs.MapBufferARB, funcs.UnmapBufferARB, funcs.GetBufferParameterivARB, funcs.GetBufferPointervARB);
        return GL.checkExtension("GL_ARB_vertex_buffer_object", funcs, supported);
    }

    public static void glBindBufferARB(int target, int buffer) {
        long __functionAddress = ARBVertexBufferObject.getInstance().BindBufferARB;
        JNI.callIIV(__functionAddress, target, buffer);
    }

    public static void nglDeleteBuffersARB(int n, long buffers) {
        long __functionAddress = ARBVertexBufferObject.getInstance().DeleteBuffersARB;
        JNI.callIPV(__functionAddress, n, buffers);
    }

    public static void glDeleteBuffersARB(int n, ByteBuffer buffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        ARBVertexBufferObject.nglDeleteBuffersARB(n, MemoryUtil.memAddress(buffers));
    }

    public static void glDeleteBuffersARB(IntBuffer buffers) {
        ARBVertexBufferObject.nglDeleteBuffersARB(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static void glDeleteBuffersARB(int buffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam(buffer);
        ARBVertexBufferObject.nglDeleteBuffersARB(1, __buffer.address(buffers));
    }

    public static void nglGenBuffersARB(int n, long buffers) {
        long __functionAddress = ARBVertexBufferObject.getInstance().GenBuffersARB;
        JNI.callIPV(__functionAddress, n, buffers);
    }

    public static void glGenBuffersARB(int n, ByteBuffer buffers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buffers, n << 2);
        }
        ARBVertexBufferObject.nglGenBuffersARB(n, MemoryUtil.memAddress(buffers));
    }

    public static void glGenBuffersARB(IntBuffer buffers) {
        ARBVertexBufferObject.nglGenBuffersARB(buffers.remaining(), MemoryUtil.memAddress(buffers));
    }

    public static int glGenBuffersARB() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int buffers = __buffer.intParam();
        ARBVertexBufferObject.nglGenBuffersARB(1, __buffer.address(buffers));
        return __buffer.intValue(buffers);
    }

    public static boolean glIsBufferARB(int buffer) {
        long __functionAddress = ARBVertexBufferObject.getInstance().IsBufferARB;
        return JNI.callIZ(__functionAddress, buffer);
    }

    public static void nglBufferDataARB(int target, long size, long data, int usage) {
        long __functionAddress = ARBVertexBufferObject.getInstance().BufferDataARB;
        JNI.callIPPIV(__functionAddress, target, size, data, usage);
    }

    public static void glBufferDataARB(int target, long size, ByteBuffer data, int usage) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBVertexBufferObject.nglBufferDataARB(target, size, MemoryUtil.memAddressSafe(data), usage);
    }

    public static void glBufferDataARB(int target, long size, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, size, 0L, usage);
    }

    public static void glBufferDataARB(int target, ByteBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining(), MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferDataARB(int target, ShortBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 1, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferDataARB(int target, IntBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferDataARB(int target, FloatBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 2, MemoryUtil.memAddress(data), usage);
    }

    public static void glBufferDataARB(int target, DoubleBuffer data, int usage) {
        ARBVertexBufferObject.nglBufferDataARB(target, data.remaining() << 3, MemoryUtil.memAddress(data), usage);
    }

    public static void nglBufferSubDataARB(int target, long offset, long size, long data) {
        long __functionAddress = ARBVertexBufferObject.getInstance().BufferSubDataARB;
        JNI.callIPPPV(__functionAddress, target, offset, size, data);
    }

    public static void glBufferSubDataARB(int target, long offset, long size, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glBufferSubDataARB(int target, long offset, ByteBuffer data) {
        ARBVertexBufferObject.nglBufferSubDataARB(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void nglGetBufferSubDataARB(int target, long offset, long size, long data) {
        long __functionAddress = ARBVertexBufferObject.getInstance().GetBufferSubDataARB;
        JNI.callIPPPV(__functionAddress, target, offset, size, data);
    }

    public static void glGetBufferSubDataARB(int target, long offset, long size, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, size);
        }
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, size, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, ByteBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining(), MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, ShortBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 1, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, IntBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, FloatBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 2, MemoryUtil.memAddress(data));
    }

    public static void glGetBufferSubDataARB(int target, long offset, DoubleBuffer data) {
        ARBVertexBufferObject.nglGetBufferSubDataARB(target, offset, data.remaining() << 3, MemoryUtil.memAddress(data));
    }

    public static long nglMapBufferARB(int target, int access) {
        long __functionAddress = ARBVertexBufferObject.getInstance().MapBufferARB;
        return JNI.callIIP(__functionAddress, target, access);
    }

    public static ByteBuffer glMapBufferARB(int target, int access) {
        long __result = ARBVertexBufferObject.nglMapBufferARB(target, access);
        return MemoryUtil.memByteBuffer(__result, ARBVertexBufferObject.glGetBufferParameteriARB(target, 34660));
    }

    public static ByteBuffer glMapBufferARB(int target, int access, ByteBuffer old_buffer) {
        long __result = ARBVertexBufferObject.nglMapBufferARB(target, access);
        int length = ARBVertexBufferObject.glGetBufferParameteriARB(target, 34660);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, length) : MemoryUtil.memSetupBuffer(old_buffer, __result, length);
    }

    public static ByteBuffer glMapBufferARB(int target, int access, long length, ByteBuffer old_buffer) {
        long __result = ARBVertexBufferObject.nglMapBufferARB(target, access);
        return old_buffer == null ? MemoryUtil.memByteBuffer(__result, (int)length) : MemoryUtil.memSetupBuffer(old_buffer, __result, (int)length);
    }

    public static boolean glUnmapBufferARB(int target) {
        long __functionAddress = ARBVertexBufferObject.getInstance().UnmapBufferARB;
        return JNI.callIZ(__functionAddress, target);
    }

    public static void nglGetBufferParameterivARB(int target, int pname, long params) {
        long __functionAddress = ARBVertexBufferObject.getInstance().GetBufferParameterivARB;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameterivARB(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBVertexBufferObject.nglGetBufferParameterivARB(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameterivARB(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBVertexBufferObject.nglGetBufferParameterivARB(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetBufferParameteriARB(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBVertexBufferObject.nglGetBufferParameterivARB(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetBufferPointervARB(int target, int pname, long params) {
        long __functionAddress = ARBVertexBufferObject.getInstance().GetBufferPointervARB;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferPointervARB(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        ARBVertexBufferObject.nglGetBufferPointervARB(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferPointervARB(int target, int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        ARBVertexBufferObject.nglGetBufferPointervARB(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferPointerARB(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        ARBVertexBufferObject.nglGetBufferPointervARB(target, pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }
}

