/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL44 {
    public static final int GL_MAX_VERTEX_ATTRIB_STRIDE = 33509;
    public static final int GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = 33313;
    public static final int GL_TEXTURE_BUFFER_BINDING = 35882;
    public static final int GL_MAP_PERSISTENT_BIT = 64;
    public static final int GL_MAP_COHERENT_BIT = 128;
    public static final int GL_DYNAMIC_STORAGE_BIT = 256;
    public static final int GL_CLIENT_STORAGE_BIT = 512;
    public static final int GL_BUFFER_IMMUTABLE_STORAGE = 33311;
    public static final int GL_BUFFER_STORAGE_FLAGS = 33312;
    public static final int GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = 16384;
    public static final int GL_CLEAR_TEXTURE = 37733;
    public static final int GL_LOCATION_COMPONENT = 37706;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = 37707;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = 37708;
    public static final int GL_QUERY_RESULT_NO_WAIT = 37268;
    public static final int GL_QUERY_BUFFER = 37266;
    public static final int GL_QUERY_BUFFER_BINDING = 37267;
    public static final int GL_QUERY_BUFFER_BARRIER_BIT = 32768;
    public static final int GL_MIRROR_CLAMP_TO_EDGE = 34627;
    public final long BufferStorage;
    public final long ClearTexSubImage;
    public final long ClearTexImage;
    public final long BindBuffersBase;
    public final long BindBuffersRange;
    public final long BindTextures;
    public final long BindSamplers;
    public final long BindImageTextures;
    public final long BindVertexBuffers;

    protected GL44() {
        throw new UnsupportedOperationException();
    }

    public GL44(FunctionProvider provider) {
        this.BufferStorage = provider.getFunctionAddress("glBufferStorage");
        this.ClearTexSubImage = provider.getFunctionAddress("glClearTexSubImage");
        this.ClearTexImage = provider.getFunctionAddress("glClearTexImage");
        this.BindBuffersBase = provider.getFunctionAddress("glBindBuffersBase");
        this.BindBuffersRange = provider.getFunctionAddress("glBindBuffersRange");
        this.BindTextures = provider.getFunctionAddress("glBindTextures");
        this.BindSamplers = provider.getFunctionAddress("glBindSamplers");
        this.BindImageTextures = provider.getFunctionAddress("glBindImageTextures");
        this.BindVertexBuffers = provider.getFunctionAddress("glBindVertexBuffers");
    }

    public static GL44 getInstance() {
        return GL44.getInstance(GL.getCapabilities());
    }

    public static GL44 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL44);
    }

    static GL44 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL44")) {
            return null;
        }
        GL44 funcs = new GL44(provider);
        boolean supported = Checks.checkFunctions(funcs.BufferStorage, funcs.ClearTexSubImage, funcs.ClearTexImage, funcs.BindBuffersBase, funcs.BindBuffersRange, funcs.BindTextures, funcs.BindSamplers, funcs.BindImageTextures, funcs.BindVertexBuffers);
        return GL.checkExtension("OpenGL44", funcs, supported);
    }

    public static void nglBufferStorage(int target, long size, long data, int flags) {
        long __functionAddress = GL44.getInstance().BufferStorage;
        JNI.callIPPIV(__functionAddress, target, size, data, flags);
    }

    public static void glBufferStorage(int target, long size, ByteBuffer data, int flags) {
        if (Checks.CHECKS && data != null) {
            Checks.checkBuffer((Buffer)data, size);
        }
        GL44.nglBufferStorage(target, size, MemoryUtil.memAddressSafe(data), flags);
    }

    public static void glBufferStorage(int target, long size, int flags) {
        GL44.nglBufferStorage(target, size, 0L, flags);
    }

    public static void glBufferStorage(int target, ByteBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining(), MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, ShortBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 1, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, IntBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, FloatBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 2, MemoryUtil.memAddress(data), flags);
    }

    public static void glBufferStorage(int target, DoubleBuffer data, int flags) {
        GL44.nglBufferStorage(target, data.remaining() << 3, MemoryUtil.memAddress(data), flags);
    }

    public static void nglClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long data) {
        long __functionAddress = GL44.getInstance().ClearTexSubImage;
        JNI.callIIIIIIIIIIPV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, data);
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer data) {
        GL44.nglClearTexSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearTexImage(int texture, int level, int format, int type, long data) {
        long __functionAddress = GL44.getInstance().ClearTexImage;
        JNI.callIIIIPV(__functionAddress, texture, level, format, type, data);
    }

    public static void glClearTexImage(int texture, int level, int format, int type, ByteBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, ShortBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, IntBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, FloatBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearTexImage(int texture, int level, int format, int type, DoubleBuffer data) {
        GL44.nglClearTexImage(texture, level, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglBindBuffersBase(int target, int first, int count, long buffers) {
        long __functionAddress = GL44.getInstance().BindBuffersBase;
        JNI.callIIIPV(__functionAddress, target, first, count, buffers);
    }

    public static void glBindBuffersBase(int target, int first, int count, ByteBuffer buffers) {
        if (Checks.CHECKS && buffers != null) {
            Checks.checkBuffer((Buffer)buffers, count << 2);
        }
        GL44.nglBindBuffersBase(target, first, count, MemoryUtil.memAddressSafe(buffers));
    }

    public static void glBindBuffersBase(int target, int first, IntBuffer buffers) {
        GL44.nglBindBuffersBase(target, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers));
    }

    public static void nglBindBuffersRange(int target, int first, int count, long buffers, long offsets, long sizes) {
        long __functionAddress = GL44.getInstance().BindBuffersRange;
        JNI.callIIIPPPV(__functionAddress, target, first, count, buffers, offsets, sizes);
    }

    public static void glBindBuffersRange(int target, int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer sizes) {
        if (Checks.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (sizes != null) {
                Checks.checkBuffer((Buffer)sizes, count << Pointer.POINTER_SHIFT);
            }
        }
        GL44.nglBindBuffersRange(target, first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void glBindBuffersRange(int target, int first, IntBuffer buffers, PointerBuffer offsets, PointerBuffer sizes) {
        if (Checks.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (sizes != null) {
                Checks.checkBuffer(sizes, buffers.remaining());
            }
        }
        GL44.nglBindBuffersRange(target, first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(sizes));
    }

    public static void nglBindTextures(int first, int count, long textures) {
        long __functionAddress = GL44.getInstance().BindTextures;
        JNI.callIIPV(__functionAddress, first, count, textures);
    }

    public static void glBindTextures(int first, int count, ByteBuffer textures) {
        if (Checks.CHECKS && textures != null) {
            Checks.checkBuffer((Buffer)textures, count << 2);
        }
        GL44.nglBindTextures(first, count, MemoryUtil.memAddressSafe(textures));
    }

    public static void glBindTextures(int first, IntBuffer textures) {
        GL44.nglBindTextures(first, textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindSamplers(int first, int count, long samplers) {
        long __functionAddress = GL44.getInstance().BindSamplers;
        JNI.callIIPV(__functionAddress, first, count, samplers);
    }

    public static void glBindSamplers(int first, int count, ByteBuffer samplers) {
        if (Checks.CHECKS && samplers != null) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        GL44.nglBindSamplers(first, count, MemoryUtil.memAddressSafe(samplers));
    }

    public static void glBindSamplers(int first, IntBuffer samplers) {
        GL44.nglBindSamplers(first, samplers == null ? 0 : samplers.remaining(), MemoryUtil.memAddressSafe(samplers));
    }

    public static void nglBindImageTextures(int first, int count, long textures) {
        long __functionAddress = GL44.getInstance().BindImageTextures;
        JNI.callIIPV(__functionAddress, first, count, textures);
    }

    public static void glBindImageTextures(int first, int count, ByteBuffer textures) {
        if (Checks.CHECKS && textures != null) {
            Checks.checkBuffer((Buffer)textures, count << 2);
        }
        GL44.nglBindImageTextures(first, count, MemoryUtil.memAddressSafe(textures));
    }

    public static void glBindImageTextures(int first, IntBuffer textures) {
        GL44.nglBindImageTextures(first, textures == null ? 0 : textures.remaining(), MemoryUtil.memAddressSafe(textures));
    }

    public static void nglBindVertexBuffers(int first, int count, long buffers, long offsets, long strides) {
        long __functionAddress = GL44.getInstance().BindVertexBuffers;
        JNI.callIIPPPV(__functionAddress, first, count, buffers, offsets, strides);
    }

    public static void glBindVertexBuffers(int first, int count, ByteBuffer buffers, ByteBuffer offsets, ByteBuffer strides) {
        if (Checks.CHECKS) {
            if (buffers != null) {
                Checks.checkBuffer((Buffer)buffers, count << 2);
            }
            if (offsets != null) {
                Checks.checkBuffer((Buffer)offsets, count << Pointer.POINTER_SHIFT);
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, count << 2);
            }
        }
        GL44.nglBindVertexBuffers(first, count, MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }

    public static void glBindVertexBuffers(int first, IntBuffer buffers, PointerBuffer offsets, IntBuffer strides) {
        if (Checks.CHECKS) {
            if (offsets != null) {
                Checks.checkBuffer(offsets, buffers.remaining());
            }
            if (strides != null) {
                Checks.checkBuffer((Buffer)strides, buffers.remaining());
            }
        }
        GL44.nglBindVertexBuffers(first, buffers == null ? 0 : buffers.remaining(), MemoryUtil.memAddressSafe(buffers), MemoryUtil.memAddressSafe(offsets), MemoryUtil.memAddressSafe(strides));
    }
}

