/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class NVCommandList {
    public static final int GL_TERMINATE_SEQUENCE_COMMAND_NV = 0;
    public static final int GL_NOP_COMMAND_NV = 1;
    public static final int GL_DRAW_ELEMENTS_COMMAND_NV = 2;
    public static final int GL_DRAW_ARRAYS_COMMAND_NV = 3;
    public static final int GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = 4;
    public static final int GL_DRAW_ARRAYS_STRIP_COMMAND_NV = 5;
    public static final int GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = 6;
    public static final int GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = 7;
    public static final int GL_ELEMENT_ADDRESS_COMMAND_NV = 8;
    public static final int GL_ATTRIBUTE_ADDRESS_COMMAND_NV = 9;
    public static final int GL_UNIFORM_ADDRESS_COMMAND_NV = 10;
    public static final int GL_BLEND_COLOR_COMMAND_NV = 11;
    public static final int GL_STENCIL_REF_COMMAND_NV = 12;
    public static final int GL_LINE_WIDTH_COMMAND_NV = 13;
    public static final int GL_POLYGON_OFFSET_COMMAND_NV = 14;
    public static final int GL_ALPHA_REF_COMMAND_NV = 15;
    public static final int GL_VIEWPORT_COMMAND_NV = 16;
    public static final int GL_SCISSOR_COMMAND_NV = 17;
    public static final int GL_FRONT_FACE_COMMAND_NV = 18;
    public final long CreateStatesNV;
    public final long DeleteStatesNV;
    public final long IsStateNV;
    public final long StateCaptureNV;
    public final long GetCommandHeaderNV;
    public final long GetStageIndexNV;
    public final long DrawCommandsNV;
    public final long DrawCommandsAddressNV;
    public final long DrawCommandsStatesNV;
    public final long DrawCommandsStatesAddressNV;
    public final long CreateCommandListsNV;
    public final long DeleteCommandListsNV;
    public final long IsCommandListNV;
    public final long ListDrawCommandsStatesClientNV;
    public final long CommandListSegmentsNV;
    public final long CompileCommandListNV;
    public final long CallCommandListNV;

    protected NVCommandList() {
        throw new UnsupportedOperationException();
    }

    public NVCommandList(FunctionProvider provider) {
        this.CreateStatesNV = provider.getFunctionAddress("glCreateStatesNV");
        this.DeleteStatesNV = provider.getFunctionAddress("glDeleteStatesNV");
        this.IsStateNV = provider.getFunctionAddress("glIsStateNV");
        this.StateCaptureNV = provider.getFunctionAddress("glStateCaptureNV");
        this.GetCommandHeaderNV = provider.getFunctionAddress("glGetCommandHeaderNV");
        this.GetStageIndexNV = provider.getFunctionAddress("glGetStageIndexNV");
        this.DrawCommandsNV = provider.getFunctionAddress("glDrawCommandsNV");
        this.DrawCommandsAddressNV = provider.getFunctionAddress("glDrawCommandsAddressNV");
        this.DrawCommandsStatesNV = provider.getFunctionAddress("glDrawCommandsStatesNV");
        this.DrawCommandsStatesAddressNV = provider.getFunctionAddress("glDrawCommandsStatesAddressNV");
        this.CreateCommandListsNV = provider.getFunctionAddress("glCreateCommandListsNV");
        this.DeleteCommandListsNV = provider.getFunctionAddress("glDeleteCommandListsNV");
        this.IsCommandListNV = provider.getFunctionAddress("glIsCommandListNV");
        this.ListDrawCommandsStatesClientNV = provider.getFunctionAddress("glListDrawCommandsStatesClientNV");
        this.CommandListSegmentsNV = provider.getFunctionAddress("glCommandListSegmentsNV");
        this.CompileCommandListNV = provider.getFunctionAddress("glCompileCommandListNV");
        this.CallCommandListNV = provider.getFunctionAddress("glCallCommandListNV");
    }

    public static NVCommandList getInstance() {
        return NVCommandList.getInstance(GL.getCapabilities());
    }

    public static NVCommandList getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVCommandList);
    }

    static NVCommandList create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_command_list")) {
            return null;
        }
        NVCommandList funcs = new NVCommandList(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateStatesNV, funcs.DeleteStatesNV, funcs.IsStateNV, funcs.StateCaptureNV, funcs.GetCommandHeaderNV, funcs.GetStageIndexNV, funcs.DrawCommandsNV, funcs.DrawCommandsAddressNV, funcs.DrawCommandsStatesNV, funcs.DrawCommandsStatesAddressNV, funcs.CreateCommandListsNV, funcs.DeleteCommandListsNV, funcs.IsCommandListNV, funcs.ListDrawCommandsStatesClientNV, funcs.CommandListSegmentsNV, funcs.CompileCommandListNV, funcs.CallCommandListNV);
        return GL.checkExtension("GL_NV_command_list", funcs, supported);
    }

    public static void nglCreateStatesNV(int n, long states) {
        long __functionAddress = NVCommandList.getInstance().CreateStatesNV;
        JNI.callIPV(__functionAddress, n, states);
    }

    public static void glCreateStatesNV(int n, ByteBuffer states) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)states, n << 2);
        }
        NVCommandList.nglCreateStatesNV(n, MemoryUtil.memAddress(states));
    }

    public static void glCreateStatesNV(IntBuffer states) {
        NVCommandList.nglCreateStatesNV(states.remaining(), MemoryUtil.memAddress(states));
    }

    public static int glCreateStatesNV() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int states = __buffer.intParam();
        NVCommandList.nglCreateStatesNV(1, __buffer.address(states));
        return __buffer.intValue(states);
    }

    public static void nglDeleteStatesNV(int n, long states) {
        long __functionAddress = NVCommandList.getInstance().DeleteStatesNV;
        JNI.callIPV(__functionAddress, n, states);
    }

    public static void glDeleteStatesNV(int n, ByteBuffer states) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)states, n << 2);
        }
        NVCommandList.nglDeleteStatesNV(n, MemoryUtil.memAddress(states));
    }

    public static void glDeleteStatesNV(IntBuffer states) {
        NVCommandList.nglDeleteStatesNV(states.remaining(), MemoryUtil.memAddress(states));
    }

    public static void glDeleteStatesNV(int state) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int states = __buffer.intParam(state);
        NVCommandList.nglDeleteStatesNV(1, __buffer.address(states));
    }

    public static boolean glIsStateNV(int state) {
        long __functionAddress = NVCommandList.getInstance().IsStateNV;
        return JNI.callIZ(__functionAddress, state);
    }

    public static void glStateCaptureNV(int state, int mode) {
        long __functionAddress = NVCommandList.getInstance().StateCaptureNV;
        JNI.callIIV(__functionAddress, state, mode);
    }

    public static int glGetCommandHeaderNV(int tokenID, int size) {
        long __functionAddress = NVCommandList.getInstance().GetCommandHeaderNV;
        return JNI.callIII(__functionAddress, tokenID, size);
    }

    public static short glGetStageIndexNV(int shadertype) {
        long __functionAddress = NVCommandList.getInstance().GetStageIndexNV;
        return JNI.callIS(__functionAddress, shadertype);
    }

    public static void nglDrawCommandsNV(int primitiveMode, int buffer, long indirects, long sizes, int count) {
        long __functionAddress = NVCommandList.getInstance().DrawCommandsNV;
        JNI.callIIPPIV(__functionAddress, primitiveMode, buffer, indirects, sizes, count);
    }

    public static void glDrawCommandsNV(int primitiveMode, int buffer, ByteBuffer indirects, ByteBuffer sizes, int count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirects, count << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)sizes, count << 2);
        }
        NVCommandList.nglDrawCommandsNV(primitiveMode, buffer, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), count);
    }

    public static void glDrawCommandsNV(int primitiveMode, int buffer, PointerBuffer indirects, IntBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, indirects.remaining());
        }
        NVCommandList.nglDrawCommandsNV(primitiveMode, buffer, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), indirects.remaining());
    }

    public static void nglDrawCommandsAddressNV(int primitiveMode, long indirects, long sizes, int count) {
        long __functionAddress = NVCommandList.getInstance().DrawCommandsAddressNV;
        JNI.callIPPIV(__functionAddress, primitiveMode, indirects, sizes, count);
    }

    public static void glDrawCommandsAddressNV(int primitiveMode, ByteBuffer indirects, ByteBuffer sizes, int count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirects, count << 3);
            Checks.checkBuffer((Buffer)sizes, count << 2);
        }
        NVCommandList.nglDrawCommandsAddressNV(primitiveMode, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), count);
    }

    public static void glDrawCommandsAddressNV(int primitiveMode, LongBuffer indirects, IntBuffer sizes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, indirects.remaining());
        }
        NVCommandList.nglDrawCommandsAddressNV(primitiveMode, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), indirects.remaining());
    }

    public static void nglDrawCommandsStatesNV(int buffer, long indirects, long sizes, long states, long fbos, int count) {
        long __functionAddress = NVCommandList.getInstance().DrawCommandsStatesNV;
        JNI.callIPPPPIV(__functionAddress, buffer, indirects, sizes, states, fbos, count);
    }

    public static void glDrawCommandsStatesNV(int buffer, ByteBuffer indirects, ByteBuffer sizes, ByteBuffer states, ByteBuffer fbos, int count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirects, count << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)sizes, count << 2);
            Checks.checkBuffer((Buffer)states, count << 2);
            Checks.checkBuffer((Buffer)fbos, count << 2);
        }
        NVCommandList.nglDrawCommandsStatesNV(buffer, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), MemoryUtil.memAddress(states), MemoryUtil.memAddress(fbos), count);
    }

    public static void glDrawCommandsStatesNV(int buffer, PointerBuffer indirects, IntBuffer sizes, IntBuffer states, IntBuffer fbos) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, indirects.remaining());
            Checks.checkBuffer((Buffer)states, indirects.remaining());
            Checks.checkBuffer((Buffer)fbos, indirects.remaining());
        }
        NVCommandList.nglDrawCommandsStatesNV(buffer, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), MemoryUtil.memAddress(states), MemoryUtil.memAddress(fbos), indirects.remaining());
    }

    public static void nglDrawCommandsStatesAddressNV(long indirects, long sizes, long states, long fbos, int count) {
        long __functionAddress = NVCommandList.getInstance().DrawCommandsStatesAddressNV;
        JNI.callPPPPIV(__functionAddress, indirects, sizes, states, fbos, count);
    }

    public static void glDrawCommandsStatesAddressNV(ByteBuffer indirects, ByteBuffer sizes, ByteBuffer states, ByteBuffer fbos, int count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirects, count << 3);
            Checks.checkBuffer((Buffer)sizes, count << 2);
            Checks.checkBuffer((Buffer)states, count << 2);
            Checks.checkBuffer((Buffer)fbos, count << 2);
        }
        NVCommandList.nglDrawCommandsStatesAddressNV(MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), MemoryUtil.memAddress(states), MemoryUtil.memAddress(fbos), count);
    }

    public static void glDrawCommandsStatesAddressNV(LongBuffer indirects, IntBuffer sizes, IntBuffer states, IntBuffer fbos) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)sizes, indirects.remaining());
            Checks.checkBuffer((Buffer)states, indirects.remaining());
            Checks.checkBuffer((Buffer)fbos, indirects.remaining());
        }
        NVCommandList.nglDrawCommandsStatesAddressNV(MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), MemoryUtil.memAddress(states), MemoryUtil.memAddress(fbos), indirects.remaining());
    }

    public static void nglCreateCommandListsNV(int n, long lists) {
        long __functionAddress = NVCommandList.getInstance().CreateCommandListsNV;
        JNI.callIPV(__functionAddress, n, lists);
    }

    public static void glCreateCommandListsNV(int n, ByteBuffer lists) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)lists, n << 2);
        }
        NVCommandList.nglCreateCommandListsNV(n, MemoryUtil.memAddress(lists));
    }

    public static void glCreateCommandListsNV(IntBuffer lists) {
        NVCommandList.nglCreateCommandListsNV(lists.remaining(), MemoryUtil.memAddress(lists));
    }

    public static int glCreateCommandListsNV() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int lists = __buffer.intParam();
        NVCommandList.nglCreateCommandListsNV(1, __buffer.address(lists));
        return __buffer.intValue(lists);
    }

    public static void nglDeleteCommandListsNV(int n, long lists) {
        long __functionAddress = NVCommandList.getInstance().DeleteCommandListsNV;
        JNI.callIPV(__functionAddress, n, lists);
    }

    public static void glDeleteCommandListsNV(int n, ByteBuffer lists) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)lists, n << 2);
        }
        NVCommandList.nglDeleteCommandListsNV(n, MemoryUtil.memAddress(lists));
    }

    public static void glDeleteCommandListsNV(IntBuffer lists) {
        NVCommandList.nglDeleteCommandListsNV(lists.remaining(), MemoryUtil.memAddress(lists));
    }

    public static void glDeleteCommandListsNV(int list) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int lists = __buffer.intParam(list);
        NVCommandList.nglDeleteCommandListsNV(1, __buffer.address(lists));
    }

    public static boolean glIsCommandListNV(int list) {
        long __functionAddress = NVCommandList.getInstance().IsCommandListNV;
        return JNI.callIZ(__functionAddress, list);
    }

    public static void nglListDrawCommandsStatesClientNV(int list, int segment, long indirects, long sizes, long states, long fbos, int count) {
        long __functionAddress = NVCommandList.getInstance().ListDrawCommandsStatesClientNV;
        JNI.callIIPPPPIV(__functionAddress, list, segment, indirects, sizes, states, fbos, count);
    }

    public static void glListDrawCommandsStatesClientNV(int list, int segment, ByteBuffer indirects, ByteBuffer sizes, ByteBuffer states, ByteBuffer fbos, int count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirects, count << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)sizes, count << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)states, count << 2);
            Checks.checkBuffer((Buffer)fbos, count << 2);
        }
        NVCommandList.nglListDrawCommandsStatesClientNV(list, segment, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), MemoryUtil.memAddress(states), MemoryUtil.memAddress(fbos), count);
    }

    public static void glListDrawCommandsStatesClientNV(int list, int segment, PointerBuffer indirects, PointerBuffer sizes, IntBuffer states, IntBuffer fbos) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(sizes, indirects.remaining());
            Checks.checkBuffer((Buffer)states, indirects.remaining());
            Checks.checkBuffer((Buffer)fbos, indirects.remaining());
        }
        NVCommandList.nglListDrawCommandsStatesClientNV(list, segment, MemoryUtil.memAddress(indirects), MemoryUtil.memAddress(sizes), MemoryUtil.memAddress(states), MemoryUtil.memAddress(fbos), indirects.remaining());
    }

    public static void glCommandListSegmentsNV(int list, int segments) {
        long __functionAddress = NVCommandList.getInstance().CommandListSegmentsNV;
        JNI.callIIV(__functionAddress, list, segments);
    }

    public static void glCompileCommandListNV(int list) {
        long __functionAddress = NVCommandList.getInstance().CompileCommandListNV;
        JNI.callIV(__functionAddress, list);
    }

    public static void glCallCommandListNV(int list) {
        long __functionAddress = NVCommandList.getInstance().CallCommandListNV;
        JNI.callIV(__functionAddress, list);
    }
}

