/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class NVXConditionalRender {
    public final long BeginConditionalRenderNVX;
    public final long EndConditionalRenderNVX;

    protected NVXConditionalRender() {
        throw new UnsupportedOperationException();
    }

    public NVXConditionalRender(FunctionProvider provider) {
        this.BeginConditionalRenderNVX = provider.getFunctionAddress("glBeginConditionalRenderNVX");
        this.EndConditionalRenderNVX = provider.getFunctionAddress("glEndConditionalRenderNVX");
    }

    public static NVXConditionalRender getInstance() {
        return NVXConditionalRender.getInstance(GL.getCapabilities());
    }

    public static NVXConditionalRender getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVXConditionalRender);
    }

    static NVXConditionalRender create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NVX_conditional_render")) {
            return null;
        }
        NVXConditionalRender funcs = new NVXConditionalRender(provider);
        boolean supported = Checks.checkFunctions(funcs.BeginConditionalRenderNVX, funcs.EndConditionalRenderNVX);
        return GL.checkExtension("GL_NVX_conditional_render", funcs, supported);
    }

    public static void glBeginConditionalRenderNVX(int id) {
        long __functionAddress = NVXConditionalRender.getInstance().BeginConditionalRenderNVX;
        JNI.callIV(__functionAddress, id);
    }

    public static void glEndConditionalRenderNVX() {
        long __functionAddress = NVXConditionalRender.getInstance().EndConditionalRenderNVX;
        JNI.callV(__functionAddress);
    }
}

