/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class WGLNVVertexArrayRange {
    public final long AllocateMemoryNV;
    public final long FreeMemoryNV;

    protected WGLNVVertexArrayRange() {
        throw new UnsupportedOperationException();
    }

    public WGLNVVertexArrayRange(FunctionProvider provider) {
        this.AllocateMemoryNV = provider.getFunctionAddress("wglAllocateMemoryNV");
        this.FreeMemoryNV = provider.getFunctionAddress("wglFreeMemoryNV");
    }

    public static WGLNVVertexArrayRange getInstance() {
        return WGLNVVertexArrayRange.getInstance(GL.getCapabilities());
    }

    public static WGLNVVertexArrayRange getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLNVVertexArrayRange);
    }

    static WGLNVVertexArrayRange create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_NV_vertex_array_range")) {
            return null;
        }
        WGLNVVertexArrayRange funcs = new WGLNVVertexArrayRange(provider);
        boolean supported = Checks.checkFunctions(funcs.AllocateMemoryNV, funcs.FreeMemoryNV);
        return GL.checkExtension("WGL_NV_vertex_array_range", funcs, supported);
    }

    public static long nwglAllocateMemoryNV(int size, float readfreq, float writefreq, float priority) {
        long __functionAddress = WGLNVVertexArrayRange.getInstance().AllocateMemoryNV;
        return JNI.callIFFFP(__functionAddress, size, readfreq, writefreq, priority);
    }

    public static ByteBuffer wglAllocateMemoryNV(int size, float readfreq, float writefreq, float priority) {
        long __result = WGLNVVertexArrayRange.nwglAllocateMemoryNV(size, readfreq, writefreq, priority);
        return MemoryUtil.memByteBuffer(__result, size);
    }

    public static void nwglFreeMemoryNV(long pointer) {
        long __functionAddress = WGLNVVertexArrayRange.getInstance().FreeMemoryNV;
        JNI.callPV(__functionAddress, pointer);
    }

    public static void wglFreeMemoryNV(ByteBuffer pointer) {
        WGLNVVertexArrayRange.nwglFreeMemoryNV(MemoryUtil.memAddress(pointer));
    }
}

