/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.OpenGLESException;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;

final class GLESChecks {
    private GLESChecks() {
    }

    static void ensureBufferObject(int binding, boolean enabled) {
        if (Checks.DEBUG && GLES20.glGetInteger(binding) != 0 ^ enabled) {
            throw new OpenGLESException("Cannot use %s when %s buffer object is %s", enabled ? "offsets" : "buffers", GLESChecks.getBufferObjectBindingString(binding), enabled ? "disabled" : "enabled");
        }
    }

    private static String getBufferObjectBindingString(int binding) {
        switch (binding) {
            case 34964: {
                return "array";
            }
            case 34965: {
                return "element array";
            }
            case 35053: {
                return "pixel pack";
            }
            case 35055: {
                return "pixel unpack";
            }
            case 36675: {
                return "draw indirect";
            }
            case 37103: {
                return "dispatch indirect";
            }
        }
        throw new IllegalArgumentException(APIUtil.apiUnknownToken("Unsupported buffer binding", binding));
    }

    static int typeToByteShift(int type) {
        switch (type) {
            case 5120: 
            case 5121: {
                return 0;
            }
            case 5122: 
            case 5123: 
            case 5131: {
                return 1;
            }
            case 5124: 
            case 5125: 
            case 5126: 
            case 5132: {
                return 2;
            }
        }
        throw new IllegalArgumentException(APIUtil.apiUnknownToken("Unsupported OpenGL type", type));
    }
}

