/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class INTELPerformanceQuery {
    public static final int GL_PERFQUERY_SINGLE_CONTEXT_INTEL = 0;
    public static final int GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = 1;
    public static final int GL_PERFQUERY_WAIT_INTEL = 33787;
    public static final int GL_PERFQUERY_FLUSH_INTEL = 33786;
    public static final int GL_PERFQUERY_DONOT_FLUSH_INTEL = 33785;
    public static final int GL_PERFQUERY_COUNTER_EVENT_INTEL = 38128;
    public static final int GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = 38129;
    public static final int GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = 38130;
    public static final int GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = 38131;
    public static final int GL_PERFQUERY_COUNTER_RAW_INTEL = 38132;
    public static final int GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = 38133;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = 38136;
    public static final int GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = 38137;
    public static final int GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = 38138;
    public static final int GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = 38139;
    public static final int GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = 38140;
    public static final int GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = 38141;
    public static final int GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = 38142;
    public static final int GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = 38143;
    public static final int GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = 38144;
    public final long BeginPerfQueryINTEL;
    public final long CreatePerfQueryINTEL;
    public final long DeletePerfQueryINTEL;
    public final long EndPerfQueryINTEL;
    public final long GetFirstPerfQueryIdINTEL;
    public final long GetNextPerfQueryIdINTEL;
    public final long GetPerfCounterInfoINTEL;
    public final long GetPerfQueryDataINTEL;
    public final long GetPerfQueryIdByNameINTEL;
    public final long GetPerfQueryInfoINTEL;

    protected INTELPerformanceQuery() {
        throw new UnsupportedOperationException();
    }

    public INTELPerformanceQuery(FunctionProvider provider) {
        this.BeginPerfQueryINTEL = provider.getFunctionAddress("glBeginPerfQueryINTEL");
        this.CreatePerfQueryINTEL = provider.getFunctionAddress("glCreatePerfQueryINTEL");
        this.DeletePerfQueryINTEL = provider.getFunctionAddress("glDeletePerfQueryINTEL");
        this.EndPerfQueryINTEL = provider.getFunctionAddress("glEndPerfQueryINTEL");
        this.GetFirstPerfQueryIdINTEL = provider.getFunctionAddress("glGetFirstPerfQueryIdINTEL");
        this.GetNextPerfQueryIdINTEL = provider.getFunctionAddress("glGetNextPerfQueryIdINTEL");
        this.GetPerfCounterInfoINTEL = provider.getFunctionAddress("glGetPerfCounterInfoINTEL");
        this.GetPerfQueryDataINTEL = provider.getFunctionAddress("glGetPerfQueryDataINTEL");
        this.GetPerfQueryIdByNameINTEL = provider.getFunctionAddress("glGetPerfQueryIdByNameINTEL");
        this.GetPerfQueryInfoINTEL = provider.getFunctionAddress("glGetPerfQueryInfoINTEL");
    }

    public static INTELPerformanceQuery getInstance() {
        return INTELPerformanceQuery.getInstance(GLES.getCapabilities());
    }

    public static INTELPerformanceQuery getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__INTELPerformanceQuery);
    }

    static INTELPerformanceQuery create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_INTEL_performance_query")) {
            return null;
        }
        INTELPerformanceQuery funcs = new INTELPerformanceQuery(provider);
        boolean supported = Checks.checkFunctions(funcs.BeginPerfQueryINTEL, funcs.CreatePerfQueryINTEL, funcs.DeletePerfQueryINTEL, funcs.EndPerfQueryINTEL, funcs.GetFirstPerfQueryIdINTEL, funcs.GetNextPerfQueryIdINTEL, funcs.GetPerfCounterInfoINTEL, funcs.GetPerfQueryDataINTEL, funcs.GetPerfQueryIdByNameINTEL, funcs.GetPerfQueryInfoINTEL);
        return GLES.checkExtension("GL_INTEL_performance_query", funcs, supported);
    }

    public static void glBeginPerfQueryINTEL(int queryHandle) {
        long __functionAddress = INTELPerformanceQuery.getInstance().BeginPerfQueryINTEL;
        JNI.callIV(__functionAddress, queryHandle);
    }

    public static void nglCreatePerfQueryINTEL(int queryId, long queryHandle) {
        long __functionAddress = INTELPerformanceQuery.getInstance().CreatePerfQueryINTEL;
        JNI.callIPV(__functionAddress, queryId, queryHandle);
    }

    public static void glCreatePerfQueryINTEL(int queryId, ByteBuffer queryHandle) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryHandle, 4);
        }
        INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress(queryHandle));
    }

    public static void glCreatePerfQueryINTEL(int queryId, IntBuffer queryHandle) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryHandle, 1);
        }
        INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, MemoryUtil.memAddress(queryHandle));
    }

    public static int glCreatePerfQueryINTEL(int queryId) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int queryHandle = __buffer.intParam();
        INTELPerformanceQuery.nglCreatePerfQueryINTEL(queryId, __buffer.address(queryHandle));
        return __buffer.intValue(queryHandle);
    }

    public static void glDeletePerfQueryINTEL(int queryHandle) {
        long __functionAddress = INTELPerformanceQuery.getInstance().DeletePerfQueryINTEL;
        JNI.callIV(__functionAddress, queryHandle);
    }

    public static void glEndPerfQueryINTEL(int queryHandle) {
        long __functionAddress = INTELPerformanceQuery.getInstance().EndPerfQueryINTEL;
        JNI.callIV(__functionAddress, queryHandle);
    }

    public static void nglGetFirstPerfQueryIdINTEL(long queryId) {
        long __functionAddress = INTELPerformanceQuery.getInstance().GetFirstPerfQueryIdINTEL;
        JNI.callPV(__functionAddress, queryId);
    }

    public static void glGetFirstPerfQueryIdINTEL(ByteBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, 4);
        }
        INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress(queryId));
    }

    public static void glGetFirstPerfQueryIdINTEL(IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, 1);
        }
        INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(MemoryUtil.memAddress(queryId));
    }

    public static int glGetFirstPerfQueryIdINTEL() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int queryId = __buffer.intParam();
        INTELPerformanceQuery.nglGetFirstPerfQueryIdINTEL(__buffer.address(queryId));
        return __buffer.intValue(queryId);
    }

    public static void nglGetNextPerfQueryIdINTEL(int queryId, long nextQueryId) {
        long __functionAddress = INTELPerformanceQuery.getInstance().GetNextPerfQueryIdINTEL;
        JNI.callIPV(__functionAddress, queryId, nextQueryId);
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, ByteBuffer nextQueryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)nextQueryId, 4);
        }
        INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress(nextQueryId));
    }

    public static void glGetNextPerfQueryIdINTEL(int queryId, IntBuffer nextQueryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)nextQueryId, 1);
        }
        INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, MemoryUtil.memAddress(nextQueryId));
    }

    public static int glGetNextPerfQueryIdINTEL(int queryId) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nextQueryId = __buffer.intParam();
        INTELPerformanceQuery.nglGetNextPerfQueryIdINTEL(queryId, __buffer.address(nextQueryId));
        return __buffer.intValue(nextQueryId);
    }

    public static void nglGetPerfCounterInfoINTEL(int queryId, int counterId, int counterNameLength, long counterName, int counterDescLength, long counterDesc, long counterOffset, long counterDataSize, long counterTypeEnum, long counterDataTypeEnum, long rawCounterMaxValue) {
        long __functionAddress = INTELPerformanceQuery.getInstance().GetPerfCounterInfoINTEL;
        JNI.callIIIPIPPPPPPV(__functionAddress, queryId, counterId, counterNameLength, counterName, counterDescLength, counterDesc, counterOffset, counterDataSize, counterTypeEnum, counterDataTypeEnum, rawCounterMaxValue);
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, int counterNameLength, ByteBuffer counterName, int counterDescLength, ByteBuffer counterDesc, ByteBuffer counterOffset, ByteBuffer counterDataSize, ByteBuffer counterTypeEnum, ByteBuffer counterDataTypeEnum, ByteBuffer rawCounterMaxValue) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)counterName, counterNameLength);
            Checks.checkBuffer((Buffer)counterDesc, counterDescLength);
            Checks.checkBuffer((Buffer)counterOffset, 4);
            Checks.checkBuffer((Buffer)counterDataSize, 4);
            Checks.checkBuffer((Buffer)counterTypeEnum, 4);
            Checks.checkBuffer((Buffer)counterDataTypeEnum, 4);
            Checks.checkBuffer((Buffer)rawCounterMaxValue, 8);
        }
        INTELPerformanceQuery.nglGetPerfCounterInfoINTEL(queryId, counterId, counterNameLength, MemoryUtil.memAddress(counterName), counterDescLength, MemoryUtil.memAddress(counterDesc), MemoryUtil.memAddress(counterOffset), MemoryUtil.memAddress(counterDataSize), MemoryUtil.memAddress(counterTypeEnum), MemoryUtil.memAddress(counterDataTypeEnum), MemoryUtil.memAddress(rawCounterMaxValue));
    }

    public static void glGetPerfCounterInfoINTEL(int queryId, int counterId, ByteBuffer counterName, ByteBuffer counterDesc, IntBuffer counterOffset, IntBuffer counterDataSize, IntBuffer counterTypeEnum, IntBuffer counterDataTypeEnum, LongBuffer rawCounterMaxValue) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)counterOffset, 1);
            Checks.checkBuffer((Buffer)counterDataSize, 1);
            Checks.checkBuffer((Buffer)counterTypeEnum, 1);
            Checks.checkBuffer((Buffer)counterDataTypeEnum, 1);
            Checks.checkBuffer((Buffer)rawCounterMaxValue, 1);
        }
        INTELPerformanceQuery.nglGetPerfCounterInfoINTEL(queryId, counterId, counterName.remaining(), MemoryUtil.memAddress(counterName), counterDesc.remaining(), MemoryUtil.memAddress(counterDesc), MemoryUtil.memAddress(counterOffset), MemoryUtil.memAddress(counterDataSize), MemoryUtil.memAddress(counterTypeEnum), MemoryUtil.memAddress(counterDataTypeEnum), MemoryUtil.memAddress(rawCounterMaxValue));
    }

    public static void nglGetPerfQueryDataINTEL(int queryHandle, int flags, int dataSize, long data, long bytesWritten) {
        long __functionAddress = INTELPerformanceQuery.getInstance().GetPerfQueryDataINTEL;
        JNI.callIIIPPV(__functionAddress, queryHandle, flags, dataSize, data, bytesWritten);
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, int dataSize, ByteBuffer data, ByteBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, dataSize);
            Checks.checkBuffer((Buffer)bytesWritten, 4);
        }
        INTELPerformanceQuery.nglGetPerfQueryDataINTEL(queryHandle, flags, dataSize, MemoryUtil.memAddress(data), MemoryUtil.memAddress(bytesWritten));
    }

    public static void glGetPerfQueryDataINTEL(int queryHandle, int flags, ByteBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)bytesWritten, 1);
        }
        INTELPerformanceQuery.nglGetPerfQueryDataINTEL(queryHandle, flags, data.remaining(), MemoryUtil.memAddress(data), MemoryUtil.memAddress(bytesWritten));
    }

    public static void nglGetPerfQueryIdByNameINTEL(long queryName, long queryId) {
        long __functionAddress = INTELPerformanceQuery.getInstance().GetPerfQueryIdByNameINTEL;
        JNI.callPPV(__functionAddress, queryName, queryId);
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, ByteBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkNT1(queryName);
            Checks.checkBuffer((Buffer)queryId, 4);
        }
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress(queryName), MemoryUtil.memAddress(queryId));
    }

    public static void glGetPerfQueryIdByNameINTEL(ByteBuffer queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, 1);
        }
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(MemoryUtil.memAddress(queryName), MemoryUtil.memAddress(queryId));
    }

    public static void glGetPerfQueryIdByNameINTEL(CharSequence queryName, IntBuffer queryId) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryId, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int queryNameEncoded = __buffer.stringParamASCII(queryName, true);
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(__buffer.address(queryNameEncoded), MemoryUtil.memAddress(queryId));
    }

    public static int glGetPerfQueryIdByNameINTEL(CharSequence queryName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int queryNameEncoded = __buffer.stringParamASCII(queryName, true);
        int queryId = __buffer.intParam();
        INTELPerformanceQuery.nglGetPerfQueryIdByNameINTEL(__buffer.address(queryNameEncoded), __buffer.address(queryId));
        return __buffer.intValue(queryId);
    }

    public static void nglGetPerfQueryInfoINTEL(int queryId, int queryNameLength, long queryName, long dataSize, long noCounters, long noInstances, long capsMask) {
        long __functionAddress = INTELPerformanceQuery.getInstance().GetPerfQueryInfoINTEL;
        JNI.callIIPPPPPV(__functionAddress, queryId, queryNameLength, queryName, dataSize, noCounters, noInstances, capsMask);
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, int queryNameLength, ByteBuffer queryName, ByteBuffer dataSize, ByteBuffer noCounters, ByteBuffer noInstances, ByteBuffer capsMask) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)queryName, queryNameLength);
            Checks.checkBuffer((Buffer)dataSize, 4);
            Checks.checkBuffer((Buffer)noCounters, 4);
            Checks.checkBuffer((Buffer)noInstances, 4);
            Checks.checkBuffer((Buffer)capsMask, 4);
        }
        INTELPerformanceQuery.nglGetPerfQueryInfoINTEL(queryId, queryNameLength, MemoryUtil.memAddress(queryName), MemoryUtil.memAddress(dataSize), MemoryUtil.memAddress(noCounters), MemoryUtil.memAddress(noInstances), MemoryUtil.memAddress(capsMask));
    }

    public static void glGetPerfQueryInfoINTEL(int queryId, ByteBuffer queryName, IntBuffer dataSize, IntBuffer noCounters, IntBuffer noInstances, IntBuffer capsMask) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)dataSize, 1);
            Checks.checkBuffer((Buffer)noCounters, 1);
            Checks.checkBuffer((Buffer)noInstances, 1);
            Checks.checkBuffer((Buffer)capsMask, 1);
        }
        INTELPerformanceQuery.nglGetPerfQueryInfoINTEL(queryId, queryName.remaining(), MemoryUtil.memAddress(queryName), MemoryUtil.memAddress(dataSize), MemoryUtil.memAddress(noCounters), MemoryUtil.memAddress(noInstances), MemoryUtil.memAddress(capsMask));
    }
}

