/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLDebugMessageKHRCallback;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class KHRDebug {
    public static final int GL_DEBUG_OUTPUT_KHR = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT_KHR = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_KHR = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH_KHR = 33389;
    public static final int GL_MAX_LABEL_LENGTH_KHR = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION_KHR = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM_KHR = 33349;
    public static final int GL_DEBUG_SOURCE_API_KHR = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY_KHR = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION_KHR = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER_KHR = 33355;
    public static final int GL_DEBUG_TYPE_ERROR_KHR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY_KHR = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE_KHR = 33360;
    public static final int GL_DEBUG_TYPE_OTHER_KHR = 33361;
    public static final int GL_DEBUG_TYPE_MARKER_KHR = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP_KHR = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP_KHR = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH_KHR = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_KHR = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_KHR = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION_KHR = 33387;
    public static final int GL_STACK_UNDERFLOW_KHR = 1284;
    public static final int GL_STACK_OVERFLOW_KHR = 1283;
    public static final int GL_BUFFER_KHR = 33504;
    public static final int GL_SHADER_KHR = 33505;
    public static final int GL_PROGRAM_KHR = 33506;
    public static final int GL_QUERY_KHR = 33507;
    public static final int GL_PROGRAM_PIPELINE_KHR = 33508;
    public static final int GL_SAMPLER_KHR = 33510;
    public final long DebugMessageControlKHR;
    public final long DebugMessageInsertKHR;
    public final long DebugMessageCallbackKHR;
    public final long GetDebugMessageLogKHR;
    public final long GetPointervKHR;
    public final long PushDebugGroupKHR;
    public final long PopDebugGroupKHR;
    public final long ObjectLabelKHR;
    public final long GetObjectLabelKHR;
    public final long ObjectPtrLabelKHR;
    public final long GetObjectPtrLabelKHR;

    protected KHRDebug() {
        throw new UnsupportedOperationException();
    }

    public KHRDebug(FunctionProvider provider) {
        this.DebugMessageControlKHR = provider.getFunctionAddress("glDebugMessageControlKHR");
        this.DebugMessageInsertKHR = provider.getFunctionAddress("glDebugMessageInsertKHR");
        this.DebugMessageCallbackKHR = provider.getFunctionAddress("glDebugMessageCallbackKHR");
        this.GetDebugMessageLogKHR = provider.getFunctionAddress("glGetDebugMessageLogKHR");
        this.GetPointervKHR = provider.getFunctionAddress("glGetPointervKHR");
        this.PushDebugGroupKHR = provider.getFunctionAddress("glPushDebugGroupKHR");
        this.PopDebugGroupKHR = provider.getFunctionAddress("glPopDebugGroupKHR");
        this.ObjectLabelKHR = provider.getFunctionAddress("glObjectLabelKHR");
        this.GetObjectLabelKHR = provider.getFunctionAddress("glGetObjectLabelKHR");
        this.ObjectPtrLabelKHR = provider.getFunctionAddress("glObjectPtrLabelKHR");
        this.GetObjectPtrLabelKHR = provider.getFunctionAddress("glGetObjectPtrLabelKHR");
    }

    public static KHRDebug getInstance() {
        return KHRDebug.getInstance(GLES.getCapabilities());
    }

    public static KHRDebug getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRDebug);
    }

    static KHRDebug create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_KHR_debug")) {
            return null;
        }
        KHRDebug funcs = new KHRDebug(provider);
        boolean supported = Checks.checkFunctions(funcs.DebugMessageControlKHR, funcs.DebugMessageInsertKHR, funcs.DebugMessageCallbackKHR, funcs.GetDebugMessageLogKHR, funcs.GetPointervKHR, funcs.PushDebugGroupKHR, funcs.PopDebugGroupKHR, funcs.ObjectLabelKHR, funcs.GetObjectLabelKHR, funcs.ObjectPtrLabelKHR, funcs.GetObjectPtrLabelKHR);
        return GLES.checkExtension("GL_KHR_debug", funcs, supported);
    }

    public static void nglDebugMessageControlKHR(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageControlKHR;
        JNI.callIIIIPZV(__functionAddress, source, type, severity, count, ids, enabled);
    }

    public static void glDebugMessageControlKHR(int source, int type, int severity, int count, ByteBuffer ids, boolean enabled) {
        if (Checks.CHECKS && ids != null) {
            Checks.checkBuffer((Buffer)ids, count << 2);
        }
        KHRDebug.nglDebugMessageControlKHR(source, type, severity, count, MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageControlKHR(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        KHRDebug.nglDebugMessageControlKHR(source, type, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageControlKHR(int source, int type, int severity, int id, boolean enabled) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        KHRDebug.nglDebugMessageControlKHR(source, type, severity, 1, __buffer.address(ids), enabled);
    }

    public static void nglDebugMessageInsertKHR(int source, int type, int id, int severity, int length, long message) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageInsertKHR;
        JNI.callIIIIIPV(__functionAddress, source, type, id, severity, length, message);
    }

    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, int length, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, length, MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, ByteBuffer message) {
        KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsertKHR(int source, int type, int id, int severity, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        KHRDebug.nglDebugMessageInsertKHR(source, type, id, severity, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glDebugMessageCallbackKHR(GLDebugMessageKHRCallback callback, long userParam) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageCallbackKHR;
        JNI.callPPV(__functionAddress, callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLogKHR(int count, int bufsize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = KHRDebug.getInstance().GetDebugMessageLogKHR;
        return JNI.callIIPPPPPPI(__functionAddress, count, bufsize, sources, types, ids, severities, lengths, messageLog);
    }

    public static int glGetDebugMessageLogKHR(int count, int bufsize, ByteBuffer sources, ByteBuffer types, ByteBuffer ids, ByteBuffer severities, ByteBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufsize);
            }
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count << 2);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return KHRDebug.nglGetDebugMessageLogKHR(count, bufsize, MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLogKHR(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return KHRDebug.nglGetDebugMessageLogKHR(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void nglGetPointervKHR(int pname, long params) {
        long __functionAddress = KHRDebug.getInstance().GetPointervKHR;
        JNI.callIPV(__functionAddress, pname, params);
    }

    public static void glGetPointervKHR(int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1 << Pointer.POINTER_SHIFT);
        }
        KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress(params));
    }

    public static void glGetPointervKHR(int pname, PointerBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(params, 1);
        }
        KHRDebug.nglGetPointervKHR(pname, MemoryUtil.memAddress(params));
    }

    public static long glGetPointerKHR(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.pointerParam();
        KHRDebug.nglGetPointervKHR(pname, __buffer.address(params));
        return __buffer.pointerValue(params);
    }

    public static void nglPushDebugGroupKHR(int source, int id, int length, long message) {
        long __functionAddress = KHRDebug.getInstance().PushDebugGroupKHR;
        JNI.callIIIPV(__functionAddress, source, id, length, message);
    }

    public static void glPushDebugGroupKHR(int source, int id, int length, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        KHRDebug.nglPushDebugGroupKHR(source, id, length, MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroupKHR(int source, int id, ByteBuffer message) {
        KHRDebug.nglPushDebugGroupKHR(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroupKHR(int source, int id, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        KHRDebug.nglPushDebugGroupKHR(source, id, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glPopDebugGroupKHR() {
        long __functionAddress = KHRDebug.getInstance().PopDebugGroupKHR;
        JNI.callV(__functionAddress);
    }

    public static void nglObjectLabelKHR(int identifier, int name, int length, long label) {
        long __functionAddress = KHRDebug.getInstance().ObjectLabelKHR;
        JNI.callIIIPV(__functionAddress, identifier, name, length, label);
    }

    public static void glObjectLabelKHR(int identifier, int name, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        KHRDebug.nglObjectLabelKHR(identifier, name, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectLabelKHR(int identifier, int name, ByteBuffer label) {
        KHRDebug.nglObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectLabelKHR(int identifier, int name, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        KHRDebug.nglObjectLabelKHR(identifier, name, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectLabelKHR(int identifier, int name, int bufSize, long length, long label) {
        long __functionAddress = KHRDebug.getInstance().GetObjectLabelKHR;
        JNI.callIIIPPV(__functionAddress, identifier, name, bufSize, length, label);
    }

    public static void glGetObjectLabelKHR(int identifier, int name, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectLabelKHR(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectLabelKHR(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectLabelKHR(int identifier, int name, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static String glGetObjectLabelKHR(int identifier, int name) {
        int bufSize = GLES20.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectLabelKHR(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static void nglObjectPtrLabelKHR(long ptr, int length, long label) {
        long __functionAddress = KHRDebug.getInstance().ObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        JNI.callPIPV(__functionAddress, ptr, length, label);
    }

    public static void glObjectPtrLabelKHR(long ptr, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        KHRDebug.nglObjectPtrLabelKHR(ptr, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabelKHR(long ptr, ByteBuffer label) {
        KHRDebug.nglObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabelKHR(long ptr, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        KHRDebug.nglObjectPtrLabelKHR(ptr, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectPtrLabelKHR(long ptr, int bufSize, long length, long label) {
        long __functionAddress = KHRDebug.getInstance().GetObjectPtrLabelKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        JNI.callPIPPV(__functionAddress, ptr, bufSize, length, label);
    }

    public static void glGetObjectPtrLabelKHR(long ptr, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabelKHR(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectPtrLabelKHR(long ptr, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static String glGetObjectPtrLabelKHR(long ptr) {
        int bufSize = GLES20.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectPtrLabelKHR(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }
}

