/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRRobustness {
    public static final int GL_GUILTY_CONTEXT_RESET_KHR = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET_KHR = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET_KHR = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS_KHR = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY_KHR = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET_KHR = 33362;
    public static final int GL_NO_RESET_NOTIFICATION_KHR = 33377;
    public static final int GL_CONTEXT_LOST_KHR = 1287;
    public final long GetGraphicsResetStatusKHR;
    public final long ReadnPixelsKHR;
    public final long GetnUniformfvKHR;
    public final long GetnUniformivKHR;
    public final long GetnUniformuivKHR;

    protected KHRRobustness() {
        throw new UnsupportedOperationException();
    }

    public KHRRobustness(FunctionProvider provider) {
        this.GetGraphicsResetStatusKHR = provider.getFunctionAddress("glGetGraphicsResetStatusKHR");
        this.ReadnPixelsKHR = provider.getFunctionAddress("glReadnPixelsKHR");
        this.GetnUniformfvKHR = provider.getFunctionAddress("glGetnUniformfvKHR");
        this.GetnUniformivKHR = provider.getFunctionAddress("glGetnUniformivKHR");
        this.GetnUniformuivKHR = provider.getFunctionAddress("glGetnUniformuivKHR");
    }

    public static KHRRobustness getInstance() {
        return KHRRobustness.getInstance(GLES.getCapabilities());
    }

    public static KHRRobustness getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRRobustness);
    }

    static KHRRobustness create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_KHR_robustness")) {
            return null;
        }
        KHRRobustness funcs = new KHRRobustness(provider);
        boolean supported = Checks.checkFunctions(funcs.GetGraphicsResetStatusKHR, funcs.ReadnPixelsKHR, funcs.GetnUniformfvKHR, funcs.GetnUniformivKHR, funcs.GetnUniformuivKHR);
        return GLES.checkExtension("GL_KHR_robustness", funcs, supported);
    }

    public static int glGetGraphicsResetStatusKHR() {
        long __functionAddress = KHRRobustness.getInstance().GetGraphicsResetStatusKHR;
        return JNI.callI(__functionAddress);
    }

    public static void nglReadnPixelsKHR(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        long __functionAddress = KHRRobustness.getInstance().ReadnPixelsKHR;
        JNI.callIIIIIIIPV(__functionAddress, x, y, width, height, format, type, bufSize, pixels);
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, int bufSize, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLESChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, int bufSize, long pixelsOffset) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, true);
        }
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, bufSize, pixelsOffset);
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, ByteBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining(), MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixelsKHR(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixelsKHR(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetnUniformfvKHR(int program, int location, int bufSize, long params) {
        long __functionAddress = KHRRobustness.getInstance().GetnUniformfvKHR;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformfvKHR(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        KHRRobustness.nglGetnUniformfvKHR(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformfvKHR(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformfvKHR(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformfKHR(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        KHRRobustness.nglGetnUniformfvKHR(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformivKHR(int program, int location, int bufSize, long params) {
        long __functionAddress = KHRRobustness.getInstance().GetnUniformivKHR;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformivKHR(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        KHRRobustness.nglGetnUniformivKHR(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformivKHR(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformivKHR(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformiKHR(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        KHRRobustness.nglGetnUniformivKHR(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetnUniformuivKHR(int program, int location, int bufSize, long params) {
        long __functionAddress = KHRRobustness.getInstance().GetnUniformuivKHR;
        JNI.callIIIPV(__functionAddress, program, location, bufSize, params);
    }

    public static void glGetnUniformuivKHR(int program, int location, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        KHRRobustness.nglGetnUniformuivKHR(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformuivKHR(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformuivKHR(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static float glGetnUniformuiKHR(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        KHRRobustness.nglGetnUniformuivKHR(program, location, 1, __buffer.address(params));
        return __buffer.floatValue(params);
    }
}

