/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVSampleLocations {
    public static final int GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = 37693;
    public static final int GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = 37694;
    public static final int GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = 37695;
    public static final int GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = 37696;
    public static final int GL_SAMPLE_LOCATION_NV = 36432;
    public static final int GL_PROGRAMMABLE_SAMPLE_LOCATION_NV = 37697;
    public static final int GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = 37698;
    public static final int GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = 37699;
    public final long FramebufferSampleLocationsfvNV;
    public final long NamedFramebufferSampleLocationsfvNV;
    public final long ResolveDepthValuesNV;

    protected NVSampleLocations() {
        throw new UnsupportedOperationException();
    }

    public NVSampleLocations(FunctionProvider provider) {
        this.FramebufferSampleLocationsfvNV = provider.getFunctionAddress("glFramebufferSampleLocationsfvNV");
        this.NamedFramebufferSampleLocationsfvNV = provider.getFunctionAddress("glNamedFramebufferSampleLocationsfvNV");
        this.ResolveDepthValuesNV = provider.getFunctionAddress("glResolveDepthValuesNV");
    }

    public static NVSampleLocations getInstance() {
        return NVSampleLocations.getInstance(GLES.getCapabilities());
    }

    public static NVSampleLocations getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVSampleLocations);
    }

    static NVSampleLocations create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_sample_locations")) {
            return null;
        }
        NVSampleLocations funcs = new NVSampleLocations(provider);
        boolean supported = Checks.checkFunctions(funcs.FramebufferSampleLocationsfvNV, funcs.NamedFramebufferSampleLocationsfvNV, funcs.ResolveDepthValuesNV);
        return GLES.checkExtension("GL_NV_sample_locations", funcs, supported);
    }

    public static void nglFramebufferSampleLocationsfvNV(int target, int start, int count, long v) {
        long __functionAddress = NVSampleLocations.getInstance().FramebufferSampleLocationsfvNV;
        JNI.callIIIPV(__functionAddress, target, start, count, v);
    }

    public static void glFramebufferSampleLocationsfvNV(int target, int start, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2);
        }
        NVSampleLocations.nglFramebufferSampleLocationsfvNV(target, start, count, MemoryUtil.memAddress(v));
    }

    public static void glFramebufferSampleLocationsfvNV(int target, int start, FloatBuffer v) {
        NVSampleLocations.nglFramebufferSampleLocationsfvNV(target, start, v.remaining(), MemoryUtil.memAddress(v));
    }

    public static void nglNamedFramebufferSampleLocationsfvNV(int framebuffer, int start, int count, long v) {
        long __functionAddress = NVSampleLocations.getInstance().NamedFramebufferSampleLocationsfvNV;
        JNI.callIIIPV(__functionAddress, framebuffer, start, count, v);
    }

    public static void glNamedFramebufferSampleLocationsfvNV(int framebuffer, int start, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2);
        }
        NVSampleLocations.nglNamedFramebufferSampleLocationsfvNV(framebuffer, start, count, MemoryUtil.memAddress(v));
    }

    public static void glNamedFramebufferSampleLocationsfvNV(int framebuffer, int start, FloatBuffer v) {
        NVSampleLocations.nglNamedFramebufferSampleLocationsfvNV(framebuffer, start, v.remaining(), MemoryUtil.memAddress(v));
    }

    public static void glResolveDepthValuesNV() {
        long __functionAddress = NVSampleLocations.getInstance().ResolveDepthValuesNV;
        JNI.callV(__functionAddress);
    }
}

