/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVViewportArray {
    public static final int GL_MAX_VIEWPORTS_NV = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS_NV = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE_NV = 33373;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = 33375;
    public final long ViewportArrayvNV;
    public final long ViewportIndexedfNV;
    public final long ViewportIndexedfvNV;
    public final long ScissorArrayvNV;
    public final long ScissorIndexedNV;
    public final long ScissorIndexedvNV;
    public final long DepthRangeArrayfvNV;
    public final long DepthRangeIndexedfNV;
    public final long GetFloati_vNV;
    public final long EnableiNV;
    public final long DisableiNV;
    public final long IsEnablediNV;

    protected NVViewportArray() {
        throw new UnsupportedOperationException();
    }

    public NVViewportArray(FunctionProvider provider) {
        this.ViewportArrayvNV = provider.getFunctionAddress("glViewportArrayvNV");
        this.ViewportIndexedfNV = provider.getFunctionAddress("glViewportIndexedfNV");
        this.ViewportIndexedfvNV = provider.getFunctionAddress("glViewportIndexedfvNV");
        this.ScissorArrayvNV = provider.getFunctionAddress("glScissorArrayvNV");
        this.ScissorIndexedNV = provider.getFunctionAddress("glScissorIndexedNV");
        this.ScissorIndexedvNV = provider.getFunctionAddress("glScissorIndexedvNV");
        this.DepthRangeArrayfvNV = provider.getFunctionAddress("glDepthRangeArrayfvNV");
        this.DepthRangeIndexedfNV = provider.getFunctionAddress("glDepthRangeIndexedfNV");
        this.GetFloati_vNV = provider.getFunctionAddress("glGetFloati_vNV");
        this.EnableiNV = provider.getFunctionAddress("glEnableiNV");
        this.DisableiNV = provider.getFunctionAddress("glDisableiNV");
        this.IsEnablediNV = provider.getFunctionAddress("glIsEnablediNV");
    }

    public static NVViewportArray getInstance() {
        return NVViewportArray.getInstance(GLES.getCapabilities());
    }

    public static NVViewportArray getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVViewportArray);
    }

    static NVViewportArray create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_viewport_array")) {
            return null;
        }
        NVViewportArray funcs = new NVViewportArray(provider);
        boolean supported = Checks.checkFunctions(funcs.ViewportArrayvNV, funcs.ViewportIndexedfNV, funcs.ViewportIndexedfvNV, funcs.ScissorArrayvNV, funcs.ScissorIndexedNV, funcs.ScissorIndexedvNV, funcs.DepthRangeArrayfvNV, funcs.DepthRangeIndexedfNV, funcs.GetFloati_vNV, funcs.EnableiNV, funcs.DisableiNV, funcs.IsEnablediNV);
        return GLES.checkExtension("GL_NV_viewport_array", funcs, supported);
    }

    public static void nglViewportArrayvNV(int first, int count, long v) {
        long __functionAddress = NVViewportArray.getInstance().ViewportArrayvNV;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glViewportArrayvNV(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        NVViewportArray.nglViewportArrayvNV(first, count, MemoryUtil.memAddress(v));
    }

    public static void glViewportArrayvNV(int first, FloatBuffer v) {
        NVViewportArray.nglViewportArrayvNV(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedfNV(int index, float x, float y, float w, float h) {
        long __functionAddress = NVViewportArray.getInstance().ViewportIndexedfNV;
        JNI.callIFFFFV(__functionAddress, index, x, y, w, h);
    }

    public static void nglViewportIndexedfvNV(int index, long v) {
        long __functionAddress = NVViewportArray.getInstance().ViewportIndexedfvNV;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glViewportIndexedfvNV(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        NVViewportArray.nglViewportIndexedfvNV(index, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedfvNV(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        NVViewportArray.nglViewportIndexedfvNV(index, MemoryUtil.memAddress(v));
    }

    public static void nglScissorArrayvNV(int first, int count, long v) {
        long __functionAddress = NVViewportArray.getInstance().ScissorArrayvNV;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glScissorArrayvNV(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        NVViewportArray.nglScissorArrayvNV(first, count, MemoryUtil.memAddress(v));
    }

    public static void glScissorArrayvNV(int first, IntBuffer v) {
        NVViewportArray.nglScissorArrayvNV(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexedNV(int index, int left, int bottom, int width, int height) {
        long __functionAddress = NVViewportArray.getInstance().ScissorIndexedNV;
        JNI.callIIIIIV(__functionAddress, index, left, bottom, width, height);
    }

    public static void nglScissorIndexedvNV(int index, long v) {
        long __functionAddress = NVViewportArray.getInstance().ScissorIndexedvNV;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glScissorIndexedvNV(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        NVViewportArray.nglScissorIndexedvNV(index, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexedvNV(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        NVViewportArray.nglScissorIndexedvNV(index, MemoryUtil.memAddress(v));
    }

    public static void nglDepthRangeArrayfvNV(int first, int count, long v) {
        long __functionAddress = NVViewportArray.getInstance().DepthRangeArrayfvNV;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glDepthRangeArrayfvNV(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 2);
        }
        NVViewportArray.nglDepthRangeArrayfvNV(first, count, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeArrayfvNV(int first, FloatBuffer v) {
        NVViewportArray.nglDepthRangeArrayfvNV(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeIndexedfNV(int index, float n, float f) {
        long __functionAddress = NVViewportArray.getInstance().DepthRangeIndexedfNV;
        JNI.callIFFV(__functionAddress, index, n, f);
    }

    public static void nglGetFloati_vNV(int target, int index, long data) {
        long __functionAddress = NVViewportArray.getInstance().GetFloati_vNV;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetFloati_vNV(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetFloati_vNV(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        NVViewportArray.nglGetFloati_vNV(target, index, MemoryUtil.memAddress(data));
    }

    public static float glGetFloatiNV(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.floatParam();
        NVViewportArray.nglGetFloati_vNV(target, index, __buffer.address(data));
        return __buffer.floatValue(data);
    }

    public static void glEnableiNV(int target, int index) {
        long __functionAddress = NVViewportArray.getInstance().EnableiNV;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static void glDisableiNV(int target, int index) {
        long __functionAddress = NVViewportArray.getInstance().DisableiNV;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static boolean glIsEnablediNV(int target, int index) {
        long __functionAddress = NVViewportArray.getInstance().IsEnablediNV;
        return JNI.callIIZ(__functionAddress, target, index);
    }
}

