/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLES20;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class OESGetProgramBinary {
    public static final int GL_PROGRAM_BINARY_LENGTH_OES = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS_OES = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS_OES = 34815;
    public final long GetProgramBinaryOES;
    public final long ProgramBinaryOES;

    protected OESGetProgramBinary() {
        throw new UnsupportedOperationException();
    }

    public OESGetProgramBinary(FunctionProvider provider) {
        this.GetProgramBinaryOES = provider.getFunctionAddress("glGetProgramBinaryOES");
        this.ProgramBinaryOES = provider.getFunctionAddress("glProgramBinaryOES");
    }

    public static OESGetProgramBinary getInstance() {
        return OESGetProgramBinary.getInstance(GLES.getCapabilities());
    }

    public static OESGetProgramBinary getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__OESGetProgramBinary);
    }

    static OESGetProgramBinary create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_OES_get_program_binary")) {
            return null;
        }
        OESGetProgramBinary funcs = new OESGetProgramBinary(provider);
        boolean supported = Checks.checkFunctions(funcs.GetProgramBinaryOES, funcs.ProgramBinaryOES);
        return GLES.checkExtension("GL_OES_get_program_binary", funcs, supported);
    }

    public static void nglGetProgramBinaryOES(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = OESGetProgramBinary.getInstance().GetProgramBinaryOES;
        JNI.callIIPPPV(__functionAddress, program, bufSize, length, binaryFormat, binary);
    }

    public static void glGetProgramBinaryOES(int program, int bufSize, ByteBuffer length, ByteBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binary, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 4);
        }
        OESGetProgramBinary.nglGetProgramBinaryOES(program, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void glGetProgramBinaryOES(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        OESGetProgramBinary.nglGetProgramBinaryOES(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static ByteBuffer glGetProgramBinaryOES(int program, int bufSize, IntBuffer binaryFormat) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        ByteBuffer binary = BufferUtils.createByteBuffer(bufSize);
        OESGetProgramBinary.nglGetProgramBinaryOES(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
        binary.limit(__buffer.intValue(length));
        return binary.slice();
    }

    public static ByteBuffer glGetProgramBinaryOES(int program, IntBuffer binaryFormat) {
        int bufSize = GLES20.glGetProgrami(program, 34625);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        ByteBuffer binary = BufferUtils.createByteBuffer(bufSize);
        OESGetProgramBinary.nglGetProgramBinaryOES(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
        binary.limit(__buffer.intValue(length));
        return binary.slice();
    }

    public static void nglProgramBinaryOES(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = OESGetProgramBinary.getInstance().ProgramBinaryOES;
        JNI.callIIPIV(__functionAddress, program, binaryFormat, binary, length);
    }

    public static void glProgramBinaryOES(int program, int binaryFormat, ByteBuffer binary, int length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binary, length);
        }
        OESGetProgramBinary.nglProgramBinaryOES(program, binaryFormat, MemoryUtil.memAddress(binary), length);
    }

    public static void glProgramBinaryOES(int program, int binaryFormat, ByteBuffer binary) {
        OESGetProgramBinary.nglProgramBinaryOES(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }
}

