/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLogCallback;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.libffi.Closure;

public class OVRInitParams
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int FLAGS;
    public static final int REQUESTEDMINORVERSION;
    public static final int LOGCALLBACK;
    public static final int USERDATA;
    public static final int CONNECTIONTIMEOUTMS;

    OVRInitParams(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRInitParams(long struct) {
        this(struct, null);
    }

    public OVRInitParams(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Flags() {
        return OVRInitParams.nFlags(this.address());
    }

    public int RequestedMinorVersion() {
        return OVRInitParams.nRequestedMinorVersion(this.address());
    }

    public OVRLogCallback LogCallback() {
        return OVRInitParams.nLogCallback(this.address());
    }

    public long UserData() {
        return OVRInitParams.nUserData(this.address());
    }

    public int ConnectionTimeoutMS() {
        return OVRInitParams.nConnectionTimeoutMS(this.address());
    }

    public OVRInitParams Flags(int value) {
        OVRInitParams.nFlags(this.address(), value);
        return this;
    }

    public OVRInitParams RequestedMinorVersion(int value) {
        OVRInitParams.nRequestedMinorVersion(this.address(), value);
        return this;
    }

    public OVRInitParams LogCallback(long value) {
        OVRInitParams.nLogCallback(this.address(), value);
        return this;
    }

    public OVRInitParams UserData(long value) {
        OVRInitParams.nUserData(this.address(), value);
        return this;
    }

    public OVRInitParams ConnectionTimeoutMS(int value) {
        OVRInitParams.nConnectionTimeoutMS(this.address(), value);
        return this;
    }

    public OVRInitParams set(int Flags, int RequestedMinorVersion, long LogCallback, long UserData, int ConnectionTimeoutMS) {
        this.Flags(Flags);
        this.RequestedMinorVersion(RequestedMinorVersion);
        this.LogCallback(LogCallback);
        this.UserData(UserData);
        this.ConnectionTimeoutMS(ConnectionTimeoutMS);
        return this;
    }

    public OVRInitParams nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRInitParams set(OVRInitParams src) {
        return this.nset(src.address());
    }

    public OVRInitParams set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRInitParams malloc() {
        return new OVRInitParams(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRInitParams calloc() {
        return new OVRInitParams(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRInitParams create() {
        return new OVRInitParams(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nRequestedMinorVersion(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REQUESTEDMINORVERSION);
    }

    public static OVRLogCallback nLogCallback(long struct) {
        return (OVRLogCallback)Closure.create(MemoryUtil.memGetAddress(struct + (long)LOGCALLBACK));
    }

    public static long nUserData(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USERDATA);
    }

    public static int nConnectionTimeoutMS(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CONNECTIONTIMEOUTMS);
    }

    public static void nFlags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nRequestedMinorVersion(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)REQUESTEDMINORVERSION, value);
    }

    public static void nLogCallback(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)LOGCALLBACK, value);
    }

    public static void nUserData(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)USERDATA, value);
    }

    public static void nConnectionTimeoutMS(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CONNECTIONTIMEOUTMS, value);
    }

    static {
        Struct.Layout layout = OVRInitParams.__struct(OVRInitParams.__member(4), OVRInitParams.__member(4), OVRInitParams.__member(Pointer.POINTER_SIZE), OVRInitParams.__member(Pointer.POINTER_SIZE), OVRInitParams.__member(4), OVRInitParams.__padding(4, true));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        REQUESTEDMINORVERSION = layout.offsetof(1);
        LOGCALLBACK = layout.offsetof(2);
        USERDATA = layout.offsetof(3);
        CONNECTIONTIMEOUTMS = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVRInitParams, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRInitParams newInstance(long address) {
            return new OVRInitParams(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Flags() {
            return OVRInitParams.nFlags(this.address());
        }

        public int RequestedMinorVersion() {
            return OVRInitParams.nRequestedMinorVersion(this.address());
        }

        public OVRLogCallback LogCallback() {
            return OVRInitParams.nLogCallback(this.address());
        }

        public long UserData() {
            return OVRInitParams.nUserData(this.address());
        }

        public int ConnectionTimeoutMS() {
            return OVRInitParams.nConnectionTimeoutMS(this.address());
        }

        public Buffer Flags(int value) {
            OVRInitParams.nFlags(this.address(), value);
            return this;
        }

        public Buffer RequestedMinorVersion(int value) {
            OVRInitParams.nRequestedMinorVersion(this.address(), value);
            return this;
        }

        public Buffer LogCallback(long value) {
            OVRInitParams.nLogCallback(this.address(), value);
            return this;
        }

        public Buffer UserData(long value) {
            OVRInitParams.nUserData(this.address(), value);
            return this;
        }

        public Buffer ConnectionTimeoutMS(int value) {
            OVRInitParams.nConnectionTimeoutMS(this.address(), value);
            return this;
        }
    }
}

