/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerDirect;
import org.lwjgl.ovr.OVRLayerEyeFov;
import org.lwjgl.ovr.OVRLayerEyeFovDepth;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRLayerQuad;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerUnion
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADER;
    public static final int EYEFOV;
    public static final int EYEFOVDEPTH;
    public static final int QUAD;
    public static final int DIRECT;

    OVRLayerUnion(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRLayerUnion(long struct) {
        this(struct, null);
    }

    public OVRLayerUnion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerUnion.nHeader(this.address());
    }

    public OVRLayerEyeFov EyeFov() {
        return OVRLayerUnion.nEyeFov(this.address());
    }

    public OVRLayerEyeFovDepth EyeFovDepth() {
        return OVRLayerUnion.nEyeFovDepth(this.address());
    }

    public OVRLayerQuad Quad() {
        return OVRLayerUnion.nQuad(this.address());
    }

    public OVRLayerDirect Direct() {
        return OVRLayerUnion.nDirect(this.address());
    }

    public OVRLayerUnion Header(OVRLayerHeader value) {
        OVRLayerUnion.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFov(OVRLayerEyeFov value) {
        OVRLayerUnion.nEyeFov(this.address(), value);
        return this;
    }

    public OVRLayerUnion EyeFovDepth(OVRLayerEyeFovDepth value) {
        OVRLayerUnion.nEyeFovDepth(this.address(), value);
        return this;
    }

    public OVRLayerUnion Quad(OVRLayerQuad value) {
        OVRLayerUnion.nQuad(this.address(), value);
        return this;
    }

    public OVRLayerUnion Direct(OVRLayerDirect value) {
        OVRLayerUnion.nDirect(this.address(), value);
        return this;
    }

    public OVRLayerUnion set(OVRLayerHeader Header2, OVRLayerEyeFov EyeFov, OVRLayerEyeFovDepth EyeFovDepth, OVRLayerQuad Quad, OVRLayerDirect Direct) {
        this.Header(Header2);
        this.EyeFov(EyeFov);
        this.EyeFovDepth(EyeFovDepth);
        this.Quad(Quad);
        this.Direct(Direct);
        return this;
    }

    public OVRLayerUnion nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerUnion set(OVRLayerUnion src) {
        return this.nset(src.address());
    }

    public OVRLayerUnion set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRLayerUnion malloc() {
        return new OVRLayerUnion(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerUnion calloc() {
        return new OVRLayerUnion(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerUnion create() {
        return new OVRLayerUnion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return new OVRLayerHeader(struct + (long)HEADER);
    }

    public static OVRLayerEyeFov nEyeFov(long struct) {
        return new OVRLayerEyeFov(struct + (long)EYEFOV);
    }

    public static OVRLayerEyeFovDepth nEyeFovDepth(long struct) {
        return new OVRLayerEyeFovDepth(struct + (long)EYEFOVDEPTH);
    }

    public static OVRLayerQuad nQuad(long struct) {
        return new OVRLayerQuad(struct + (long)QUAD);
    }

    public static OVRLayerDirect nDirect(long struct) {
        return new OVRLayerDirect(struct + (long)DIRECT);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nEyeFov(long struct, OVRLayerEyeFov value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EYEFOV, OVRLayerEyeFov.SIZEOF);
    }

    public static void nEyeFovDepth(long struct, OVRLayerEyeFovDepth value) {
        MemoryUtil.memCopy(value.address(), struct + (long)EYEFOVDEPTH, OVRLayerEyeFovDepth.SIZEOF);
    }

    public static void nQuad(long struct, OVRLayerQuad value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUAD, OVRLayerQuad.SIZEOF);
    }

    public static void nDirect(long struct, OVRLayerDirect value) {
        MemoryUtil.memCopy(value.address(), struct + (long)DIRECT, OVRLayerDirect.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRLayerUnion.__union(OVRLayerUnion.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.__ALIGNMENT), OVRLayerUnion.__member(OVRLayerEyeFov.SIZEOF, OVRLayerEyeFov.__ALIGNMENT), OVRLayerUnion.__member(OVRLayerEyeFovDepth.SIZEOF, OVRLayerEyeFovDepth.__ALIGNMENT), OVRLayerUnion.__member(OVRLayerQuad.SIZEOF, OVRLayerQuad.__ALIGNMENT), OVRLayerUnion.__member(OVRLayerDirect.SIZEOF, OVRLayerDirect.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADER = layout.offsetof(0);
        EYEFOV = layout.offsetof(1);
        EYEFOVDEPTH = layout.offsetof(2);
        QUAD = layout.offsetof(3);
        DIRECT = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerUnion, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRLayerUnion newInstance(long address) {
            return new OVRLayerUnion(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerUnion.nHeader(this.address());
        }

        public OVRLayerEyeFov EyeFov() {
            return OVRLayerUnion.nEyeFov(this.address());
        }

        public OVRLayerEyeFovDepth EyeFovDepth() {
            return OVRLayerUnion.nEyeFovDepth(this.address());
        }

        public OVRLayerQuad Quad() {
            return OVRLayerUnion.nQuad(this.address());
        }

        public OVRLayerDirect Direct() {
            return OVRLayerUnion.nDirect(this.address());
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerUnion.nHeader(this.address(), value);
            return this;
        }

        public Buffer EyeFov(OVRLayerEyeFov value) {
            OVRLayerUnion.nEyeFov(this.address(), value);
            return this;
        }

        public Buffer EyeFovDepth(OVRLayerEyeFovDepth value) {
            OVRLayerUnion.nEyeFovDepth(this.address(), value);
            return this;
        }

        public Buffer Quad(OVRLayerQuad value) {
            OVRLayerUnion.nQuad(this.address(), value);
            return this;
        }

        public Buffer Direct(OVRLayerDirect value) {
            OVRLayerUnion.nDirect(this.address(), value);
            return this;
        }
    }
}

