/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRQuatf;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRPosef
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ORIENTATION;
    public static final int POSITION;

    OVRPosef(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRPosef(long struct) {
        this(struct, null);
    }

    public OVRPosef(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRQuatf Orientation() {
        return OVRPosef.nOrientation(this.address());
    }

    public OVRVector3f Position() {
        return OVRPosef.nPosition(this.address());
    }

    public OVRPosef Orientation(OVRQuatf value) {
        OVRPosef.nOrientation(this.address(), value);
        return this;
    }

    public OVRPosef Position(OVRVector3f value) {
        OVRPosef.nPosition(this.address(), value);
        return this;
    }

    public OVRPosef set(OVRQuatf Orientation2, OVRVector3f Position) {
        this.Orientation(Orientation2);
        this.Position(Position);
        return this;
    }

    public OVRPosef nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRPosef set(OVRPosef src) {
        return this.nset(src.address());
    }

    public OVRPosef set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRPosef malloc() {
        return new OVRPosef(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRPosef calloc() {
        return new OVRPosef(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRPosef create() {
        return new OVRPosef(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRQuatf nOrientation(long struct) {
        return new OVRQuatf(struct + (long)ORIENTATION);
    }

    public static OVRVector3f nPosition(long struct) {
        return new OVRVector3f(struct + (long)POSITION);
    }

    public static void nOrientation(long struct, OVRQuatf value) {
        MemoryUtil.memCopy(value.address(), struct + (long)ORIENTATION, OVRQuatf.SIZEOF);
    }

    public static void nPosition(long struct, OVRVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)POSITION, OVRVector3f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRPosef.__struct(OVRPosef.__member(OVRQuatf.SIZEOF, OVRQuatf.__ALIGNMENT), OVRPosef.__member(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ORIENTATION = layout.offsetof(0);
        POSITION = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRPosef, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRPosef newInstance(long address) {
            return new OVRPosef(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRQuatf Orientation() {
            return OVRPosef.nOrientation(this.address());
        }

        public OVRVector3f Position() {
            return OVRPosef.nPosition(this.address());
        }

        public Buffer Orientation(OVRQuatf value) {
            OVRPosef.nOrientation(this.address(), value);
            return this;
        }

        public Buffer Position(OVRVector3f value) {
            OVRPosef.nPosition(this.address(), value);
            return this;
        }
    }
}

