/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.ovr.OVRTextureHeader;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTexture
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADER;
    public static final int PLATFORMDATA;

    OVRTexture(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRTexture(long struct) {
        this(struct, null);
    }

    public OVRTexture(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRTextureHeader Header() {
        return OVRTexture.nHeader(this.address());
    }

    public PointerBuffer PlatformData() {
        return OVRTexture.nPlatformData(this.address());
    }

    public long PlatformData(int index) {
        return OVRTexture.nPlatformData(this.address(), index);
    }

    public OVRTexture Header(OVRTextureHeader value) {
        OVRTexture.nHeader(this.address(), value);
        return this;
    }

    public OVRTexture PlatformData(PointerBuffer value) {
        OVRTexture.nPlatformData(this.address(), value);
        return this;
    }

    public OVRTexture PlatformData(int index, long value) {
        OVRTexture.nPlatformData(this.address(), index, value);
        return this;
    }

    public OVRTexture set(OVRTextureHeader Header2, PointerBuffer PlatformData) {
        this.Header(Header2);
        this.PlatformData(PlatformData);
        return this;
    }

    public OVRTexture nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRTexture set(OVRTexture src) {
        return this.nset(src.address());
    }

    public OVRTexture set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRTexture malloc() {
        return new OVRTexture(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTexture calloc() {
        return new OVRTexture(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTexture create() {
        return new OVRTexture(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRTextureHeader nHeader(long struct) {
        return new OVRTextureHeader(struct + (long)HEADER);
    }

    public static PointerBuffer nPlatformData(long struct) {
        return MemoryUtil.memPointerBuffer(struct + (long)PLATFORMDATA, 8);
    }

    public static long nPlatformData(long struct, int index) {
        return MemoryUtil.memGetAddress(struct + (long)PLATFORMDATA + (long)(index * Integer.MAX_VALUE));
    }

    public static void nHeader(long struct, OVRTextureHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRTextureHeader.SIZEOF);
    }

    public static void nPlatformData(long struct, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)PLATFORMDATA, value.remaining() * POINTER_SIZE);
    }

    public static void nPlatformData(long struct, int index, long value) {
        MemoryUtil.memPutAddress(struct + (long)PLATFORMDATA + (long)(index * POINTER_SIZE), value);
    }

    static {
        Struct.Layout layout = OVRTexture.__struct(OVRTexture.__member(OVRTextureHeader.SIZEOF, OVRTextureHeader.__ALIGNMENT), OVRTexture.__array(Pointer.POINTER_SIZE, 8));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADER = layout.offsetof(0);
        PLATFORMDATA = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRTexture, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRTexture newInstance(long address) {
            return new OVRTexture(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRTextureHeader Header() {
            return OVRTexture.nHeader(this.address());
        }

        public PointerBuffer PlatformData() {
            return OVRTexture.nPlatformData(this.address());
        }

        public long PlatformData(int index) {
            return OVRTexture.nPlatformData(this.address(), index);
        }

        public Buffer Header(OVRTextureHeader value) {
            OVRTexture.nHeader(this.address(), value);
            return this;
        }

        public Buffer PlatformData(PointerBuffer value) {
            OVRTexture.nPlatformData(this.address(), value);
            return this;
        }

        public Buffer PlatformData(int index, long value) {
            OVRTexture.nPlatformData(this.address(), index, value);
            return this;
        }
    }
}

