/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRPoseStatef;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRSensorData;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRTrackingState
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADPOSE;
    public static final int CAMERAPOSE;
    public static final int LEVELEDCAMERAPOSE;
    public static final int HANDPOSES;
    public static final int RAWSENSORDATA;
    public static final int STATUSFLAGS;
    public static final int HANDSTATUSFLAGS;
    public static final int LASTCAMERAFRAMECOUNTER;

    OVRTrackingState(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRTrackingState(long struct) {
        this(struct, null);
    }

    public OVRTrackingState(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRPoseStatef HeadPose() {
        return OVRTrackingState.nHeadPose(this.address());
    }

    public OVRPosef CameraPose() {
        return OVRTrackingState.nCameraPose(this.address());
    }

    public OVRPosef LeveledCameraPose() {
        return OVRTrackingState.nLeveledCameraPose(this.address());
    }

    public OVRPoseStatef.Buffer HandPoses() {
        return OVRTrackingState.nHandPoses(this.address());
    }

    public OVRPoseStatef HandPoses(int index) {
        return OVRTrackingState.nHandPoses(this.address(), index);
    }

    public OVRSensorData RawSensorData() {
        return OVRTrackingState.nRawSensorData(this.address());
    }

    public int StatusFlags() {
        return OVRTrackingState.nStatusFlags(this.address());
    }

    public IntBuffer HandStatusFlags() {
        return OVRTrackingState.nHandStatusFlags(this.address());
    }

    public int HandStatusFlags(int index) {
        return OVRTrackingState.nHandStatusFlags(this.address(), index);
    }

    public int LastCameraFrameCounter() {
        return OVRTrackingState.nLastCameraFrameCounter(this.address());
    }

    public static OVRTrackingState malloc() {
        return new OVRTrackingState(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRTrackingState calloc() {
        return new OVRTrackingState(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRTrackingState create() {
        return new OVRTrackingState(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRPoseStatef nHeadPose(long struct) {
        return new OVRPoseStatef(struct + (long)HEADPOSE);
    }

    public static OVRPosef nCameraPose(long struct) {
        return new OVRPosef(struct + (long)CAMERAPOSE);
    }

    public static OVRPosef nLeveledCameraPose(long struct) {
        return new OVRPosef(struct + (long)LEVELEDCAMERAPOSE);
    }

    public static OVRPoseStatef.Buffer nHandPoses(long struct) {
        return OVRPoseStatef.createBuffer(struct + (long)HANDPOSES, 2);
    }

    public static OVRPoseStatef nHandPoses(long struct, int index) {
        return new OVRPoseStatef(struct + (long)HANDPOSES + (long)(index * OVRPoseStatef.SIZEOF));
    }

    public static OVRSensorData nRawSensorData(long struct) {
        return new OVRSensorData(struct + (long)RAWSENSORDATA);
    }

    public static int nStatusFlags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STATUSFLAGS);
    }

    public static IntBuffer nHandStatusFlags(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)HANDSTATUSFLAGS, 2);
    }

    public static int nHandStatusFlags(long struct, int index) {
        return MemoryUtil.memGetInt(struct + (long)HANDSTATUSFLAGS + (long)(index * 4));
    }

    public static int nLastCameraFrameCounter(long struct) {
        return MemoryUtil.memGetInt(struct + (long)LASTCAMERAFRAMECOUNTER);
    }

    static {
        Struct.Layout layout = OVRTrackingState.__struct(OVRTrackingState.__member(OVRPoseStatef.SIZEOF, OVRPoseStatef.__ALIGNMENT), OVRTrackingState.__member(OVRPosef.SIZEOF, OVRPosef.__ALIGNMENT), OVRTrackingState.__member(OVRPosef.SIZEOF, OVRPosef.__ALIGNMENT), OVRTrackingState.__array(OVRPoseStatef.SIZEOF, OVRPoseStatef.__ALIGNMENT, 2), OVRTrackingState.__member(OVRSensorData.SIZEOF, OVRSensorData.__ALIGNMENT), OVRTrackingState.__member(4), OVRTrackingState.__array(4, 2), OVRTrackingState.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADPOSE = layout.offsetof(0);
        CAMERAPOSE = layout.offsetof(1);
        LEVELEDCAMERAPOSE = layout.offsetof(2);
        HANDPOSES = layout.offsetof(3);
        RAWSENSORDATA = layout.offsetof(4);
        STATUSFLAGS = layout.offsetof(5);
        HANDSTATUSFLAGS = layout.offsetof(6);
        LASTCAMERAFRAMECOUNTER = layout.offsetof(7);
    }

    public static final class Buffer
    extends StructBuffer<OVRTrackingState, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRTrackingState newInstance(long address) {
            return new OVRTrackingState(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRPoseStatef HeadPose() {
            return OVRTrackingState.nHeadPose(this.address());
        }

        public OVRPosef CameraPose() {
            return OVRTrackingState.nCameraPose(this.address());
        }

        public OVRPosef LeveledCameraPose() {
            return OVRTrackingState.nLeveledCameraPose(this.address());
        }

        public OVRPoseStatef.Buffer HandPoses() {
            return OVRTrackingState.nHandPoses(this.address());
        }

        public OVRPoseStatef HandPoses(int index) {
            return OVRTrackingState.nHandPoses(this.address(), index);
        }

        public OVRSensorData RawSensorData() {
            return OVRTrackingState.nRawSensorData(this.address());
        }

        public int StatusFlags() {
            return OVRTrackingState.nStatusFlags(this.address());
        }

        public IntBuffer HandStatusFlags() {
            return OVRTrackingState.nHandStatusFlags(this.address());
        }

        public int HandStatusFlags(int index) {
            return OVRTrackingState.nHandStatusFlags(this.address(), index);
        }

        public int LastCameraFrameCounter() {
            return OVRTrackingState.nLastCameraFrameCounter(this.address());
        }
    }
}

