/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRVector3f
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;
    public static final int Z;

    OVRVector3f(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRVector3f(long struct) {
        this(struct, null);
    }

    public OVRVector3f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return OVRVector3f.nx(this.address());
    }

    public float y() {
        return OVRVector3f.ny(this.address());
    }

    public float z() {
        return OVRVector3f.nz(this.address());
    }

    public OVRVector3f x(float value) {
        OVRVector3f.nx(this.address(), value);
        return this;
    }

    public OVRVector3f y(float value) {
        OVRVector3f.ny(this.address(), value);
        return this;
    }

    public OVRVector3f z(float value) {
        OVRVector3f.nz(this.address(), value);
        return this;
    }

    public OVRVector3f set(float x, float y, float z) {
        this.x(x);
        this.y(y);
        this.z(z);
        return this;
    }

    public OVRVector3f nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRVector3f set(OVRVector3f src) {
        return this.nset(src.address());
    }

    public OVRVector3f set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRVector3f malloc() {
        return new OVRVector3f(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRVector3f calloc() {
        return new OVRVector3f(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRVector3f create() {
        return new OVRVector3f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static float nz(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Z);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    public static void nz(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Z, value);
    }

    static {
        Struct.Layout layout = OVRVector3f.__struct(OVRVector3f.__member(4), OVRVector3f.__member(4), OVRVector3f.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        Z = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<OVRVector3f, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRVector3f newInstance(long address) {
            return new OVRVector3f(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return OVRVector3f.nx(this.address());
        }

        public float y() {
            return OVRVector3f.ny(this.address());
        }

        public float z() {
            return OVRVector3f.nz(this.address());
        }

        public Buffer x(float value) {
            OVRVector3f.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            OVRVector3f.ny(this.address(), value);
            return this;
        }

        public Buffer z(float value) {
            OVRVector3f.nz(this.address(), value);
            return this;
        }
    }
}

