/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.libffi.Closure;

public class STBIIOCallbacks
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int READ;
    public static final int SKIP;
    public static final int EOF;

    STBIIOCallbacks(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public STBIIOCallbacks(long struct) {
        this(struct, null);
    }

    public STBIIOCallbacks(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public STBIReadCallback read() {
        return STBIIOCallbacks.nread(this.address());
    }

    public STBISkipCallback skip() {
        return STBIIOCallbacks.nskip(this.address());
    }

    public STBIEOFCallback eof() {
        return STBIIOCallbacks.neof(this.address());
    }

    public STBIIOCallbacks read(long value) {
        STBIIOCallbacks.nread(this.address(), value);
        return this;
    }

    public STBIIOCallbacks skip(long value) {
        STBIIOCallbacks.nskip(this.address(), value);
        return this;
    }

    public STBIIOCallbacks eof(long value) {
        STBIIOCallbacks.neof(this.address(), value);
        return this;
    }

    public STBIIOCallbacks set(long read, long skip, long eof) {
        this.read(read);
        this.skip(skip);
        this.eof(eof);
        return this;
    }

    public STBIIOCallbacks nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public STBIIOCallbacks set(STBIIOCallbacks src) {
        return this.nset(src.address());
    }

    public STBIIOCallbacks set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static STBIIOCallbacks malloc() {
        return new STBIIOCallbacks(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static STBIIOCallbacks calloc() {
        return new STBIIOCallbacks(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static STBIIOCallbacks create() {
        return new STBIIOCallbacks(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static STBIReadCallback nread(long struct) {
        return (STBIReadCallback)Closure.create(MemoryUtil.memGetAddress(struct + (long)READ));
    }

    public static STBISkipCallback nskip(long struct) {
        return (STBISkipCallback)Closure.create(MemoryUtil.memGetAddress(struct + (long)SKIP));
    }

    public static STBIEOFCallback neof(long struct) {
        return (STBIEOFCallback)Closure.create(MemoryUtil.memGetAddress(struct + (long)EOF));
    }

    public static void nread(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)READ, value);
    }

    public static void nskip(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SKIP, value);
    }

    public static void neof(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)EOF, value);
    }

    static {
        Struct.Layout layout = STBIIOCallbacks.__struct(STBIIOCallbacks.__member(Pointer.POINTER_SIZE), STBIIOCallbacks.__member(Pointer.POINTER_SIZE), STBIIOCallbacks.__member(Pointer.POINTER_SIZE));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        READ = layout.offsetof(0);
        SKIP = layout.offsetof(1);
        EOF = layout.offsetof(2);
    }

    public static final class Buffer
    extends StructBuffer<STBIIOCallbacks, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected STBIIOCallbacks newInstance(long address) {
            return new STBIIOCallbacks(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public STBIReadCallback read() {
            return STBIIOCallbacks.nread(this.address());
        }

        public STBISkipCallback skip() {
            return STBIIOCallbacks.nskip(this.address());
        }

        public STBIEOFCallback eof() {
            return STBIIOCallbacks.neof(this.address());
        }

        public Buffer read(long value) {
            STBIIOCallbacks.nread(this.address(), value);
            return this;
        }

        public Buffer skip(long value) {
            STBIIOCallbacks.nskip(this.address(), value);
            return this;
        }

        public Buffer eof(long value) {
            STBIIOCallbacks.neof(this.address(), value);
            return this;
        }
    }
}

