/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class STBImageWrite {
    protected STBImageWrite() {
        throw new UnsupportedOperationException();
    }

    public static native int nstbi_write_png(long var0, int var2, int var3, int var4, long var5, int var7);

    public static int stbi_write_png(ByteBuffer filename, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_png(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes);
    }

    public static int stbi_write_png(CharSequence filename, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        return STBImageWrite.nstbi_write_png(__buffer.address(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes);
    }

    public static native int nstbi_write_bmp(long var0, int var2, int var3, int var4, long var5);

    public static int stbi_write_bmp(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_bmp(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static int stbi_write_bmp(CharSequence filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        return STBImageWrite.nstbi_write_bmp(__buffer.address(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_tga(long var0, int var2, int var3, int var4, long var5);

    public static int stbi_write_tga(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_tga(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static int stbi_write_tga(CharSequence filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        return STBImageWrite.nstbi_write_tga(__buffer.address(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native long nstbi_write_tga_with_rle();

    public static IntBuffer stbi_write_tga_with_rle() {
        long __result = STBImageWrite.nstbi_write_tga_with_rle();
        return MemoryUtil.memIntBuffer(__result, 1);
    }

    public static native int nstbi_write_hdr(long var0, int var2, int var3, int var4, long var5);

    public static int stbi_write_hdr(ByteBuffer filename, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkNT1(filename);
            Checks.checkBuffer((Buffer)data, w * h * comp << 2);
        }
        return STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static int stbi_write_hdr(ByteBuffer filename, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr(MemoryUtil.memAddress(filename), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static int stbi_write_hdr(CharSequence filename, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int filenameEncoded = __buffer.stringParamASCII(filename, true);
        return STBImageWrite.nstbi_write_hdr(__buffer.address(filenameEncoded), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_png_to_func(long var0, long var2, int var4, int var5, int var6, long var7, int var9);

    public static int stbi_write_png_to_func(STBIWriteCallback func, ByteBuffer context, int w, int h, int comp, ByteBuffer data, int stride_in_bytes) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_png_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data), stride_in_bytes);
    }

    public static native int nstbi_write_bmp_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static int stbi_write_bmp_to_func(STBIWriteCallback func, ByteBuffer context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_bmp_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_tga_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static int stbi_write_tga_to_func(STBIWriteCallback func, ByteBuffer context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_tga_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static native int nstbi_write_hdr_to_func(long var0, long var2, int var4, int var5, int var6, long var7);

    public static int stbi_write_hdr_to_func(STBIWriteCallback func, ByteBuffer context, int w, int h, int comp, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp << 2);
        }
        return STBImageWrite.nstbi_write_hdr_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    public static int stbi_write_hdr_to_func(STBIWriteCallback func, ByteBuffer context, int w, int h, int comp, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, w * h * comp);
        }
        return STBImageWrite.nstbi_write_hdr_to_func(func.address(), MemoryUtil.memAddressSafe(context), w, h, comp, MemoryUtil.memAddress(data));
    }

    static {
        Library.initialize();
    }
}

