/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.UUID;
import java.util.zip.CRC32;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Configuration;

final class SharedLibraryLoader {
    private static final boolean LINUX;
    private static final boolean MACOSX;
    private static final boolean WINDOWS;
    private static final boolean AOT;
    private static final boolean ARM;
    private static final boolean x64;
    private static final String ABI;
    private static final EnumSet<Library> loadedLibraries;

    private SharedLibraryLoader() {
    }

    static void load() {
        if (AOT || !loadedLibraries.isEmpty()) {
            return;
        }
        try {
            Method method = Class.forName("javax.jnlp.ServiceManager").getDeclaredMethod("lookup", String.class);
            method.invoke(null, "javax.jnlp.PersistenceService");
            return;
        }
        catch (Throwable method) {
            File extractPath;
            Library[] libraries = Library.values();
            try {
                extractPath = SharedLibraryLoader.extractFile(libraries[0].file, null).getParentFile();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to extract LWJGL natives", e);
            }
            for (int i = 1; i < libraries.length; ++i) {
                try {
                    SharedLibraryLoader.extractFile(libraries[i].file, extractPath);
                    continue;
                }
                catch (Exception e) {
                    APIUtil.apiLog("Failed to extract " + libraries[i].name() + " library");
                }
            }
            String libraryPath = (String)Configuration.LIBRARY_PATH.get();
            libraryPath = libraryPath == null || libraryPath.isEmpty() ? extractPath.getAbsolutePath() : extractPath.getAbsolutePath() + File.pathSeparator + libraryPath;
            APIUtil.apiLog("Extracted shared libraries to: " + libraryPath);
            System.setProperty(Configuration.LIBRARY_PATH.getProperty(), libraryPath);
            Configuration.LIBRARY_PATH.set(libraryPath);
            return;
        }
    }

    private static File extractFile(String libraryFile, File libraryPath) throws IOException {
        String libraryCRC = SharedLibraryLoader.crc(SharedLibraryLoader.readResource(libraryFile));
        File extractedFile = SharedLibraryLoader.getExtractedFile(libraryPath == null ? new File(libraryCRC) : libraryPath, new File(libraryFile).getName());
        SharedLibraryLoader.extractFile(libraryFile, libraryCRC, extractedFile);
        return extractedFile;
    }

    private static File getExtractedFile(File libraryPath, String fileName) {
        if (libraryPath.isDirectory()) {
            return new File(libraryPath, fileName);
        }
        String tempDirectory = Configuration.SHARED_LIBRARY_TEMP_DIRECTORY.get("lwjgl" + System.getProperty("user.name"));
        File file = new File(System.getProperty("java.io.tmpdir") + "/" + tempDirectory + "/" + libraryPath, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        tempDirectory = Configuration.SHARED_LIBRARY_TEMP_DIRECTORY.get("lwjgl");
        file = new File(System.getProperty("user.home") + "/." + tempDirectory + "/" + libraryPath, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        file = new File("." + tempDirectory + "/" + libraryPath, fileName);
        if (SharedLibraryLoader.canWrite(file)) {
            return file;
        }
        try {
            file = File.createTempFile(libraryPath.getName(), null);
            if (file.delete() && SharedLibraryLoader.canWrite(file = new File(file, fileName))) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new RuntimeException("Failed to find an appropriate directory to extract the native library");
    }

    private static void extractFile(String libraryFile, String libraryCRC, File extractedFile) throws IOException {
        String extractedCrc = null;
        if (extractedFile.exists()) {
            try {
                extractedCrc = SharedLibraryLoader.crc(new FileInputStream(extractedFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        if (extractedCrc == null || !extractedCrc.equals(libraryCRC)) {
            int length;
            InputStream input = SharedLibraryLoader.readResource(libraryFile);
            extractedFile.getParentFile().mkdirs();
            FileOutputStream output = new FileOutputStream(extractedFile);
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            input.close();
            output.close();
        }
    }

    private static InputStream readResource(String path) {
        InputStream input = SharedLibraryLoader.class.getResourceAsStream("/" + path);
        if (input == null) {
            throw new RuntimeException("Unable to read file for extraction: " + path);
        }
        return input;
    }

    private static String crc(InputStream input) {
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception e) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return Long.toHexString(crc.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canWrite(File file) {
        File testFile;
        File parent = file.getParentFile();
        if (file.exists()) {
            if (!file.canWrite() || !SharedLibraryLoader.canExecute(file)) {
                return false;
            }
            testFile = new File(parent, UUID.randomUUID().toString());
        } else {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                return false;
            }
            testFile = file;
        }
        try {
            new FileOutputStream(testFile).close();
            boolean bl = SharedLibraryLoader.canExecute(testFile);
            return bl;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            testFile.delete();
        }
    }

    private static boolean canExecute(File file) {
        try {
            Method canExecute = File.class.getMethod("canExecute", new Class[0]);
            if (((Boolean)canExecute.invoke((Object)file, new Object[0])).booleanValue()) {
                return true;
            }
            Method setExecutable = File.class.getMethod("setExecutable", Boolean.TYPE, Boolean.TYPE);
            setExecutable.invoke((Object)file, true, false);
            return (Boolean)canExecute.invoke((Object)file, new Object[0]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    static /* synthetic */ boolean access$000() {
        return WINDOWS;
    }

    static {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        LINUX = osName.contains("Linux");
        MACOSX = osName.contains("Mac");
        WINDOWS = osName.contains("Windows");
        String runtime = System.getProperty("java.runtime.name");
        AOT = (runtime == null || !runtime.contains("Android Runtime")) && !LINUX && !MACOSX && !WINDOWS;
        ARM = osArch.startsWith("arm");
        x64 = osArch.contains("64");
        String archABI = System.getProperty("sun.arch.abi");
        ABI = archABI != null ? archABI : "";
        loadedLibraries = EnumSet.noneOf(Library.class);
    }

    static enum Library {
        LWJGL("lwjgl"),
        JEMALLOC("jemalloc"),
        GLFW("glfw"),
        OPENAL(SharedLibraryLoader.access$000() ? "OpenAL" : "openal");

        final String file;

        private Library(String file) {
            String libname = file;
            if (LINUX && ARM) {
                libname = libname + "arm" + ABI;
            }
            if (!x64) {
                libname = libname + "32";
            }
            this.file = System.mapLibraryName(libname);
        }

        public String getFile() {
            return this.file;
        }
    }
}

