/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.libffi.FFIType;

public class FFICIF
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ABI;
    public static final int NARGS;
    public static final int ARG_TYPES;
    public static final int RTYPE;
    public static final int BYTES;
    public static final int FLAGS;

    FFICIF(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public FFICIF(long struct) {
        this(struct, null);
    }

    public FFICIF(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int abi() {
        return FFICIF.nabi(this.address());
    }

    public int nargs() {
        return FFICIF.nnargs(this.address());
    }

    public PointerBuffer arg_types(int capacity) {
        return FFICIF.narg_types(this.address(), capacity);
    }

    public FFIType rtype() {
        return FFICIF.nrtypeStruct(this.address());
    }

    public int bytes() {
        return FFICIF.nbytes(this.address());
    }

    public int flags() {
        return FFICIF.nflags(this.address());
    }

    public static FFICIF malloc() {
        return new FFICIF(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static FFICIF calloc() {
        return new FFICIF(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static FFICIF create() {
        return new FFICIF(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nabi(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ABI);
    }

    public static int nnargs(long struct) {
        return MemoryUtil.memGetInt(struct + (long)NARGS);
    }

    public static PointerBuffer narg_types(long struct, int capacity) {
        return MemoryUtil.memPointerBuffer(MemoryUtil.memGetAddress(struct + (long)ARG_TYPES), capacity);
    }

    public static FFIType nrtypeStruct(long struct) {
        return new FFIType(MemoryUtil.memGetAddress(struct + (long)RTYPE));
    }

    public static int nbytes(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BYTES);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    static {
        Struct.Layout layout = FFICIF.__struct(FFICIF.__member(4), FFICIF.__member(4), FFICIF.__member(Pointer.POINTER_SIZE), FFICIF.__member(Pointer.POINTER_SIZE), FFICIF.__member(4), FFICIF.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ABI = layout.offsetof(0);
        NARGS = layout.offsetof(1);
        ARG_TYPES = layout.offsetof(2);
        RTYPE = layout.offsetof(3);
        BYTES = layout.offsetof(4);
        FLAGS = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<FFICIF, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected FFICIF newInstance(long address) {
            return new FFICIF(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int abi() {
            return FFICIF.nabi(this.address());
        }

        public int nargs() {
            return FFICIF.nnargs(this.address());
        }

        public PointerBuffer arg_types(int capacity) {
            return FFICIF.narg_types(this.address(), capacity);
        }

        public FFIType rtype() {
            return FFICIF.nrtypeStruct(this.address());
        }

        public int bytes() {
            return FFICIF.nbytes(this.address());
        }

        public int flags() {
            return FFICIF.nflags(this.address());
        }
    }
}

