/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.linux.Visual;

public class XVisualInfo
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int VISUAL;
    public static final int VISUALID;
    public static final int SCREEN;
    public static final int DEPTH;
    public static final int CLASS;
    public static final int RED_MASK;
    public static final int GREEN_MASK;
    public static final int BLUE_MASK;
    public static final int COLORMAP_SIZE;
    public static final int BITS_PER_RGB;

    XVisualInfo(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public XVisualInfo(long struct) {
        this(struct, null);
    }

    public XVisualInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public Visual visual() {
        return XVisualInfo.nvisualStruct(this.address());
    }

    public long visualid() {
        return XVisualInfo.nvisualid(this.address());
    }

    public int screen() {
        return XVisualInfo.nscreen(this.address());
    }

    public int depth() {
        return XVisualInfo.ndepth(this.address());
    }

    public int class$() {
        return XVisualInfo.nclass$(this.address());
    }

    public long red_mask() {
        return XVisualInfo.nred_mask(this.address());
    }

    public long green_mask() {
        return XVisualInfo.ngreen_mask(this.address());
    }

    public long blue_mask() {
        return XVisualInfo.nblue_mask(this.address());
    }

    public int colormap_size() {
        return XVisualInfo.ncolormap_size(this.address());
    }

    public int bits_per_rgb() {
        return XVisualInfo.nbits_per_rgb(this.address());
    }

    public XVisualInfo visual(Visual value) {
        XVisualInfo.nvisual(this.address(), value);
        return this;
    }

    public XVisualInfo visualid(long value) {
        XVisualInfo.nvisualid(this.address(), value);
        return this;
    }

    public XVisualInfo screen(int value) {
        XVisualInfo.nscreen(this.address(), value);
        return this;
    }

    public XVisualInfo depth(int value) {
        XVisualInfo.ndepth(this.address(), value);
        return this;
    }

    public XVisualInfo class$(int value) {
        XVisualInfo.nclass$(this.address(), value);
        return this;
    }

    public XVisualInfo red_mask(long value) {
        XVisualInfo.nred_mask(this.address(), value);
        return this;
    }

    public XVisualInfo green_mask(long value) {
        XVisualInfo.ngreen_mask(this.address(), value);
        return this;
    }

    public XVisualInfo blue_mask(long value) {
        XVisualInfo.nblue_mask(this.address(), value);
        return this;
    }

    public XVisualInfo colormap_size(int value) {
        XVisualInfo.ncolormap_size(this.address(), value);
        return this;
    }

    public XVisualInfo bits_per_rgb(int value) {
        XVisualInfo.nbits_per_rgb(this.address(), value);
        return this;
    }

    public XVisualInfo set(Visual visual, long visualid, int screen, int depth, int class$, long red_mask, long green_mask, long blue_mask, int colormap_size, int bits_per_rgb) {
        this.visual(visual);
        this.visualid(visualid);
        this.screen(screen);
        this.depth(depth);
        this.class$(class$);
        this.red_mask(red_mask);
        this.green_mask(green_mask);
        this.blue_mask(blue_mask);
        this.colormap_size(colormap_size);
        this.bits_per_rgb(bits_per_rgb);
        return this;
    }

    public XVisualInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public XVisualInfo set(XVisualInfo src) {
        return this.nset(src.address());
    }

    public XVisualInfo set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static XVisualInfo malloc() {
        return new XVisualInfo(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static XVisualInfo calloc() {
        return new XVisualInfo(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static XVisualInfo create() {
        return new XVisualInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static Visual nvisualStruct(long struct) {
        return new Visual(MemoryUtil.memGetAddress(struct + (long)VISUAL));
    }

    public static long nvisualid(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)VISUALID);
    }

    public static int nscreen(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SCREEN);
    }

    public static int ndepth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPTH);
    }

    public static int nclass$(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CLASS);
    }

    public static long nred_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)RED_MASK);
    }

    public static long ngreen_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)GREEN_MASK);
    }

    public static long nblue_mask(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)BLUE_MASK);
    }

    public static int ncolormap_size(long struct) {
        return MemoryUtil.memGetInt(struct + (long)COLORMAP_SIZE);
    }

    public static int nbits_per_rgb(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BITS_PER_RGB);
    }

    public static void nvisual(long struct, Visual value) {
        MemoryUtil.memPutAddress(struct + (long)VISUAL, value.address());
    }

    public static void nvisualid(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)VISUALID, value);
    }

    public static void nscreen(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SCREEN, value);
    }

    public static void ndepth(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPTH, value);
    }

    public static void nclass$(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)CLASS, value);
    }

    public static void nred_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)RED_MASK, value);
    }

    public static void ngreen_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)GREEN_MASK, value);
    }

    public static void nblue_mask(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)BLUE_MASK, value);
    }

    public static void ncolormap_size(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)COLORMAP_SIZE, value);
    }

    public static void nbits_per_rgb(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BITS_PER_RGB, value);
    }

    static {
        Struct.Layout layout = XVisualInfo.__struct(XVisualInfo.__member(Pointer.POINTER_SIZE), XVisualInfo.__member(Pointer.POINTER_SIZE), XVisualInfo.__member(4), XVisualInfo.__member(4), XVisualInfo.__member(4), XVisualInfo.__member(Pointer.POINTER_SIZE), XVisualInfo.__member(Pointer.POINTER_SIZE), XVisualInfo.__member(Pointer.POINTER_SIZE), XVisualInfo.__member(4), XVisualInfo.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        VISUAL = layout.offsetof(0);
        VISUALID = layout.offsetof(1);
        SCREEN = layout.offsetof(2);
        DEPTH = layout.offsetof(3);
        CLASS = layout.offsetof(4);
        RED_MASK = layout.offsetof(5);
        GREEN_MASK = layout.offsetof(6);
        BLUE_MASK = layout.offsetof(7);
        COLORMAP_SIZE = layout.offsetof(8);
        BITS_PER_RGB = layout.offsetof(9);
    }

    public static final class Buffer
    extends StructBuffer<XVisualInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected XVisualInfo newInstance(long address) {
            return new XVisualInfo(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public Visual visual() {
            return XVisualInfo.nvisualStruct(this.address());
        }

        public long visualid() {
            return XVisualInfo.nvisualid(this.address());
        }

        public int screen() {
            return XVisualInfo.nscreen(this.address());
        }

        public int depth() {
            return XVisualInfo.ndepth(this.address());
        }

        public int class$() {
            return XVisualInfo.nclass$(this.address());
        }

        public long red_mask() {
            return XVisualInfo.nred_mask(this.address());
        }

        public long green_mask() {
            return XVisualInfo.ngreen_mask(this.address());
        }

        public long blue_mask() {
            return XVisualInfo.nblue_mask(this.address());
        }

        public int colormap_size() {
            return XVisualInfo.ncolormap_size(this.address());
        }

        public int bits_per_rgb() {
            return XVisualInfo.nbits_per_rgb(this.address());
        }

        public Buffer visual(Visual value) {
            XVisualInfo.nvisual(this.address(), value);
            return this;
        }

        public Buffer visualid(long value) {
            XVisualInfo.nvisualid(this.address(), value);
            return this;
        }

        public Buffer screen(int value) {
            XVisualInfo.nscreen(this.address(), value);
            return this;
        }

        public Buffer depth(int value) {
            XVisualInfo.ndepth(this.address(), value);
            return this;
        }

        public Buffer class$(int value) {
            XVisualInfo.nclass$(this.address(), value);
            return this;
        }

        public Buffer red_mask(long value) {
            XVisualInfo.nred_mask(this.address(), value);
            return this;
        }

        public Buffer green_mask(long value) {
            XVisualInfo.ngreen_mask(this.address(), value);
            return this;
        }

        public Buffer blue_mask(long value) {
            XVisualInfo.nblue_mask(this.address(), value);
            return this;
        }

        public Buffer colormap_size(int value) {
            XVisualInfo.ncolormap_size(this.address(), value);
            return this;
        }

        public Buffer bits_per_rgb(int value) {
            XVisualInfo.nbits_per_rgb(this.address(), value);
            return this;
        }
    }
}

