/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class POINTFLOAT
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int X;
    public static final int Y;

    POINTFLOAT(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public POINTFLOAT(long struct) {
        this(struct, null);
    }

    public POINTFLOAT(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float x() {
        return POINTFLOAT.nx(this.address());
    }

    public float y() {
        return POINTFLOAT.ny(this.address());
    }

    public POINTFLOAT x(float value) {
        POINTFLOAT.nx(this.address(), value);
        return this;
    }

    public POINTFLOAT y(float value) {
        POINTFLOAT.ny(this.address(), value);
        return this;
    }

    public POINTFLOAT set(float x, float y) {
        this.x(x);
        this.y(y);
        return this;
    }

    public POINTFLOAT nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public POINTFLOAT set(POINTFLOAT src) {
        return this.nset(src.address());
    }

    public POINTFLOAT set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static POINTFLOAT malloc() {
        return new POINTFLOAT(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static POINTFLOAT calloc() {
        return new POINTFLOAT(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static POINTFLOAT create() {
        return new POINTFLOAT(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static float nx(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)X);
    }

    public static float ny(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)Y);
    }

    public static void nx(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)X, value);
    }

    public static void ny(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)Y, value);
    }

    static {
        Struct.Layout layout = POINTFLOAT.__struct(POINTFLOAT.__member(4), POINTFLOAT.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<POINTFLOAT, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected POINTFLOAT newInstance(long address) {
            return new POINTFLOAT(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float x() {
            return POINTFLOAT.nx(this.address());
        }

        public float y() {
            return POINTFLOAT.ny(this.address());
        }

        public Buffer x(float value) {
            POINTFLOAT.nx(this.address(), value);
            return this;
        }

        public Buffer y(float value) {
            POINTFLOAT.ny(this.address(), value);
            return this;
        }
    }
}

