/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class WinBase {
    public static final int FALSE = 0;
    public static final int TRUE = 1;

    protected WinBase() {
        throw new UnsupportedOperationException();
    }

    public static native int GetLastError();

    public static native int getLastError();

    public static native long nGetModuleHandle(long var0);

    public static long GetModuleHandle(ByteBuffer moduleName) {
        if (Checks.CHECKS && moduleName != null) {
            Checks.checkNT2(moduleName);
        }
        return WinBase.nGetModuleHandle(MemoryUtil.memAddressSafe(moduleName));
    }

    public static long GetModuleHandle(CharSequence moduleName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int moduleNameEncoded = __buffer.stringParamUTF16(moduleName, true);
        return WinBase.nGetModuleHandle(__buffer.addressSafe(moduleName, moduleNameEncoded));
    }

    public static native long nLoadLibrary(long var0);

    public static long LoadLibrary(ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT2(name);
        }
        return WinBase.nLoadLibrary(MemoryUtil.memAddress(name));
    }

    public static long LoadLibrary(CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF16(name, true);
        return WinBase.nLoadLibrary(__buffer.address(nameEncoded));
    }

    public static native long nGetProcAddress(long var0, long var2);

    public static long GetProcAddress(long handle, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkPointer(handle);
            Checks.checkNT1(name);
        }
        return WinBase.nGetProcAddress(handle, MemoryUtil.memAddress(name));
    }

    public static long GetProcAddress(long handle, CharSequence name) {
        if (Checks.CHECKS) {
            Checks.checkPointer(handle);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return WinBase.nGetProcAddress(handle, __buffer.address(nameEncoded));
    }

    public static native int nFreeLibrary(long var0);

    public static int FreeLibrary(long handle) {
        if (Checks.CHECKS) {
            Checks.checkPointer(handle);
        }
        return WinBase.nFreeLibrary(handle);
    }

    static {
        Library.initialize();
    }
}

